/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.request;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankTaskSettings;

public record VoyageAIRerankRequestEntity(String model, String query, List<String> documents, @Nullable Boolean returnDocuments, @Nullable Integer topN, VoyageAIRerankTaskSettings taskSettings) implements ToXContentObject
{
    private static final String DOCUMENTS_FIELD = "documents";
    private static final String QUERY_FIELD = "query";
    private static final String MODEL_FIELD = "model";
    public static final String TRUNCATION_FIELD = "truncation";

    public VoyageAIRerankRequestEntity {
        Objects.requireNonNull(query);
        Objects.requireNonNull(documents);
        Objects.requireNonNull(model);
        Objects.requireNonNull(taskSettings);
    }

    public VoyageAIRerankRequestEntity(String query, List<String> input, @Nullable Boolean returnDocuments, @Nullable Integer topN, VoyageAIRerankTaskSettings taskSettings, String model) {
        this(model, query, input, returnDocuments, topN, taskSettings != null ? taskSettings : VoyageAIRerankTaskSettings.EMPTY_SETTINGS);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_FIELD, this.model);
        builder.field(QUERY_FIELD, this.query);
        builder.field(DOCUMENTS_FIELD, this.documents);
        if (this.returnDocuments != null) {
            builder.field("return_documents", this.returnDocuments);
        } else if (this.taskSettings.getDoesReturnDocuments() != null) {
            builder.field("return_documents", this.taskSettings.getDoesReturnDocuments());
        }
        if (this.topN != null) {
            builder.field("top_k", this.topN);
        } else if (this.taskSettings.getTopKDocumentsOnly() != null) {
            builder.field("top_k", this.taskSettings.getTopKDocumentsOnly());
        }
        if (this.taskSettings.getTruncation() != null) {
            builder.field(TRUNCATION_FIELD, this.taskSettings.getTruncation());
        }
        builder.endObject();
        return builder;
    }
}

