/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIResponseHandler;
import org.elasticsearch.xpack.inference.services.voyageai.action.VoyageAIActionVisitor;
import org.elasticsearch.xpack.inference.services.voyageai.embeddings.VoyageAIEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.voyageai.request.VoyageAIRerankRequest;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankModel;
import org.elasticsearch.xpack.inference.services.voyageai.response.VoyageAIEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.voyageai.response.VoyageAIRerankResponseEntity;

public class VoyageAIActionCreator
implements VoyageAIActionVisitor {
    public static final ResponseHandler EMBEDDINGS_HANDLER = new VoyageAIResponseHandler("voyageai text embedding", VoyageAIEmbeddingsResponseEntity::fromResponse);
    static final ResponseHandler RERANK_HANDLER = new VoyageAIResponseHandler("voyageai rerank", (request, response) -> VoyageAIRerankResponseEntity.fromResponse(response));
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public VoyageAIActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(VoyageAIEmbeddingsModel model, Map<String, Object> taskSettings) {
        VoyageAIEmbeddingsModel overriddenModel = VoyageAIEmbeddingsModel.of(model, taskSettings);
        GenericRequestManager<EmbeddingsInput> manager = new GenericRequestManager<EmbeddingsInput>(this.serviceComponents.threadPool(), overriddenModel, EMBEDDINGS_HANDLER, embeddingsInput -> new VoyageAIEmbeddingsRequest(embeddingsInput.getInputs(), embeddingsInput.getInputType(), overriddenModel), EmbeddingsInput.class);
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("VoyageAI embeddings");
        return new SenderExecutableAction(this.sender, manager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(VoyageAIRerankModel model, Map<String, Object> taskSettings) {
        VoyageAIRerankModel overriddenModel = VoyageAIRerankModel.of(model, taskSettings);
        GenericRequestManager<QueryAndDocsInputs> manager = new GenericRequestManager<QueryAndDocsInputs>(this.serviceComponents.threadPool(), overriddenModel, RERANK_HANDLER, rerankInput -> new VoyageAIRerankRequest(rerankInput.getQuery(), rerankInput.getChunks(), rerankInput.getReturnDocuments(), rerankInput.getTopN(), model), QueryAndDocsInputs.class);
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("VoyageAI rerank");
        return new SenderExecutableAction(this.sender, manager, failedToSendRequestErrorMessage);
    }
}

