/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.embeddings;

import java.util.Map;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.googlevertexai.GoogleVertexAiService;

public record GoogleVertexAiEmbeddingsRequestTaskSettings(@Nullable Boolean autoTruncate, @Nullable InputType inputType) {
    public static final GoogleVertexAiEmbeddingsRequestTaskSettings EMPTY_SETTINGS = new GoogleVertexAiEmbeddingsRequestTaskSettings(null, null);

    public static GoogleVertexAiEmbeddingsRequestTaskSettings fromMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        ValidationException validationException = new ValidationException();
        InputType inputType = ServiceUtils.extractOptionalEnum(map, "input_type", "task_settings", InputType::fromString, GoogleVertexAiService.VALID_INPUT_TYPE_VALUES, validationException);
        Boolean autoTruncate = ServiceUtils.extractOptionalBoolean(map, "auto_truncate", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new GoogleVertexAiEmbeddingsRequestTaskSettings(autoTruncate, inputType);
    }
}

