/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio.request;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.sender.ChatCompletionInput;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.googleaistudio.completion.GoogleAiStudioCompletionModel;
import org.elasticsearch.xpack.inference.services.googleaistudio.request.GoogleAiStudioCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.googleaistudio.request.GoogleAiStudioRequest;

public class GoogleAiStudioCompletionRequest
implements GoogleAiStudioRequest {
    private static final String ALT_PARAM = "alt";
    private static final String SSE_VALUE = "sse";
    private final ChatCompletionInput input;
    private final LazyInitializable<URI, RuntimeException> uri;
    private final GoogleAiStudioCompletionModel model;

    public GoogleAiStudioCompletionRequest(ChatCompletionInput input, GoogleAiStudioCompletionModel model) {
        this.input = Objects.requireNonNull(input);
        this.model = Objects.requireNonNull(model);
        this.uri = new LazyInitializable(() -> model.uri(input.stream()));
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = this.createHttpPost();
        String requestEntity = Strings.toString((ToXContent)new GoogleAiStudioCompletionRequestEntity(this.input.getInputs()));
        ByteArrayEntity byteEntity = new ByteArrayEntity(requestEntity.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaType());
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    private HttpPost createHttpPost() {
        try {
            URIBuilder uriBuilder = GoogleAiStudioRequest.builderWithApiKeyParameter((URI)this.uri.getOrCompute(), this.model.getSecretSettings());
            if (this.isStreaming()) {
                uriBuilder.addParameter(ALT_PARAM, SSE_VALUE);
            }
            return new HttpPost(uriBuilder.build());
        }
        catch (Exception e) {
            ValidationException validationException = new ValidationException((Throwable)e);
            validationException.addValidationError(e.getMessage());
            throw validationException;
        }
    }

    @Override
    public URI getURI() {
        return (URI)this.uri.getOrCompute();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public boolean isStreaming() {
        return this.input.stream();
    }
}

