/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai.response;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;
import org.elasticsearch.xpack.inference.services.contextualai.request.ContextualAiRerankRequest;

public class ContextualAiRerankResponseEntity {
    public static RankedDocsResults fromResponse(ContextualAiRerankRequest request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            List<RankedDocsResults.RankedDoc> rankedDocs = ContextualAiRerankResponseEntity.doParse(jsonParser);
            Stream<RankedDocsResults.RankedDoc> rankedDocsByRelevanceStream = rankedDocs.stream().sorted(Comparator.comparingDouble(RankedDocsResults.RankedDoc::relevanceScore).reversed());
            Stream<RankedDocsResults.RankedDoc> rankedDocStreamTopN = request.getTopN() == null ? rankedDocsByRelevanceStream : rankedDocsByRelevanceStream.limit(request.getTopN().intValue());
            RankedDocsResults rankedDocsResults = new RankedDocsResults(rankedDocStreamTopN.toList());
            return rankedDocsResults;
        }
    }

    private static List<RankedDocsResults.RankedDoc> doParse(XContentParser parser) throws IOException {
        ConstructingObjectParser<ResponseObject, Void> responseParser = ResponseParser.PARSER;
        ResponseObject responseObject = (ResponseObject)responseParser.apply(parser, null);
        return responseObject.results.stream().map(result -> new RankedDocsResults.RankedDoc(result.index.intValue(), result.relevanceScore.floatValue(), result.document)).toList();
    }

    private static class ResponseParser {
        private static final ConstructingObjectParser<ResponseObject, Void> PARSER = ResponseObject.PARSER;

        private ResponseParser() {
        }
    }

    private record ResponseObject(List<RankedDocEntry> results) {
        private static final ParseField RESULTS = new ParseField("results", new String[0]);
        private static final ConstructingObjectParser<ResponseObject, Void> PARSER = new ConstructingObjectParser("contextualai_rerank_response", true, args -> {
            List results = (List)args[0];
            return new ResponseObject(results);
        });

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), RankedDocEntry.PARSER, RESULTS);
        }
    }

    private record RankedDocEntry(Integer index, Float relevanceScore, @Nullable String document) {
        private static final ParseField INDEX = new ParseField("index", new String[0]);
        private static final ParseField RELEVANCE_SCORE = new ParseField("relevance_score", new String[0]);
        private static final ParseField DOCUMENT = new ParseField("document", new String[0]);
        private static final ConstructingObjectParser<RankedDocEntry, Void> PARSER = new ConstructingObjectParser("contextualai_ranked_doc", true, args -> new RankedDocEntry((Integer)args[0], (Float)args[1], (String)args[2]));

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), INDEX);
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), RELEVANCE_SCORE);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DOCUMENT);
        }
    }
}

