/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.request.v2;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;
import org.elasticsearch.xpack.inference.services.cohere.request.CohereRequest;

public class CohereV2CompletionRequest
extends CohereRequest {
    private final List<String> input;

    public CohereV2CompletionRequest(List<String> input, CohereCompletionModel model, boolean stream) {
        super(CohereAccount.of(model), model.getInferenceEntityId(), Objects.requireNonNull(model.getServiceSettings().modelId()), stream);
        this.input = Objects.requireNonNull(input);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("messages");
        builder.startObject();
        builder.field("role", "user");
        builder.field("content", this.input.getFirst());
        builder.endObject();
        builder.endArray();
        builder.field("model", this.getModelId());
        builder.field("stream", this.isStreaming());
        builder.endObject();
        return builder;
    }

    @Override
    protected List<String> pathSegments() {
        return List.of("v2", "chat");
    }
}

