/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.RankedDocsResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.BaseResponseEntity;

public class AzureAiStudioRerankResponseEntity
extends BaseResponseEntity {
    @Override
    protected InferenceServiceResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            RerankResult rerankResult = (RerankResult)RerankResult.PARSER.apply(jsonParser, null);
            RankedDocsResults rankedDocsResults = new RankedDocsResults(rerankResult.entries.stream().map(RerankResultEntry::toRankedDoc).toList());
            return rankedDocsResults;
        }
    }

    record RerankResult(List<RerankResultEntry> entries) {
        public static final ConstructingObjectParser<RerankResult, Void> PARSER = new ConstructingObjectParser(RerankResult.class.getSimpleName(), true, args -> new RerankResult((List)args[0]));

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> RerankResultEntry.PARSER.apply(arg_0, arg_1), new ParseField("results", new String[0]));
        }
    }

    record ObjectParser(String text) {
        public static final ConstructingObjectParser<ObjectParser, Void> PARSER = new ConstructingObjectParser(ObjectParser.class.getSimpleName(), args -> new ObjectParser((String)args[0]));

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("text", new String[0]));
        }
    }

    record RerankResultEntry(Float relevanceScore, Integer index, @Nullable ObjectParser document) {
        public static final ConstructingObjectParser<RerankResultEntry, Void> PARSER = new ConstructingObjectParser(RerankResultEntry.class.getSimpleName(), args -> new RerankResultEntry((Float)args[0], (Integer)args[1], (ObjectParser)args[2]));

        public RankedDocsResults.RankedDoc toRankedDoc() {
            return new RankedDocsResults.RankedDoc(this.index.intValue(), this.relevanceScore.floatValue(), this.document == null ? null : this.document.text);
        }

        static {
            PARSER.declareFloat(ConstructingObjectParser.constructorArg(), new ParseField("relevance_score", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (arg_0, arg_1) -> ObjectParser.PARSER.apply(arg_0, arg_1), new ParseField("document", new String[0]));
        }
    }
}

