/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioChatCompletionRequestManager;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioRerankRequestManager;
import org.elasticsearch.xpack.inference.services.azureaistudio.action.AzureAiStudioActionVisitor;
import org.elasticsearch.xpack.inference.services.azureaistudio.completion.AzureAiStudioChatCompletionModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.embeddings.AzureAiStudioEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.azureaistudio.rerank.AzureAiStudioRerankModel;

public class AzureAiStudioActionCreator
implements AzureAiStudioActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public AzureAiStudioActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(AzureAiStudioChatCompletionModel completionModel, Map<String, Object> taskSettings) {
        AzureAiStudioChatCompletionModel overriddenModel = AzureAiStudioChatCompletionModel.of(completionModel, taskSettings);
        AzureAiStudioChatCompletionRequestManager requestManager = new AzureAiStudioChatCompletionRequestManager(overriddenModel, this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("Azure AI Studio completion");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(AzureAiStudioEmbeddingsModel embeddingsModel, Map<String, Object> taskSettings) {
        AzureAiStudioEmbeddingsModel overriddenModel = AzureAiStudioEmbeddingsModel.of(embeddingsModel, taskSettings);
        AzureAiStudioEmbeddingsRequestManager requestManager = new AzureAiStudioEmbeddingsRequestManager(overriddenModel, this.serviceComponents.truncator(), this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("Azure AI Studio embeddings");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(AzureAiStudioRerankModel rerankModel, Map<String, Object> taskSettings) {
        AzureAiStudioRerankModel overriddenModel = AzureAiStudioRerankModel.of(rerankModel, taskSettings);
        AzureAiStudioRerankRequestManager requestManager = new AzureAiStudioRerankRequestManager(overriddenModel, this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage("Azure AI Studio rerank");
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }
}

