/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic;

import java.util.concurrent.Flow;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ChatCompletionErrorResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponseUtils;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicChatCompletionStreamingProcessor;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicResponseHandler;
import org.elasticsearch.xpack.inference.services.anthropic.response.AnthropicChatCompletionResponseEntity;

public class AnthropicChatCompletionResponseHandler
extends AnthropicResponseHandler {
    private static final String ANTHROPIC_ERROR = "anthropic_error";
    private static final UnifiedChatCompletionErrorParserContract ANTHROPIC_ERROR_PARSER = UnifiedChatCompletionErrorResponseUtils.createErrorParserWithStringify("anthropic_error");
    private final ChatCompletionErrorResponseHandler chatCompletionErrorResponseHandler = new ChatCompletionErrorResponseHandler(ANTHROPIC_ERROR_PARSER);

    public AnthropicChatCompletionResponseHandler(String requestType) {
        this(requestType, AnthropicChatCompletionResponseEntity::fromResponse);
    }

    private AnthropicChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, true);
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        AnthropicChatCompletionStreamingProcessor anthropicProcessor = new AnthropicChatCompletionStreamingProcessor((m, e) -> this.chatCompletionErrorResponseHandler.buildMidStreamChatCompletionError(request.getInferenceEntityId(), (String)m, (Exception)e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(anthropicProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)anthropicProcessor);
    }

    protected UnifiedChatCompletionException buildError(String message, Request request, HttpResult result) {
        return this.chatCompletionErrorResponseHandler.buildChatCompletionError(message, request, result);
    }
}

