/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.amazonbedrock.embeddings.AmazonBedrockEmbeddingsServiceSettings;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings.AmazonBedrockCohereEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.amazonbedrock.request.embeddings.AmazonBedrockTitanEmbeddingsRequestEntity;

public final class AmazonBedrockEmbeddingsEntityFactory {
    public static ToXContent createEntity(AmazonBedrockEmbeddingsModel model, Truncator.TruncationResult truncationResult, InputType inputType) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(truncationResult);
        AmazonBedrockEmbeddingsServiceSettings serviceSettings = model.getServiceSettings();
        List<String> truncatedInput = truncationResult.input();
        if (truncatedInput == null || truncatedInput.isEmpty()) {
            throw new ElasticsearchException("[input] cannot be null or empty", new Object[0]);
        }
        switch (serviceSettings.provider()) {
            case AMAZONTITAN: {
                if (truncatedInput.size() > 1) {
                    throw new ElasticsearchException("[input] cannot contain more than one string", new Object[0]);
                }
                return new AmazonBedrockTitanEmbeddingsRequestEntity(truncatedInput.get(0));
            }
            case COHERE: {
                return new AmazonBedrockCohereEmbeddingsRequestEntity(truncatedInput, inputType, model.getTaskSettings());
            }
        }
        return null;
    }
}

