/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch;

import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.BaseResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.response.AlibabaCloudSearchErrorResponseEntity;

public class AlibabaCloudSearchResponseHandler
extends BaseResponseHandler {
    public AlibabaCloudSearchResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, AlibabaCloudSearchErrorResponseEntity::fromResponse);
    }

    @Override
    protected void checkForFailureStatusCode(Request request, HttpResult result) throws RetryException {
        int statusCode = result.response().getStatusLine().getStatusCode();
        if (RestStatus.isSuccessful((int)statusCode)) {
            return;
        }
        if (statusCode >= 500) {
            throw new RetryException(false, this.buildError("Received a server error status code", request, result));
        }
        if (statusCode == 429) {
            throw new RetryException(true, this.buildError("Received a rate limit status code", request, result));
        }
        if (statusCode == 401) {
            throw new RetryException(false, this.buildError("Received an authentication error status code", request, result));
        }
        if (statusCode >= 300 && statusCode < 400) {
            throw new RetryException(false, this.buildError("Unhandled redirection", request, result));
        }
        throw new RetryException(false, this.buildError("Received an unsuccessful status code", request, result));
    }
}

