/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ai21;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class Ai21Model
extends RateLimitGroupingModel {
    protected URI uri;
    protected RateLimitSettings rateLimitSettings;

    protected Ai21Model(ModelConfigurations configurations, ModelSecrets secrets) {
        super(configurations, secrets);
    }

    protected Ai21Model(RateLimitGroupingModel model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.getServiceSettings().modelId(), this.getSecretSettings().apiKey());
    }

    public void setURI(String newUri) {
        try {
            this.uri = new URI(newUri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }
}

