/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.xpack.inference.InferenceFeatures;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;

public class InferenceEndpointRegistry {
    private static final Setting<Boolean> INFERENCE_ENDPOINT_CACHE_ENABLED = Setting.boolSetting((String)"xpack.inference.endpoint.cache.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final Setting<Integer> INFERENCE_ENDPOINT_CACHE_WEIGHT = Setting.intSetting((String)"xpack.inference.endpoint.cache.weight", (int)25, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<TimeValue> INFERENCE_ENDPOINT_CACHE_EXPIRY = Setting.timeSetting((String)"xpack.inference.endpoint.cache.expiry_time", (TimeValue)TimeValue.timeValueMinutes((long)15L), (TimeValue)TimeValue.timeValueMinutes((long)1L), (TimeValue)TimeValue.timeValueHours((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger log = LogManager.getLogger(InferenceEndpointRegistry.class);
    private static final Cache.Stats EMPTY = new Cache.Stats(0L, 0L, 0L);
    private final ModelRegistry modelRegistry;
    private final InferenceServiceRegistry serviceRegistry;
    private final ProjectResolver projectResolver;
    private final Cache<InferenceIdAndProject, Model> cache;
    private final ClusterService clusterService;
    private final FeatureService featureService;
    private volatile boolean cacheEnabledViaSetting;

    public static Collection<? extends Setting<?>> getSettingsDefinitions() {
        return List.of(INFERENCE_ENDPOINT_CACHE_ENABLED, INFERENCE_ENDPOINT_CACHE_WEIGHT, INFERENCE_ENDPOINT_CACHE_EXPIRY);
    }

    public InferenceEndpointRegistry(ClusterService clusterService, Settings settings, ModelRegistry modelRegistry, InferenceServiceRegistry serviceRegistry, ProjectResolver projectResolver, FeatureService featureService) {
        this.modelRegistry = modelRegistry;
        this.serviceRegistry = serviceRegistry;
        this.projectResolver = projectResolver;
        this.cache = CacheBuilder.builder().setMaximumWeight((long)((Integer)INFERENCE_ENDPOINT_CACHE_WEIGHT.get(settings)).intValue()).setExpireAfterWrite((TimeValue)INFERENCE_ENDPOINT_CACHE_EXPIRY.get(settings)).build();
        this.clusterService = clusterService;
        this.featureService = featureService;
        this.cacheEnabledViaSetting = (Boolean)INFERENCE_ENDPOINT_CACHE_ENABLED.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(INFERENCE_ENDPOINT_CACHE_ENABLED, enabled -> {
            this.cacheEnabledViaSetting = enabled;
        });
    }

    public void getEndpoint(String inferenceEntityId, ActionListener<Model> listener) {
        Model cachedModel;
        InferenceIdAndProject key = new InferenceIdAndProject(inferenceEntityId, this.projectResolver.getProjectId());
        Model model = cachedModel = this.cacheEnabled() ? (Model)this.cache.get((Object)key) : null;
        if (cachedModel != null) {
            log.trace("Retrieved [{}] from cache.", (Object)inferenceEntityId);
            listener.onResponse((Object)cachedModel);
        } else {
            this.loadFromIndex(key, listener);
        }
    }

    void invalidateAll(ProjectId projectId) {
        if (this.cacheEnabled()) {
            Iterator cacheKeys = this.cache.keys().iterator();
            while (cacheKeys.hasNext()) {
                if (!((InferenceIdAndProject)cacheKeys.next()).projectId.equals((Object)projectId)) continue;
                cacheKeys.remove();
            }
        }
    }

    private void loadFromIndex(InferenceIdAndProject idAndProject, ActionListener<Model> listener) {
        this.modelRegistry.getModelWithSecrets(idAndProject.inferenceEntityId(), (ActionListener<UnparsedModel>)listener.delegateFailureAndWrap((l, unparsedModel) -> {
            InferenceService service = (InferenceService)this.serviceRegistry.getService(unparsedModel.service()).orElseThrow(() -> new ResourceNotFoundException("Unknown service [{}] for model [{}]", new Object[]{unparsedModel.service(), idAndProject.inferenceEntityId()}));
            Model model = service.parsePersistedConfigWithSecrets(unparsedModel.inferenceEntityId(), unparsedModel.taskType(), unparsedModel.settings(), unparsedModel.secrets());
            if (this.cacheEnabled()) {
                this.cache.put((Object)idAndProject, (Object)model);
            }
            l.onResponse((Object)model);
        }));
    }

    public Cache.Stats stats() {
        return this.cacheEnabled() ? this.cache.stats() : EMPTY;
    }

    public int cacheCount() {
        return this.cacheEnabled() ? this.cache.count() : 0;
    }

    public boolean cacheEnabled() {
        return this.cacheEnabledViaSetting && this.cacheEnabledViaFeature();
    }

    private boolean cacheEnabledViaFeature() {
        ClusterState state = this.clusterService.state();
        return state.clusterRecovered() && this.featureService.clusterHasFeature(state, InferenceFeatures.INFERENCE_ENDPOINT_CACHE);
    }

    private record InferenceIdAndProject(String inferenceEntityId, ProjectId projectId) {
    }
}

