/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.plugins.internal.rewriter.QueryRewriteInterceptor;
import org.elasticsearch.xpack.inference.queries.SemanticQueryBuilder;

@Deprecated
public abstract class LegacySemanticQueryRewriteInterceptor
implements QueryRewriteInterceptor {
    public QueryBuilder interceptAndRewrite(QueryRewriteContext context, QueryBuilder queryBuilder) {
        String fieldName = this.getFieldName(queryBuilder);
        ResolvedIndices resolvedIndices = context.getResolvedIndices();
        if (resolvedIndices == null) {
            return queryBuilder;
        }
        InferenceIndexInformationForField indexInformation = this.resolveIndicesForField(fieldName, resolvedIndices);
        if (indexInformation.getInferenceIndices().isEmpty()) {
            return queryBuilder;
        }
        if (resolvedIndices.getRemoteClusterIndices().isEmpty()) {
            if (!indexInformation.nonInferenceIndices().isEmpty()) {
                return this.buildCombinedInferenceAndNonInferenceQuery(queryBuilder, indexInformation);
            }
            return this.buildInferenceQuery(queryBuilder, indexInformation);
        }
        throw new IllegalArgumentException(this.getQueryName() + " query does not support cross-cluster search when querying a [semantic_text] field in a mixed-version cluster. Please update all nodes to at least Elasticsearch " + SemanticQueryBuilder.SEMANTIC_SEARCH_CCS_SUPPORT.toReleaseVersion() + ".");
    }

    protected abstract String getFieldName(QueryBuilder var1);

    protected abstract String getQuery(QueryBuilder var1);

    protected abstract QueryBuilder buildInferenceQuery(QueryBuilder var1, InferenceIndexInformationForField var2);

    protected abstract QueryBuilder buildCombinedInferenceAndNonInferenceQuery(QueryBuilder var1, InferenceIndexInformationForField var2);

    private InferenceIndexInformationForField resolveIndicesForField(String fieldName, ResolvedIndices resolvedIndices) {
        Collection indexMetadataCollection = resolvedIndices.getConcreteLocalIndicesMetadata().values();
        HashMap<String, InferenceFieldMetadata> inferenceIndicesMetadata = new HashMap<String, InferenceFieldMetadata>();
        ArrayList<String> nonInferenceIndices = new ArrayList<String>();
        for (IndexMetadata indexMetadata : indexMetadataCollection) {
            String indexName = indexMetadata.getIndex().getName();
            InferenceFieldMetadata inferenceFieldMetadata = (InferenceFieldMetadata)indexMetadata.getInferenceFields().get(fieldName);
            if (inferenceFieldMetadata != null) {
                inferenceIndicesMetadata.put(indexName, inferenceFieldMetadata);
                continue;
            }
            nonInferenceIndices.add(indexName);
        }
        return new InferenceIndexInformationForField(fieldName, inferenceIndicesMetadata, nonInferenceIndices);
    }

    protected QueryBuilder createSubQueryForIndices(Collection<String> indices, QueryBuilder queryBuilder) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must(queryBuilder);
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("_index", indices));
        return boolQueryBuilder;
    }

    protected QueryBuilder createSemanticSubQuery(Collection<String> indices, String fieldName, String value) {
        BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
        boolQueryBuilder.must((QueryBuilder)new SemanticQueryBuilder(fieldName, value, (Boolean)true));
        boolQueryBuilder.filter((QueryBuilder)new TermsQueryBuilder("_index", indices));
        return boolQueryBuilder;
    }

    public record InferenceIndexInformationForField(String fieldName, Map<String, InferenceFieldMetadata> inferenceIndicesMetadata, List<String> nonInferenceIndices) {
        public Collection<String> getInferenceIndices() {
            return this.inferenceIndicesMetadata.keySet();
        }

        public Map<String, List<String>> getInferenceIdsIndices() {
            return this.inferenceIndicesMetadata.entrySet().stream().collect(Collectors.groupingBy(entry -> ((InferenceFieldMetadata)entry.getValue()).getSearchInferenceId(), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        }
    }
}

