/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.logging;

import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.logging.Throttler;

public class ThrottlerManager
implements Closeable {
    private static final TimeValue DEFAULT_STATS_RESET_INTERVAL_TIME = TimeValue.timeValueDays((long)1L);
    @Deprecated
    public static final Setting<TimeValue> STATS_RESET_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.inference.logging.reset_interval", (TimeValue)DEFAULT_STATS_RESET_INTERVAL_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_WAIT_DURATION_TIME = TimeValue.timeValueHours((long)1L);
    @Deprecated
    public static final Setting<TimeValue> LOGGER_WAIT_DURATION_SETTING = Setting.timeSetting((String)"xpack.inference.logging.wait_duration", (TimeValue)DEFAULT_WAIT_DURATION_TIME, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_LOG_EMIT_INTERVAL = TimeValue.timeValueHours((long)1L);
    public static final Setting<TimeValue> LOG_EMIT_INTERVAL = Setting.timeSetting((String)"xpack.inference.logging.interval", (TimeValue)DEFAULT_LOG_EMIT_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile TimeValue logInterval;
    private Throttler throttler;

    public ThrottlerManager(Settings settings, ThreadPool threadPool) {
        Objects.requireNonNull(settings);
        this.throttler = new Throttler((TimeValue)LOG_EMIT_INTERVAL.get(settings), threadPool);
        this.throttler.init();
    }

    public void init(ClusterService clusterService) {
        Objects.requireNonNull(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(LOG_EMIT_INTERVAL, this::setLogInterval);
    }

    void setLogInterval(TimeValue logInterval) {
        this.logInterval = logInterval;
        Throttler oldThrottler = this.throttler;
        this.throttler = new Throttler(oldThrottler, this.logInterval);
        this.throttler.init();
        oldThrottler.close();
    }

    Throttler getThrottler() {
        return this.throttler;
    }

    public void warn(Logger logger, String message, Throwable e) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(e);
        this.throttler.execute(logger, Level.WARN, message, e);
    }

    public void warn(Logger logger, String message) {
        Objects.requireNonNull(message);
        this.throttler.execute(logger, Level.WARN, message);
    }

    @Override
    public void close() {
        this.throttler.close();
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(LOG_EMIT_INTERVAL, STATS_RESET_INTERVAL_SETTING, LOGGER_WAIT_DURATION_SETTING);
    }
}

