/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponse;

public class UnifiedChatCompletionErrorResponseUtils {
    public static UnifiedChatCompletionErrorParserContract createErrorParserWithStringify(final String type) {
        return new UnifiedChatCompletionErrorParserContract(){

            @Override
            public UnifiedChatCompletionErrorResponse parse(HttpResult result) {
                try {
                    String errorMessage = new String(result.body(), StandardCharsets.UTF_8);
                    return new UnifiedChatCompletionErrorResponse(errorMessage, type, null, null);
                }
                catch (Exception exception) {
                    return UnifiedChatCompletionErrorResponse.UNDEFINED_ERROR;
                }
            }

            @Override
            public UnifiedChatCompletionErrorResponse parse(String result) {
                return new UnifiedChatCompletionErrorResponse(result, type, null, null);
            }
        };
    }

    public static UnifiedChatCompletionErrorParserContract createErrorParserWithObjectParser(ConstructingObjectParser<Optional<UnifiedChatCompletionErrorResponse>, Void> objectParser) {
        return new UnifiedChatCompletionErrorParser(parser -> (Optional)objectParser.apply(parser, null));
    }

    public static <E extends Exception> UnifiedChatCompletionErrorParserContract createErrorParserWithGenericParser(CheckedFunction<XContentParser, Optional<UnifiedChatCompletionErrorResponse>, E> genericParser) {
        return new UnifiedChatCompletionErrorParser<E>(genericParser);
    }

    private static Callable<XContentParser> createHttpResultXContentParserFunction(HttpResult response) {
        return () -> XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response.body());
    }

    private static Callable<XContentParser> createStringXContentParserFunction(String response) {
        return () -> XContentFactory.xContent((XContentType)XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, response);
    }

    private static <E extends Exception> UnifiedChatCompletionErrorResponse executeGenericParser(CheckedFunction<XContentParser, Optional<UnifiedChatCompletionErrorResponse>, E> genericParser, Callable<XContentParser> createXContentParser) {
        UnifiedChatCompletionErrorResponse unifiedChatCompletionErrorResponse;
        block8: {
            XContentParser parser = createXContentParser.call();
            try {
                unifiedChatCompletionErrorResponse = ((Optional)genericParser.apply((Object)parser)).orElse(UnifiedChatCompletionErrorResponse.UNDEFINED_ERROR);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return UnifiedChatCompletionErrorResponse.UNDEFINED_ERROR;
                }
            }
            parser.close();
        }
        return unifiedChatCompletionErrorResponse;
    }

    private UnifiedChatCompletionErrorResponseUtils() {
    }

    private record UnifiedChatCompletionErrorParser<E extends Exception>(CheckedFunction<XContentParser, Optional<UnifiedChatCompletionErrorResponse>, E> genericParser) implements UnifiedChatCompletionErrorParserContract
    {
        @Override
        public UnifiedChatCompletionErrorResponse parse(HttpResult result) {
            return UnifiedChatCompletionErrorResponseUtils.executeGenericParser(this.genericParser, UnifiedChatCompletionErrorResponseUtils.createHttpResultXContentParserFunction(result));
        }

        @Override
        public UnifiedChatCompletionErrorResponse parse(String result) {
            return UnifiedChatCompletionErrorResponseUtils.executeGenericParser(this.genericParser, UnifiedChatCompletionErrorResponseUtils.createStringXContentParserFunction(result));
        }
    }
}

