/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.windows.service;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.Build;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.windows.service.ProcrunCommand;

class WindowsServiceInstallCommand
extends ProcrunCommand {
    WindowsServiceInstallCommand() {
        super("Install Elasticsearch as a Windows Service", "IS");
    }

    @Override
    protected String getAdditionalArgs(String serviceId, ProcessInfo pinfo) {
        ArrayList<String> args = new ArrayList<String>();
        WindowsServiceInstallCommand.addArg(args, "--Startup", pinfo.envVars().getOrDefault("ES_START_TYPE", "manual"));
        WindowsServiceInstallCommand.addArg(args, "--StopTimeout", pinfo.envVars().getOrDefault("ES_STOP_TIMEOUT", "0"));
        WindowsServiceInstallCommand.addArg(args, "--StartClass", "org.elasticsearch.launcher.CliToolLauncher");
        WindowsServiceInstallCommand.addArg(args, "--StartMethod", "main");
        WindowsServiceInstallCommand.addArg(args, "--StopClass", "org.elasticsearch.launcher.CliToolLauncher");
        WindowsServiceInstallCommand.addArg(args, "--StopMethod", "close");
        WindowsServiceInstallCommand.addArg(args, "--Classpath", (String)pinfo.sysprops().get("java.class.path"));
        WindowsServiceInstallCommand.addArg(args, "--JvmMs", "4m");
        WindowsServiceInstallCommand.addArg(args, "--JvmMx", "64m");
        WindowsServiceInstallCommand.addQuotedArg(args, "--JvmOptions", WindowsServiceInstallCommand.getJvmOptions(pinfo.sysprops()));
        WindowsServiceInstallCommand.addArg(args, "--PidFile", String.format(Locale.ROOT, "%s.pid", serviceId));
        WindowsServiceInstallCommand.addArg(args, "--DisplayName", pinfo.envVars().getOrDefault("SERVICE_DISPLAY_NAME", "Elasticsearch %s (%s)".formatted(Build.current().version(), serviceId)));
        WindowsServiceInstallCommand.addArg(args, "--Description", pinfo.envVars().getOrDefault("SERVICE_DESCRIPTION", String.format(Locale.ROOT, "Elasticsearch %s Windows Service - https://elastic.co", Build.current().version())));
        WindowsServiceInstallCommand.addQuotedArg(args, "--Jvm", WindowsServiceInstallCommand.quote(WindowsServiceInstallCommand.getJvmDll(WindowsServiceInstallCommand.getJavaHome(pinfo.sysprops())).toString()));
        WindowsServiceInstallCommand.addArg(args, "--StartMode", "jvm");
        WindowsServiceInstallCommand.addArg(args, "--StopMode", "jvm");
        WindowsServiceInstallCommand.addQuotedArg(args, "--StartPath", WindowsServiceInstallCommand.quote(pinfo.workingDir().toString()));
        WindowsServiceInstallCommand.addArg(args, "++JvmOptions", "-Dcli.name=windows-service-daemon");
        WindowsServiceInstallCommand.addArg(args, "++JvmOptions", "-Dcli.libs=lib/tools/server-cli,lib/tools/windows-service-cli");
        WindowsServiceInstallCommand.addArg(args, "++Environment", String.format(Locale.ROOT, "HOSTNAME=%s", pinfo.envVars().get("COMPUTERNAME")));
        String serviceUsername = (String)pinfo.envVars().get("SERVICE_USERNAME");
        if (serviceUsername != null) {
            String servicePassword = (String)pinfo.envVars().get("SERVICE_PASSWORD");
            assert (servicePassword != null);
            WindowsServiceInstallCommand.addArg(args, "--ServiceUser", serviceUsername);
            WindowsServiceInstallCommand.addArg(args, "--ServicePassword", servicePassword);
        } else {
            WindowsServiceInstallCommand.addArg(args, "--ServiceUser", "LocalSystem");
        }
        String serviceParams = (String)pinfo.envVars().get("SERVICE_PARAMS");
        if (serviceParams != null) {
            args.add(serviceParams);
        }
        return String.join((CharSequence)" ", args);
    }

    private static void addArg(List<String> args, String arg, String value) {
        args.add(arg);
        if (value.contains(" ")) {
            value = String.format(Locale.ROOT, "\"%s\"", value);
        }
        args.add(value);
    }

    private static void addQuotedArg(List<String> args, String arg, String value) {
        args.add(arg);
        args.add(value);
    }

    @SuppressForbidden(reason="get java home path to pass through")
    private static Path getJavaHome(Map<String, String> sysprops) {
        return Paths.get(sysprops.get("java.home"), new String[0]);
    }

    private static Path getJvmDll(Path javaHome) {
        Path dll = javaHome.resolve("jre/bin/server/jvm.dll");
        if (!Files.exists(dll, new LinkOption[0])) {
            dll = javaHome.resolve("bin/server/jvm.dll");
        }
        return dll;
    }

    private static String getJvmOptions(Map<String, String> sysprops) {
        ArrayList<String> jvmOptions = new ArrayList<String>();
        jvmOptions.add("-XX:+UseSerialGC");
        for (String prop : List.of("es.path.home", "es.path.conf", "es.distribution.type")) {
            jvmOptions.add("-D%s=%s".formatted(prop, WindowsServiceInstallCommand.quote(sysprops.get(prop))));
        }
        return String.join((CharSequence)";", jvmOptions);
    }

    @Override
    protected void preExecute(Terminal terminal, ProcessInfo pinfo, String serviceId) throws UserException {
        Path javaHome = WindowsServiceInstallCommand.getJavaHome(pinfo.sysprops());
        terminal.println((CharSequence)String.format(Locale.ROOT, "Installing service : %s", serviceId));
        terminal.println((CharSequence)String.format(Locale.ROOT, "Using ES_JAVA_HOME : %s", javaHome.toString()));
        Path javaDll = WindowsServiceInstallCommand.getJvmDll(javaHome);
        if (!Files.exists(javaDll, new LinkOption[0])) {
            throw new UserException(78, "Invalid java installation (no jvm.dll found in %s\\jre\\bin\\server\\ or %s\\bin\\server\"). Exiting...".formatted(javaHome.toString(), javaHome.toString()));
        }
        boolean hasUsername = pinfo.envVars().containsKey("SERVICE_USERNAME");
        if (pinfo.envVars().containsKey("SERVICE_PASSWORD") != hasUsername) {
            throw new UserException(78, "Both service username and password must be set, only got " + (hasUsername ? "SERVICE_USERNAME" : "SERVICE_PASSWORD"));
        }
    }

    @Override
    protected String getSuccessMessage(String serviceId) {
        return String.format(Locale.ROOT, "The service '%s' has been installed", serviceId);
    }

    @Override
    protected String getFailureMessage(String serviceId) {
        return String.format(Locale.ROOT, "Failed installing '%s' service", serviceId);
    }
}

