/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class SparseVectorQueryWrapper
extends Query {
    private final String fieldName;
    private final Query termsQuery;

    public SparseVectorQueryWrapper(String fieldName, Query termsQuery) {
        this.fieldName = fieldName;
        this.termsQuery = termsQuery;
    }

    public Query getTermsQuery() {
        return this.termsQuery;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewrite = this.termsQuery.rewrite(indexSearcher);
        if (rewrite != this.termsQuery) {
            return new SparseVectorQueryWrapper(this.fieldName, rewrite);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.termsQuery.createWeight(searcher, scoreMode, boost);
    }

    public String toString(String field) {
        return this.termsQuery.toString(field);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            this.termsQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
        }
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SparseVectorQueryWrapper that = (SparseVectorQueryWrapper)((Object)obj);
        return this.fieldName.equals(that.fieldName) && this.termsQuery.equals((Object)that.termsQuery);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldName, this.termsQuery);
    }
}

