/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.function.Supplier;
import org.apache.lucene.search.CollectorManager;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorCollector;
import org.elasticsearch.search.aggregations.AggregatorFactories;

public class SearchContextAggregations {
    private final AggregatorFactories factories;
    private final Supplier<AggregationReduceContext.Builder> toAggregationReduceContextBuilder;
    private CollectorManager<AggregatorCollector, Void> aggCollectorManager;

    public SearchContextAggregations(AggregatorFactories factories, Supplier<AggregationReduceContext.Builder> toAggregationReduceContextBuilder) {
        this.factories = factories;
        this.toAggregationReduceContextBuilder = toAggregationReduceContextBuilder;
    }

    public AggregatorFactories factories() {
        return this.factories;
    }

    public void registerAggsCollectorManager(CollectorManager<AggregatorCollector, Void> aggCollectorManager) {
        this.aggCollectorManager = aggCollectorManager;
    }

    public CollectorManager<AggregatorCollector, Void> getAggsCollectorManager() {
        return this.aggCollectorManager;
    }

    public boolean isInSortOrderExecutionRequired() {
        return this.factories.context() != null && this.factories.context().isInSortOrderExecutionRequired();
    }

    public AggregationReduceContext.Builder getAggregationReduceContextBuilder() {
        return this.toAggregationReduceContextBuilder.get();
    }
}

