/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.script.Metadata;

public class CtxMap<T extends Metadata>
extends AbstractMap<String, Object> {
    protected static final String SOURCE = "_source";
    protected Map<String, Object> source;
    protected final T metadata;

    public CtxMap(Map<String, Object> source, T metadata) {
        this.source = source;
        this.metadata = metadata;
        Set<String> badKeys = Sets.intersection(((Metadata)this.metadata).keySet(), this.source.keySet());
        if (badKeys.size() > 0) {
            throw new IllegalArgumentException("unexpected metadata [" + badKeys.stream().sorted().map(k -> k + ":" + String.valueOf(this.source.get(k))).collect(Collectors.joining(", ")) + "] in source");
        }
    }

    protected boolean directSourceAccess() {
        return false;
    }

    public final Map<String, Object> getSource() {
        return this.source;
    }

    public T getMetadata() {
        return this.metadata;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set<Map.Entry<String, Object>> sourceEntries = this.directSourceAccess() ? this.source.entrySet() : Set.of(new IndirectSourceEntry());
        return new EntrySet(sourceEntries, new HashSet<String>(((Metadata)this.metadata).keySet()));
    }

    @Override
    public Object put(String key, Object value) {
        if (((Metadata)this.metadata).isAvailable(key)) {
            return ((Metadata)this.metadata).put(key, value);
        }
        if (this.directSourceAccess()) {
            return this.source.put(key, value);
        }
        if (SOURCE.equals(key)) {
            return this.replaceSource(value);
        }
        throw new IllegalArgumentException("Cannot put key [" + key + "] with value [" + String.valueOf(value) + "] into ctx");
    }

    private Object replaceSource(Object value) {
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("Expected [_source] to be a Map, not [" + String.valueOf(value) + "]" + (String)(value != null ? " with type [" + value.getClass().getName() + "]" : ""));
        }
        Map<String, Object> oldSource = this.source;
        this.source = CtxMap.castSourceMap(value);
        return oldSource;
    }

    private static Map<String, Object> castSourceMap(Object value) {
        return (Map)value;
    }

    @Override
    public Object remove(Object key) {
        String str;
        if (key instanceof String && ((Metadata)this.metadata).isAvailable(str = (String)key)) {
            return ((Metadata)this.metadata).remove(str);
        }
        if (this.directSourceAccess()) {
            return this.source.remove(key);
        }
        throw new UnsupportedOperationException("Cannot remove key " + String.valueOf(key) + " from ctx");
    }

    @Override
    public void clear() {
        for (String key : new ArrayList<String>(((Metadata)this.metadata).keySet())) {
            ((Metadata)this.metadata).remove(key);
        }
        this.source.clear();
    }

    @Override
    public int size() {
        int sourceSize = this.directSourceAccess() ? this.source.size() : 1;
        return sourceSize + ((Metadata)this.metadata).size();
    }

    @Override
    public boolean containsValue(Object value) {
        return ((Metadata)this.metadata).containsValue(value) || (this.directSourceAccess() ? this.source.containsValue(value) : this.source.equals(value));
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String str = (String)key;
            if (((Metadata)this.metadata).isAvailable(str)) {
                return ((Metadata)this.metadata).containsKey(str);
            }
            return this.directSourceAccess() ? this.source.containsKey(key) : SOURCE.equals(key);
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        String str;
        if (key instanceof String && ((Metadata)this.metadata).isAvailable(str = (String)key)) {
            return ((Metadata)this.metadata).get(str);
        }
        return this.directSourceAccess() ? this.source.get(key) : (SOURCE.equals(key) ? this.source : null);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        if (key instanceof String) {
            String str = (String)key;
            if (((Metadata)this.metadata).isAvailable(str)) {
                return ((Metadata)this.metadata).getOrDefault(str, defaultValue);
            }
            return this.directSourceAccess() ? this.source.getOrDefault(key, defaultValue) : (SOURCE.equals(key) ? this.source : defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CtxMap)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CtxMap ctxMap = (CtxMap)o;
        return this.source.equals(ctxMap.source) && ((Metadata)this.metadata).equals(ctxMap.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.metadata);
    }

    private class IndirectSourceEntry
    implements Map.Entry<String, Object> {
        private IndirectSourceEntry() {
        }

        @Override
        public String getKey() {
            return CtxMap.SOURCE;
        }

        @Override
        public Object getValue() {
            return CtxMap.this.source;
        }

        @Override
        public Object setValue(Object value) {
            return CtxMap.this.replaceSource(value);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        Set<Map.Entry<String, Object>> sourceSet;
        Set<String> metadataKeys;

        EntrySet(Set<Map.Entry<String, Object>> sourceSet, Set<String> metadataKeys) {
            this.sourceSet = sourceSet;
            this.metadataKeys = metadataKeys;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new EntrySetIterator(this.sourceSet.iterator(), this.metadataKeys.iterator());
        }

        @Override
        public int size() {
            return this.sourceSet.size() + this.metadataKeys.size();
        }

        @Override
        public boolean remove(Object o) {
            String key;
            Map.Entry entry;
            Object k;
            if (o instanceof Map.Entry && (k = (entry = (Map.Entry)o).getKey()) instanceof String && ((Metadata)CtxMap.this.metadata).containsKey(key = (String)k) && Objects.equals(entry.getValue(), ((Metadata)CtxMap.this.metadata).get(key))) {
                ((Metadata)CtxMap.this.metadata).remove(key);
                return true;
            }
            return this.sourceSet.remove(o);
        }
    }

    class Entry
    implements Map.Entry<String, Object> {
        final String key;

        Entry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return ((Metadata)CtxMap.this.metadata).get(this.key);
        }

        @Override
        public Object setValue(Object value) {
            return ((Metadata)CtxMap.this.metadata).put(this.key, value);
        }
    }

    class EntrySetIterator
    implements Iterator<Map.Entry<String, Object>> {
        final Iterator<Map.Entry<String, Object>> sourceIter;
        final Iterator<String> metadataKeyIter;
        boolean sourceCur = true;
        Map.Entry<String, Object> cur;

        EntrySetIterator(Iterator<Map.Entry<String, Object>> sourceIter, Iterator<String> metadataKeyIter) {
            this.sourceIter = sourceIter;
            this.metadataKeyIter = metadataKeyIter;
        }

        @Override
        public boolean hasNext() {
            return this.sourceIter.hasNext() || this.metadataKeyIter.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.sourceCur = this.sourceIter.hasNext();
            this.cur = this.sourceCur ? this.sourceIter.next() : new Entry(this.metadataKeyIter.next());
            return this.cur;
        }

        @Override
        public void remove() {
            if (this.cur == null) {
                throw new IllegalStateException();
            }
            if (this.sourceCur) {
                try {
                    this.sourceIter.remove();
                }
                catch (UnsupportedOperationException e) {
                    throw new UnsupportedOperationException("Cannot remove key [" + this.cur.getKey() + "] from ctx");
                }
            } else {
                ((Metadata)CtxMap.this.metadata).remove(this.cur.getKey());
            }
        }
    }
}

