/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;

public enum IngestPipelineFieldAccessPattern {
    CLASSIC("classic"),
    FLEXIBLE("flexible");

    private final String key;
    private static final Map<String, IngestPipelineFieldAccessPattern> NAME_REGISTRY;

    private IngestPipelineFieldAccessPattern(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static boolean isValidAccessPattern(String accessPatternName) {
        return NAME_REGISTRY.containsKey(accessPatternName);
    }

    public static IngestPipelineFieldAccessPattern getAccessPattern(String accessPatternName) {
        IngestPipelineFieldAccessPattern accessPattern = NAME_REGISTRY.get(accessPatternName);
        if (accessPattern == null) {
            throw new IllegalArgumentException("Invalid ingest pipeline access pattern name [" + accessPatternName + "] given");
        }
        return accessPattern;
    }

    static {
        NAME_REGISTRY = Map.of(IngestPipelineFieldAccessPattern.CLASSIC.key, CLASSIC, IngestPipelineFieldAccessPattern.FLEXIBLE.key, FLEXIBLE);
    }
}

