/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.core.Assertions;

public final class EngineResetLock
implements ReadWriteLock {
    private final ReentrantReadWriteLock lock = Assertions.ENABLED ? new QueuedWriterThreadsReentrantReadWriteLock() : new ReentrantReadWriteLock();

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    public boolean isWriteLocked() {
        return this.lock.isWriteLocked();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public boolean isReadLocked() {
        return this.lock.getReadLockCount() > 0;
    }

    public boolean isReadLockedByCurrentThread() {
        return this.lock.getReadHoldCount() > 0;
    }

    public int getReadLockCount() {
        return this.lock.getReadLockCount();
    }

    Collection<Thread> getQueuedWriterThreads() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        if (reentrantReadWriteLock instanceof QueuedWriterThreadsReentrantReadWriteLock) {
            QueuedWriterThreadsReentrantReadWriteLock queuedLock = (QueuedWriterThreadsReentrantReadWriteLock)reentrantReadWriteLock;
            return queuedLock.queuedWriterThreads();
        }
        return List.of();
    }

    private static class QueuedWriterThreadsReentrantReadWriteLock
    extends ReentrantReadWriteLock {
        private QueuedWriterThreadsReentrantReadWriteLock() {
        }

        Collection<Thread> queuedWriterThreads() {
            return super.getQueuedWriterThreads();
        }
    }
}

