/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.xcontent.XContentBuilder;

public class CompositeSyntheticFieldLoader
implements SourceLoader.SyntheticFieldLoader {
    private final String leafFieldName;
    private final String fullFieldName;
    private final Collection<Layer> parts;
    private boolean storedFieldLoadersHaveValues;
    private boolean docValuesLoadersHaveValues;

    public CompositeSyntheticFieldLoader(String leafFieldName, String fullFieldName, Layer ... parts) {
        this(leafFieldName, fullFieldName, Arrays.asList(parts));
    }

    public CompositeSyntheticFieldLoader(String leafFieldName, String fullFieldName, Collection<Layer> parts) {
        this.leafFieldName = leafFieldName;
        this.fullFieldName = fullFieldName;
        this.parts = parts;
        this.storedFieldLoadersHaveValues = false;
        this.docValuesLoadersHaveValues = false;
    }

    @Override
    public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
        return this.parts.stream().flatMap(SourceLoader.SyntheticFieldLoader::storedFieldLoaders).map(e -> Map.entry((String)e.getKey(), new SourceLoader.SyntheticFieldLoader.StoredFieldLoader(){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            @Override
            public void load(List<Object> newValues) {
                CompositeSyntheticFieldLoader.this.storedFieldLoadersHaveValues = true;
                ((SourceLoader.SyntheticFieldLoader.StoredFieldLoader)this.val$e.getValue()).load(newValues);
            }
        }));
    }

    @Override
    public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
        ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders = new ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader>(this.parts.size());
        for (Layer part : this.parts) {
            SourceLoader.SyntheticFieldLoader.DocValuesLoader partLoader = part.docValuesLoader(leafReader, docIdsInLeaf);
            if (partLoader == null) continue;
            loaders.add(partLoader);
        }
        if (loaders.isEmpty()) {
            return null;
        }
        return docId -> {
            boolean hasDocs = false;
            for (SourceLoader.SyntheticFieldLoader.DocValuesLoader loader : loaders) {
                hasDocs |= loader.advanceToDoc(docId);
            }
            this.docValuesLoadersHaveValues = hasDocs;
            return hasDocs;
        };
    }

    @Override
    public boolean hasValue() {
        return this.storedFieldLoadersHaveValues || this.docValuesLoadersHaveValues;
    }

    @Override
    public void write(XContentBuilder b) throws IOException {
        long totalCount = 0L;
        for (Layer part : this.parts) {
            totalCount += part.valueCount();
        }
        if (totalCount == 0L) {
            return;
        }
        if (totalCount == 1L) {
            b.field(this.leafFieldName);
            for (Layer part : this.parts) {
                part.write(b);
            }
            return;
        }
        b.startArray(this.leafFieldName);
        for (Layer part : this.parts) {
            part.write(b);
        }
        b.endArray();
        this.softReset();
    }

    private void softReset() {
        this.storedFieldLoadersHaveValues = false;
        this.docValuesLoadersHaveValues = false;
    }

    @Override
    public void reset() {
        this.softReset();
        this.parts.forEach(SourceLoader.SyntheticFieldLoader::reset);
    }

    @Override
    public String fieldName() {
        return this.fullFieldName;
    }

    public static interface Layer
    extends SourceLoader.SyntheticFieldLoader {
        public long valueCount();
    }

    public static abstract class StoredFieldLayer
    implements Layer {
        private final String fieldName;
        private List<Object> values;

        public StoredFieldLayer(String fieldName) {
            this.fieldName = fieldName;
            this.values = Collections.emptyList();
        }

        @Override
        public long valueCount() {
            return this.values.size();
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(Map.entry(this.fieldName, newValues -> {
                this.values = newValues;
            }));
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            return null;
        }

        @Override
        public boolean hasValue() {
            return !this.values.isEmpty();
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            for (Object v : this.values) {
                this.writeValue(v, b);
            }
            this.reset();
        }

        @Override
        public void reset() {
            this.values = Collections.emptyList();
        }

        protected abstract void writeValue(Object var1, XContentBuilder var2) throws IOException;

        @Override
        public String fieldName() {
            return this.fieldName;
        }
    }

    public static class MalformedValuesLayer
    extends StoredFieldLayer {
        public MalformedValuesLayer(String fieldName) {
            super(IgnoreMalformedStoredValues.name(fieldName));
        }

        @Override
        protected void writeValue(Object value, XContentBuilder b) throws IOException {
            if (value instanceof BytesRef) {
                BytesRef r = (BytesRef)value;
                XContentDataHelper.decodeAndWrite(b, r);
            } else {
                b.value(value);
            }
        }
    }

    public static interface DocValuesLayer
    extends Layer {
        @Override
        default public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.empty();
        }

        @Override
        default public void reset() {
        }
    }
}

