/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.elasticsearch.common.logging.ESLogMessage;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.index.SlowLogLevel;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.json.JsonStringEncoder;

public final class SearchSlowLog
implements SearchOperationListener {
    private long queryWarnThreshold;
    private long queryInfoThreshold;
    private long queryDebugThreshold;
    private long queryTraceThreshold;
    private long fetchWarnThreshold;
    private long fetchInfoThreshold;
    private long fetchDebugThreshold;
    private long fetchTraceThreshold;
    static final String INDEX_SEARCH_SLOWLOG_PREFIX = "index.search.slowlog";
    private static final Logger queryLogger = LogManager.getLogger((String)"index.search.slowlog.query");
    private static final Logger fetchLogger = LogManager.getLogger((String)"index.search.slowlog.fetch");
    private final SlowLogFields slowLogFields;
    public static final Setting<Boolean> INDEX_SEARCH_SLOWLOG_INCLUDE_USER_SETTING = Setting.boolSetting("index.search.slowlog.include.user", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.warn", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.info", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.debug", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING = Setting.timeSetting("index.search.slowlog.threshold.query.trace", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.warn", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.info", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.debug", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<TimeValue> INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING = Setting.timeSetting("index.search.slowlog.threshold.fetch.trace", TimeValue.MINUS_ONE, TimeValue.MINUS_ONE, Setting.Property.Dynamic, Setting.Property.IndexScope);
    @Deprecated
    public static final Setting<SlowLogLevel> INDEX_SEARCH_SLOWLOG_LEVEL = new Setting<SlowLogLevel>("index.search.slowlog.level", SlowLogLevel.TRACE.name(), SlowLogLevel::parse, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.IndexSettingDeprecatedInV7AndRemovedInV8);
    private static final ToXContent.Params FORMAT_PARAMS = new ToXContent.MapParams(Collections.singletonMap("pretty", "false"));

    public SearchSlowLog(IndexSettings indexSettings, SlowLogFields slowLogFields) {
        this.slowLogFields = slowLogFields;
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING, this::setQueryWarnThreshold);
        this.queryWarnThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING, this::setQueryInfoThreshold);
        this.queryInfoThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING, this::setQueryDebugThreshold);
        this.queryDebugThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING, this::setQueryTraceThreshold);
        this.queryTraceThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_QUERY_TRACE_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING, this::setFetchWarnThreshold);
        this.fetchWarnThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_WARN_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING, this::setFetchInfoThreshold);
        this.fetchInfoThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_INFO_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING, this::setFetchDebugThreshold);
        this.fetchDebugThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_DEBUG_SETTING).nanos();
        indexSettings.getScopedSettings().addSettingsUpdateConsumer(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING, this::setFetchTraceThreshold);
        this.fetchTraceThreshold = indexSettings.getValue(INDEX_SEARCH_SLOWLOG_THRESHOLD_FETCH_TRACE_SETTING).nanos();
    }

    @Override
    public void onQueryPhase(SearchContext context, long tookInNanos) {
        if (this.queryWarnThreshold >= 0L && tookInNanos > this.queryWarnThreshold) {
            queryLogger.warn((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        } else if (this.queryInfoThreshold >= 0L && tookInNanos > this.queryInfoThreshold) {
            queryLogger.info((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        } else if (this.queryDebugThreshold >= 0L && tookInNanos > this.queryDebugThreshold) {
            queryLogger.debug((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        } else if (this.queryTraceThreshold >= 0L && tookInNanos > this.queryTraceThreshold) {
            queryLogger.trace((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        }
    }

    @Override
    public void onFetchPhase(SearchContext context, long tookInNanos) {
        if (this.fetchWarnThreshold >= 0L && tookInNanos > this.fetchWarnThreshold) {
            fetchLogger.warn((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        } else if (this.fetchInfoThreshold >= 0L && tookInNanos > this.fetchInfoThreshold) {
            fetchLogger.info((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        } else if (this.fetchDebugThreshold >= 0L && tookInNanos > this.fetchDebugThreshold) {
            fetchLogger.debug((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        } else if (this.fetchTraceThreshold >= 0L && tookInNanos > this.fetchTraceThreshold) {
            fetchLogger.trace((Message)SearchSlowLogMessage.of(this.slowLogFields.searchFields(), context, tookInNanos));
        }
    }

    private void setQueryWarnThreshold(TimeValue warnThreshold) {
        this.queryWarnThreshold = warnThreshold.nanos();
    }

    private void setQueryInfoThreshold(TimeValue infoThreshold) {
        this.queryInfoThreshold = infoThreshold.nanos();
    }

    private void setQueryDebugThreshold(TimeValue debugThreshold) {
        this.queryDebugThreshold = debugThreshold.nanos();
    }

    private void setQueryTraceThreshold(TimeValue traceThreshold) {
        this.queryTraceThreshold = traceThreshold.nanos();
    }

    private void setFetchWarnThreshold(TimeValue warnThreshold) {
        this.fetchWarnThreshold = warnThreshold.nanos();
    }

    private void setFetchInfoThreshold(TimeValue infoThreshold) {
        this.fetchInfoThreshold = infoThreshold.nanos();
    }

    private void setFetchDebugThreshold(TimeValue debugThreshold) {
        this.fetchDebugThreshold = debugThreshold.nanos();
    }

    private void setFetchTraceThreshold(TimeValue traceThreshold) {
        this.fetchTraceThreshold = traceThreshold.nanos();
    }

    long getQueryWarnThreshold() {
        return this.queryWarnThreshold;
    }

    long getQueryInfoThreshold() {
        return this.queryInfoThreshold;
    }

    long getQueryDebugThreshold() {
        return this.queryDebugThreshold;
    }

    long getQueryTraceThreshold() {
        return this.queryTraceThreshold;
    }

    long getFetchWarnThreshold() {
        return this.fetchWarnThreshold;
    }

    long getFetchInfoThreshold() {
        return this.fetchInfoThreshold;
    }

    long getFetchDebugThreshold() {
        return this.fetchDebugThreshold;
    }

    long getFetchTraceThreshold() {
        return this.fetchTraceThreshold;
    }

    static final class SearchSlowLogMessage {
        SearchSlowLogMessage() {
        }

        public static ESLogMessage of(Map<String, String> additionalFields, SearchContext context, long tookInNanos) {
            Map<String, Object> jsonFields = SearchSlowLogMessage.prepareMap(context, tookInNanos);
            jsonFields.putAll(additionalFields);
            return new ESLogMessage().withFields(jsonFields);
        }

        private static Map<String, Object> prepareMap(SearchContext context, long tookInNanos) {
            HashMap<String, Object> messageFields = new HashMap<String, Object>();
            messageFields.put("elasticsearch.slowlog.message", context.indexShard().shardId());
            messageFields.put("elasticsearch.slowlog.took", TimeValue.timeValueNanos((long)tookInNanos).toString());
            messageFields.put("elasticsearch.slowlog.took_millis", TimeUnit.NANOSECONDS.toMillis(tookInNanos));
            if (context.getTotalHits() != null) {
                messageFields.put("elasticsearch.slowlog.total_hits", context.getTotalHits());
            } else {
                messageFields.put("elasticsearch.slowlog.total_hits", "-1");
            }
            messageFields.put("elasticsearch.slowlog.stats", SearchSlowLogMessage.escapeJson(ESLogMessage.asJsonArray(context.groupStats() != null ? context.groupStats().stream() : Stream.empty())));
            messageFields.put("elasticsearch.slowlog.search_type", (Object)context.searchType());
            messageFields.put("elasticsearch.slowlog.total_shards", context.numberOfShards());
            if (context.request().source() != null) {
                String source = SearchSlowLogMessage.escapeJson(context.request().source().toString(FORMAT_PARAMS));
                messageFields.put("elasticsearch.slowlog.source", source);
            } else {
                messageFields.put("elasticsearch.slowlog.source", "{}");
            }
            messageFields.put("elasticsearch.slowlog.id", context.getTask().getHeader("X-Opaque-Id"));
            return messageFields;
        }

        private static String escapeJson(String text) {
            byte[] sourceEscaped = JsonStringEncoder.getInstance().quoteAsUTF8(text);
            return new String(sourceEscaped, StandardCharsets.UTF_8);
        }
    }
}

