/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.xcontent.XContentString;

public final class UTF8DecodingReader
extends Reader {
    private CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private ByteBuffer bytes;

    public UTF8DecodingReader(ByteBuffer bytes) {
        this.bytes = bytes;
    }

    public UTF8DecodingReader(XContentString.UTF8Bytes utf8bytes) {
        this.bytes = ByteBuffer.wrap(utf8bytes.bytes(), utf8bytes.offset(), utf8bytes.length());
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        return this.read(CharBuffer.wrap(cbuf, off, len));
    }

    @Override
    public int read(CharBuffer cbuf) {
        if (!this.bytes.hasRemaining()) {
            return -1;
        }
        int startPos = cbuf.position();
        this.decoder.decode(this.bytes, cbuf, true);
        return cbuf.position() - startPos;
    }

    @Override
    public void close() {
    }
}

