/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.ReferenceDocs;

public class RestoreInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "restore_in_progress";

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingAllocation allocation) {
        RestoreInProgress.ShardRestoreStatus shardRestoreStatus;
        RecoverySource recoverySource = shardRouting.recoverySource();
        if (recoverySource == null || recoverySource.getType() != RecoverySource.Type.SNAPSHOT) {
            return allocation.decision(Decision.YES, NAME, "ignored as shard is not being recovered from a snapshot", new Object[0]);
        }
        RecoverySource.SnapshotRecoverySource source = (RecoverySource.SnapshotRecoverySource)recoverySource;
        if (source.restoreUUID().equals("_no_api_")) {
            return allocation.decision(Decision.YES, NAME, "not an API-level restore", new Object[0]);
        }
        RestoreInProgress.Entry restoreInProgress = RestoreInProgress.get(allocation.getClusterState()).get(source.restoreUUID());
        if (restoreInProgress != null && (shardRestoreStatus = restoreInProgress.shards().get(shardRouting.shardId())) != null && !shardRestoreStatus.state().completed()) {
            assert (shardRestoreStatus.state() != RestoreInProgress.State.SUCCESS) : "expected shard [" + String.valueOf(shardRouting) + "] to be in initializing state but got [" + String.valueOf((Object)shardRestoreStatus.state()) + "]";
            return allocation.decision(Decision.YES, NAME, "shard is currently being restored", new Object[0]);
        }
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        if (unassignedInfo.failedAllocations() > 0) {
            return allocation.decision(Decision.NO, NAME, "shard has failed to be restored from the snapshot [%s] - manually close or delete the index [%s] in order to retry to restore the snapshot again or use the reroute API to force the allocation of an empty primary shard. Check the logs for more information about the failure. Details: [%s]", source.snapshot(), shardRouting.getIndexName(), unassignedInfo.details());
        }
        return allocation.decision(Decision.NO, NAME, "Restore from snapshot failed because the configured constraints prevented allocation on any of the available nodes. Please check constraints applied in index and cluster settings, then retry the restore. See [%s] for more details on using the allocation explain API.", new Object[]{ReferenceDocs.ALLOCATION_EXPLAIN_API});
    }

    @Override
    public Decision canForceAllocatePrimary(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        assert (shardRouting.primary()) : "must not call canForceAllocatePrimary on a non-primary shard " + String.valueOf(shardRouting);
        return this.canAllocate(shardRouting, node, allocation);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }
}

