/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.entitlement.runtime.policy.PolicyManager;
import org.elasticsearch.plugins.PluginsLoader;

public class ScopeResolver {
    private final Map<Module, String> pluginNameByModule;
    private final String apmAgentPackageName;

    private ScopeResolver(Map<Module, String> pluginNameByModule, String apmAgentPackageName) {
        this.pluginNameByModule = pluginNameByModule;
        this.apmAgentPackageName = apmAgentPackageName;
    }

    public static ScopeResolver create(Stream<PluginsLoader.PluginLayer> pluginLayers, String apmAgentPackageName) {
        HashMap<Module, String> pluginNameByModule = new HashMap<Module, String>();
        pluginLayers.forEach(pluginLayer -> {
            String pluginName = pluginLayer.pluginBundle().pluginDescriptor().getName();
            if (pluginLayer.pluginModuleLayer() != null && pluginLayer.pluginModuleLayer() != ModuleLayer.boot()) {
                for (Module module : pluginLayer.pluginModuleLayer().modules()) {
                    pluginNameByModule.put(module, pluginName);
                }
            } else {
                pluginNameByModule.put(pluginLayer.pluginClassLoader().getUnnamedModule(), pluginName);
            }
        });
        return new ScopeResolver(pluginNameByModule, apmAgentPackageName);
    }

    public PolicyManager.PolicyScope resolveClassToScope(Class<?> clazz) {
        Module module = clazz.getModule();
        String scopeName = ScopeResolver.getScopeName(module);
        if (ScopeResolver.isServerModule(module)) {
            return PolicyManager.PolicyScope.server((String)scopeName);
        }
        String pluginName = this.pluginNameByModule.get(module);
        if (pluginName != null) {
            return PolicyManager.PolicyScope.plugin((String)pluginName, (String)scopeName);
        }
        if (!module.isNamed() && clazz.getPackageName().startsWith(this.apmAgentPackageName)) {
            return PolicyManager.PolicyScope.apmAgent((String)"ALL-UNNAMED");
        }
        return PolicyManager.PolicyScope.unknown((String)scopeName);
    }

    private static boolean isServerModule(Module requestingModule) {
        return requestingModule.isNamed() && requestingModule.getLayer() == ModuleLayer.boot();
    }

    public static String getScopeName(Module requestingModule) {
        if (!requestingModule.isNamed()) {
            return "ALL-UNNAMED";
        }
        return requestingModule.getName();
    }
}

