/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.action.termvectors.EnsureDocsSearchableAction;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.termvectors.TermVectorsService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportTermVectorsAction
extends TransportSingleShardAction<TermVectorsRequest, TermVectorsResponse> {
    private final NodeClient client;
    private final IndicesService indicesService;
    private final boolean stateless;

    @Inject
    public TransportTermVectorsAction(ClusterService clusterService, NodeClient client, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/tv", threadPool, clusterService, transportService, actionFilters, projectResolver, indexNameExpressionResolver, TermVectorsRequest::new, threadPool.executor("get"));
        this.client = client;
        this.indicesService = indicesService;
        this.stateless = DiscoveryNode.isStateless(clusterService.getSettings());
    }

    @Override
    protected ShardIterator shards(ProjectState project, TransportSingleShardAction.InternalRequest request) {
        OperationRouting operationRouting = this.clusterService.operationRouting();
        if (((TermVectorsRequest)request.request()).doc() != null && ((TermVectorsRequest)request.request()).routing() == null) {
            return operationRouting.searchShards(project, new String[]{request.concreteIndex()}, null, ((TermVectorsRequest)request.request()).preference()).getFirst();
        }
        ShardIterator iterator = this.clusterService.operationRouting().getShards(project, request.concreteIndex(), ((TermVectorsRequest)request.request()).id(), ((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).preference());
        if (iterator == null) {
            return new ShardIterator(null, List.of());
        }
        return ShardIterator.allSearchableShards(iterator);
    }

    @Override
    protected boolean resolveIndex(TermVectorsRequest request) {
        return true;
    }

    @Override
    protected void resolveRequest(ProjectState state, TransportSingleShardAction.InternalRequest request) {
        ((TermVectorsRequest)request.request()).routing(state.metadata().resolveIndexRouting(((TermVectorsRequest)request.request()).routing(), ((TermVectorsRequest)request.request()).index()));
    }

    @Override
    protected void asyncShardOperation(TermVectorsRequest request, ShardId shardId, ActionListener<TermVectorsResponse> listener) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        if (request.realtime()) {
            if (this.stateless) {
                EnsureDocsSearchableAction.EnsureDocsSearchableRequest ensureDocsSearchableRequest = new EnsureDocsSearchableAction.EnsureDocsSearchableRequest(request.index(), shardId.id(), new String[]{request.id()});
                ensureDocsSearchableRequest.setParentTask(this.clusterService.localNode().getId(), request.getParentTask().getId());
                this.client.executeLocally(EnsureDocsSearchableAction.TYPE, ensureDocsSearchableRequest, listener.delegateFailureAndWrap((l, r) -> super.asyncShardOperation(request, shardId, l)));
            } else {
                super.asyncShardOperation(request, shardId, listener);
            }
        } else {
            indexShard.ensureShardSearchActive(b -> {
                try {
                    super.asyncShardOperation(request, shardId, listener);
                }
                catch (Exception ex) {
                    listener.onFailure(ex);
                }
            });
        }
    }

    @Override
    protected TermVectorsResponse shardOperation(TermVectorsRequest request, ShardId shardId) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(shardId.id());
        return TermVectorsService.getTermVectors(indexShard, request);
    }

    @Override
    protected Writeable.Reader<TermVectorsResponse> getResponseReader() {
        return TermVectorsResponse::new;
    }
}

