/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.remote;

import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoRequest;
import org.elasticsearch.action.admin.cluster.remote.RemoteInfoResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;

public final class TransportRemoteInfoAction
extends HandledTransportAction<RemoteInfoRequest, RemoteInfoResponse> {
    public static final ActionType<RemoteInfoResponse> TYPE = new ActionType("cluster:monitor/remote/info");
    private final RemoteClusterService remoteClusterService;

    @Inject
    public TransportRemoteInfoAction(TransportService transportService, ActionFilters actionFilters) {
        super(TYPE.name(), transportService, actionFilters, RemoteInfoRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.remoteClusterService = transportService.getRemoteClusterService();
    }

    @Override
    protected void doExecute(Task task, RemoteInfoRequest remoteInfoRequest, ActionListener<RemoteInfoResponse> listener) {
        this.remoteClusterService.ensureClientIsEnabled();
        listener.onResponse(new RemoteInfoResponse(this.remoteClusterService.getRemoteConnectionInfos().collect(Collectors.toList())));
    }
}

