/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraIndexParams;

public class CuVSIvfPqIndexParams {
    private final CagraIndexParams.CuvsDistanceType metric;
    private final CagraIndexParams.CodebookGen codebookKind;
    private final float metricArg;
    private final double kmeansTrainsetFraction;
    private final int nLists;
    private final int kmeansNIters;
    private final int pqBits;
    private final int pqDim;
    private final boolean addDataOnBuild;
    private final boolean forceRandomRotation;
    private final boolean conservativeMemoryAllocation;
    private final int maxTrainPointsPerPqCode;

    private CuVSIvfPqIndexParams(CagraIndexParams.CuvsDistanceType metric, CagraIndexParams.CodebookGen codebookKind, float metricArg, double kmeansTrainsetFraction, int nLists, int kmeansNIters, int pqBits, int pqDim, boolean addDataOnBuild, boolean forceRandomRotation, boolean conservativeMemoryAllocation, int maxTrainPointsPerPqCode) {
        this.metric = metric;
        this.codebookKind = codebookKind;
        this.metricArg = metricArg;
        this.kmeansTrainsetFraction = kmeansTrainsetFraction;
        this.nLists = nLists;
        this.kmeansNIters = kmeansNIters;
        this.pqBits = pqBits;
        this.pqDim = pqDim;
        this.addDataOnBuild = addDataOnBuild;
        this.forceRandomRotation = forceRandomRotation;
        this.conservativeMemoryAllocation = conservativeMemoryAllocation;
        this.maxTrainPointsPerPqCode = maxTrainPointsPerPqCode;
    }

    public CagraIndexParams.CuvsDistanceType getMetric() {
        return this.metric;
    }

    public CagraIndexParams.CodebookGen getCodebookKind() {
        return this.codebookKind;
    }

    public float getMetricArg() {
        return this.metricArg;
    }

    public double getKmeansTrainsetFraction() {
        return this.kmeansTrainsetFraction;
    }

    public int getnLists() {
        return this.nLists;
    }

    public int getKmeansNIters() {
        return this.kmeansNIters;
    }

    public int getPqBits() {
        return this.pqBits;
    }

    public int getPqDim() {
        return this.pqDim;
    }

    public boolean isAddDataOnBuild() {
        return this.addDataOnBuild;
    }

    public boolean isForceRandomRotation() {
        return this.forceRandomRotation;
    }

    public boolean isConservativeMemoryAllocation() {
        return this.conservativeMemoryAllocation;
    }

    public int getMaxTrainPointsPerPqCode() {
        return this.maxTrainPointsPerPqCode;
    }

    public String toString() {
        return "CuVSIvfPqIndexParams [metric=" + String.valueOf((Object)this.metric) + ", codebookKind=" + String.valueOf((Object)this.codebookKind) + ", metricArg=" + this.metricArg + ", kmeansTrainsetFraction=" + this.kmeansTrainsetFraction + ", nLists=" + this.nLists + ", kmeansNIters=" + this.kmeansNIters + ", pqBits=" + this.pqBits + ", pqDim=" + this.pqDim + ", addDataOnBuild=" + this.addDataOnBuild + ", forceRandomRotation=" + this.forceRandomRotation + ", conservativeMemoryAllocation=" + this.conservativeMemoryAllocation + ", maxTrainPointsPerPqCode=" + this.maxTrainPointsPerPqCode + "]";
    }

    public static class Builder {
        private CagraIndexParams.CuvsDistanceType metric = CagraIndexParams.CuvsDistanceType.L2Expanded;
        private CagraIndexParams.CodebookGen codebookKind = CagraIndexParams.CodebookGen.PER_SUBSPACE;
        private float metricArg = 2.0f;
        private double kmeansTrainsetFraction = 0.5;
        private int nLists = 1024;
        private int kmeansNIters = 20;
        private int pqBits = 8;
        private int pqDim = 0;
        private boolean addDataOnBuild = true;
        private boolean forceRandomRotation = false;
        private boolean conservativeMemoryAllocation = false;
        private int maxTrainPointsPerPqCode = 256;

        public Builder withMetric(CagraIndexParams.CuvsDistanceType metric) {
            this.metric = metric;
            return this;
        }

        public Builder withMetricArg(float metricArg) {
            this.metricArg = metricArg;
            return this;
        }

        public Builder withAddDataOnBuild(boolean addDataOnBuild) {
            this.addDataOnBuild = addDataOnBuild;
            return this;
        }

        public Builder withNLists(int nLists) {
            this.nLists = nLists;
            return this;
        }

        public Builder withKmeansNIters(int kmeansNIters) {
            this.kmeansNIters = kmeansNIters;
            return this;
        }

        public Builder withKmeansTrainsetFraction(double kmeansTrainsetFraction) {
            this.kmeansTrainsetFraction = kmeansTrainsetFraction;
            return this;
        }

        public Builder withPqBits(int pqBits) {
            this.pqBits = pqBits;
            return this;
        }

        public Builder withPqDim(int pqDim) {
            this.pqDim = pqDim;
            return this;
        }

        public Builder withCodebookKind(CagraIndexParams.CodebookGen codebookKind) {
            this.codebookKind = codebookKind;
            return this;
        }

        public Builder withForceRandomRotation(boolean forceRandomRotation) {
            this.forceRandomRotation = forceRandomRotation;
            return this;
        }

        public Builder withConservativeMemoryAllocation(boolean conservativeMemoryAllocation) {
            this.conservativeMemoryAllocation = conservativeMemoryAllocation;
            return this;
        }

        public Builder withMaxTrainPointsPerPqCode(int maxTrainPointsPerPqCode) {
            this.maxTrainPointsPerPqCode = maxTrainPointsPerPqCode;
            return this;
        }

        public CuVSIvfPqIndexParams build() {
            return new CuVSIvfPqIndexParams(this.metric, this.codebookKind, this.metricArg, this.kmeansTrainsetFraction, this.nLists, this.kmeansNIters, this.pqBits, this.pqDim, this.addDataOnBuild, this.forceRandomRotation, this.conservativeMemoryAllocation, this.maxTrainPointsPerPqCode);
        }
    }
}

