/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.graph.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.graph.Connection;
import org.elasticsearch.protocol.xpack.graph.GraphExploreRequest;
import org.elasticsearch.protocol.xpack.graph.GraphExploreResponse;
import org.elasticsearch.protocol.xpack.graph.Hop;
import org.elasticsearch.protocol.xpack.graph.Vertex;
import org.elasticsearch.protocol.xpack.graph.VertexRequest;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.graph.Graph;

public class TransportGraphExploreAction
extends HandledTransportAction<GraphExploreRequest, GraphExploreResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGraphExploreAction.class);
    private final ThreadPool threadPool;
    private final NodeClient client;
    protected final XPackLicenseState licenseState;

    @Inject
    public TransportGraphExploreAction(ThreadPool threadPool, NodeClient client, TransportService transportService, ActionFilters actionFilters, XPackLicenseState licenseState) {
        super("indices:data/read/xpack/graph/explore", transportService, actionFilters, GraphExploreRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.client = client;
        this.licenseState = licenseState;
    }

    protected void doExecute(Task task, GraphExploreRequest request, ActionListener<GraphExploreResponse> listener) {
        if (Graph.GRAPH_FEATURE.check(this.licenseState)) {
            new AsyncGraphAction(request, listener).start();
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"graph"));
        }
    }

    class AsyncGraphAction {
        private final GraphExploreRequest request;
        private final ActionListener<GraphExploreResponse> listener;
        private final long startTime;
        private volatile ShardOperationFailedException[] shardFailures;
        private Map<Vertex.VertexId, Vertex> vertices = new HashMap<Vertex.VertexId, Vertex>();
        private Map<Connection.ConnectionId, Connection> connections = new HashMap<Connection.ConnectionId, Connection>();
        private Map<Integer, Map<String, Set<Vertex>>> hopFindings = new HashMap<Integer, Map<String, Set<Vertex>>>();
        private int currentHopNumber = 0;

        AsyncGraphAction(GraphExploreRequest request, ActionListener<GraphExploreResponse> listener) {
            this.request = request;
            this.listener = listener;
            this.startTime = TransportGraphExploreAction.this.threadPool.relativeTimeInMillis();
            this.shardFailures = ShardSearchFailure.EMPTY_ARRAY;
        }

        private Vertex getVertex(String field, String term) {
            return this.vertices.get(Vertex.createId((String)field, (String)term));
        }

        private Connection addConnection(Vertex from, Vertex to, double weight, long docCount) {
            Connection connection = new Connection(from, to, weight, docCount);
            this.connections.put(connection.getId(), connection);
            return connection;
        }

        private Vertex addVertex(String field, String term, double score, int depth, long bg, long fg) {
            Vertex.VertexId key = Vertex.createId((String)field, (String)term);
            Vertex vertex = this.vertices.get(key);
            if (vertex == null) {
                Set<Vertex> verticesForField;
                vertex = new Vertex(field, term, score, depth, bg, fg);
                this.vertices.put(key, vertex);
                Map<String, Set<Vertex>> currentWave = this.hopFindings.get(this.currentHopNumber);
                if (currentWave == null) {
                    currentWave = new HashMap<String, Set<Vertex>>();
                    this.hopFindings.put(this.currentHopNumber, currentWave);
                }
                if ((verticesForField = currentWave.get(field)) == null) {
                    verticesForField = new HashSet<Vertex>();
                    currentWave.put(field, verticesForField);
                }
                verticesForField.add(vertex);
            }
            return vertex;
        }

        private void removeVertex(Vertex vertex) {
            this.vertices.remove(vertex.getId());
            this.hopFindings.get(this.currentHopNumber).get(vertex.getField()).remove(vertex);
        }

        synchronized void expand(boolean timedOut) {
            Map<String, Set<Vertex>> lastHopFindings = this.hopFindings.get(this.currentHopNumber);
            if (this.currentHopNumber >= this.request.getHopNumbers() - 1 || lastHopFindings == null || lastHopFindings.size() == 0) {
                this.listener.onResponse((Object)this.buildResponse(timedOut));
                return;
            }
            final Hop lastHop = this.request.getHop(this.currentHopNumber);
            ++this.currentHopNumber;
            final Hop currentHop = this.request.getHop(this.currentHopNumber);
            SearchRequest searchRequest = new SearchRequest(this.request.indices()).indicesOptions(this.request.indicesOptions());
            if (this.request.routing() != null) {
                searchRequest.routing(this.request.routing());
            }
            BoolQueryBuilder rootBool = QueryBuilders.boolQuery();
            SamplerAggregationBuilder sampleAgg = null;
            if (this.request.sampleDiversityField() != null) {
                DiversifiedAggregationBuilder diversifiedSampleAgg = AggregationBuilders.diversifiedSampler((String)"sample").shardSize(this.request.sampleSize());
                diversifiedSampleAgg.field(this.request.sampleDiversityField());
                diversifiedSampleAgg.maxDocsPerValue(this.request.maxDocsPerDiversityValue());
                sampleAgg = diversifiedSampleAgg;
            } else {
                sampleAgg = AggregationBuilders.sampler((String)"sample").shardSize(this.request.sampleSize());
            }
            rootBool.must(currentHop.guidingQuery());
            BoolQueryBuilder sourceTermsOrClause = QueryBuilders.boolQuery();
            AsyncGraphAction.addUserDefinedIncludesToQuery(currentHop, sourceTermsOrClause);
            AsyncGraphAction.addBigOrClause(lastHopFindings, sourceTermsOrClause);
            rootBool.must((QueryBuilder)sourceTermsOrClause);
            for (int fieldNum = 0; fieldNum < lastHop.getNumberVertexRequests(); ++fieldNum) {
                VertexRequest lastVr = lastHop.getVertexRequest(fieldNum);
                Set<Vertex> lastWaveVerticesForField = lastHopFindings.get(lastVr.fieldName());
                if (lastWaveVerticesForField == null) continue;
                TreeSet<BytesRef> terms = new TreeSet<BytesRef>();
                for (Vertex v : lastWaveVerticesForField) {
                    terms.add(new BytesRef((CharSequence)v.getTerm()));
                }
                TermsAggregationBuilder lastWaveTermsAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)("field" + fieldNum)).includeExclude(new IncludeExclude(null, null, terms, null)).shardMinDocCount(1L).field(lastVr.fieldName())).minDocCount(1L).executionHint("map").size(terms.size());
                sampleAgg.subAggregation((AggregationBuilder)lastWaveTermsAgg);
                for (int f = 0; f < currentHop.getNumberVertexRequests(); ++f) {
                    SortedSet includes;
                    VertexRequest vr = currentHop.getVertexRequest(f);
                    int size = vr.size();
                    if (vr.fieldName().equals(lastVr.fieldName())) {
                        ++size;
                    }
                    if (this.request.useSignificance()) {
                        SignificantTermsAggregationBuilder nextWaveSigTerms = ((SignificantTermsAggregationBuilder)AggregationBuilders.significantTerms((String)("field" + f)).field(vr.fieldName())).minDocCount((long)vr.minDocCount()).shardMinDocCount((long)vr.shardMinDocCount()).executionHint("map").size(size);
                        if (size < 10) {
                            nextWaveSigTerms.shardSize(10);
                        }
                        if (vr.hasIncludeClauses()) {
                            includes = vr.includeValuesAsSortedSet();
                            nextWaveSigTerms.includeExclude(new IncludeExclude(null, null, includes, null));
                        } else if (vr.hasExcludeClauses()) {
                            nextWaveSigTerms.includeExclude(new IncludeExclude(null, null, null, vr.excludesAsSortedSet()));
                        }
                        lastWaveTermsAgg.subAggregation((AggregationBuilder)nextWaveSigTerms);
                        continue;
                    }
                    TermsAggregationBuilder nextWavePopularTerms = ((TermsAggregationBuilder)AggregationBuilders.terms((String)("field" + f)).field(vr.fieldName())).minDocCount((long)vr.minDocCount()).shardMinDocCount((long)vr.shardMinDocCount()).executionHint("map").size(size);
                    if (vr.hasIncludeClauses()) {
                        includes = vr.includeValuesAsSortedSet();
                        nextWavePopularTerms.includeExclude(new IncludeExclude(null, null, includes, null));
                    } else if (vr.hasExcludeClauses()) {
                        nextWavePopularTerms.includeExclude(new IncludeExclude(null, null, null, vr.excludesAsSortedSet()));
                    }
                    lastWaveTermsAgg.subAggregation((AggregationBuilder)nextWavePopularTerms);
                }
            }
            SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)rootBool).aggregation((AggregationBuilder)sampleAgg).size(0);
            if (this.request.timeout() != null) {
                long timeRemainingMillis = this.startTime + this.request.timeout().millis() - TransportGraphExploreAction.this.threadPool.relativeTimeInMillis();
                if (timeRemainingMillis <= 0L) {
                    this.listener.onResponse((Object)this.buildResponse(true));
                    return;
                }
                source.timeout(TimeValue.timeValueMillis((long)timeRemainingMillis));
            }
            searchRequest.source(source);
            logger.trace("executing expansion graph search request");
            TransportGraphExploreAction.this.client.search(searchRequest, (ActionListener)new DelegatingActionListener<SearchResponse, GraphExploreResponse>(this.listener){

                public void onResponse(SearchResponse searchResponse) {
                    AsyncGraphAction.this.addShardFailures((ShardOperationFailedException[])searchResponse.getShardFailures());
                    ArrayList<Connection> newConnections = new ArrayList<Connection>();
                    ArrayList<Vertex> newVertices = new ArrayList<Vertex>();
                    SingleBucketAggregation sample = (SingleBucketAggregation)searchResponse.getAggregations().get("sample");
                    double totalSignalOutput = this.getExpandTotalSignalStrength(lastHop, currentHop, sample);
                    if (totalSignalOutput > 0.0) {
                        this.addAndScoreNewVertices(lastHop, currentHop, sample, totalSignalOutput, newConnections, newVertices);
                        this.trimNewAdditions(currentHop, newConnections, newVertices);
                    }
                    AsyncGraphAction.this.expand(searchResponse.isTimedOut());
                }

                private void addAndScoreNewVertices(Hop lastHop2, Hop currentHop2, SingleBucketAggregation sample, double totalSignalOutput, ArrayList<Connection> newConnections, ArrayList<Vertex> newVertices) {
                    for (int j = 0; j < lastHop2.getNumberVertexRequests(); ++j) {
                        VertexRequest lastVr = lastHop2.getVertexRequest(j);
                        Terms lastWaveTerms = (Terms)sample.getAggregations().get("field" + j);
                        if (lastWaveTerms == null) continue;
                        List buckets = lastWaveTerms.getBuckets();
                        for (Terms.Bucket lastWaveTerm : buckets) {
                            Vertex fromVertex = AsyncGraphAction.this.getVertex(lastVr.fieldName(), lastWaveTerm.getKeyAsString());
                            for (int k = 0; k < currentHop2.getNumberVertexRequests(); ++k) {
                                Vertex toVertex;
                                double signalStrength;
                                VertexRequest vr = currentHop2.getVertexRequest(k);
                                double decay = 0.95;
                                if (AsyncGraphAction.this.request.useSignificance()) {
                                    SignificantTerms significantTerms = (SignificantTerms)lastWaveTerm.getAggregations().get("field" + k);
                                    if (significantTerms == null) continue;
                                    for (SignificantTerms.Bucket bucket : significantTerms.getBuckets()) {
                                        if (vr.fieldName().equals(fromVertex.getField()) && bucket.getKeyAsString().equals(fromVertex.getTerm())) continue;
                                        signalStrength = bucket.getSignificanceScore() / totalSignalOutput;
                                        signalStrength *= Math.min(decay, fromVertex.getWeight());
                                        toVertex = AsyncGraphAction.this.getVertex(vr.fieldName(), bucket.getKeyAsString());
                                        if (toVertex == null) {
                                            toVertex = AsyncGraphAction.this.addVertex(vr.fieldName(), bucket.getKeyAsString(), signalStrength, AsyncGraphAction.this.currentHopNumber, bucket.getSupersetDf(), bucket.getSubsetDf());
                                            newVertices.add(toVertex);
                                        } else {
                                            toVertex.setWeight(toVertex.getWeight() + signalStrength);
                                            toVertex.setFg(Math.max(toVertex.getFg(), bucket.getSubsetDf()));
                                        }
                                        newConnections.add(AsyncGraphAction.this.addConnection(fromVertex, toVertex, signalStrength, bucket.getDocCount()));
                                    }
                                    continue;
                                }
                                Terms terms = (Terms)lastWaveTerm.getAggregations().get("field" + k);
                                if (terms == null) continue;
                                for (SignificantTerms.Bucket bucket : terms.getBuckets()) {
                                    signalStrength = (double)bucket.getDocCount() / totalSignalOutput;
                                    signalStrength *= Math.min(decay, fromVertex.getWeight());
                                    toVertex = AsyncGraphAction.this.getVertex(vr.fieldName(), bucket.getKeyAsString());
                                    if (toVertex == null) {
                                        toVertex = AsyncGraphAction.this.addVertex(vr.fieldName(), bucket.getKeyAsString(), signalStrength, AsyncGraphAction.this.currentHopNumber, 0L, 0L);
                                        newVertices.add(toVertex);
                                    } else {
                                        toVertex.setWeight(toVertex.getWeight() + signalStrength);
                                    }
                                    newConnections.add(AsyncGraphAction.this.addConnection(fromVertex, toVertex, signalStrength, bucket.getDocCount()));
                                }
                            }
                        }
                    }
                }

                private void trimNewAdditions(Hop currentHop2, ArrayList<Connection> newConnections, ArrayList<Vertex> newVertices) {
                    HashSet<Vertex> evictions = new HashSet<Vertex>();
                    for (int k = 0; k < currentHop2.getNumberVertexRequests(); ++k) {
                        VertexRequest vr = currentHop2.getVertexRequest(k);
                        if (newVertices.size() <= vr.size()) continue;
                        VertexPriorityQueue pq = new VertexPriorityQueue(vr.size());
                        for (Vertex vertex : newVertices) {
                            Vertex eviction;
                            if (!vertex.getField().equals(vr.fieldName()) || (eviction = (Vertex)pq.insertWithOverflow(vertex)) == null) continue;
                            evictions.add(eviction);
                        }
                    }
                    if (evictions.size() > 0) {
                        for (Connection connection : newConnections) {
                            if (!evictions.contains(connection.getTo())) continue;
                            AsyncGraphAction.this.connections.remove(connection.getId());
                            AsyncGraphAction.this.removeVertex(connection.getTo());
                        }
                    }
                }

                private double getExpandTotalSignalStrength(Hop lastHop2, Hop currentHop2, SingleBucketAggregation sample) {
                    double totalSignalOutput = 0.0;
                    for (int j = 0; j < lastHop2.getNumberVertexRequests(); ++j) {
                        VertexRequest lastVr = lastHop2.getVertexRequest(j);
                        Terms lastWaveTerms = (Terms)sample.getAggregations().get("field" + j);
                        if (lastWaveTerms == null) continue;
                        List buckets = lastWaveTerms.getBuckets();
                        for (Terms.Bucket lastWaveTerm : buckets) {
                            for (int k = 0; k < currentHop2.getNumberVertexRequests(); ++k) {
                                VertexRequest vr = currentHop2.getVertexRequest(k);
                                if (AsyncGraphAction.this.request.useSignificance()) {
                                    SignificantTerms significantTerms = (SignificantTerms)lastWaveTerm.getAggregations().get("field" + k);
                                    if (significantTerms == null) continue;
                                    for (SignificantTerms.Bucket bucket : significantTerms.getBuckets()) {
                                        if (vr.fieldName().equals(lastVr.fieldName()) && bucket.getKeyAsString().equals(lastWaveTerm.getKeyAsString())) continue;
                                        totalSignalOutput += bucket.getSignificanceScore();
                                    }
                                    continue;
                                }
                                Terms terms = (Terms)lastWaveTerm.getAggregations().get("field" + k);
                                if (terms == null) continue;
                                for (SignificantTerms.Bucket bucket : terms.getBuckets()) {
                                    if (vr.fieldName().equals(lastVr.fieldName()) && bucket.getKeyAsString().equals(lastWaveTerm.getKeyAsString())) continue;
                                    totalSignalOutput += (double)bucket.getDocCount();
                                }
                            }
                        }
                    }
                    return totalSignalOutput;
                }
            });
        }

        private static void addUserDefinedIncludesToQuery(Hop hop, BoolQueryBuilder sourceTermsOrClause) {
            for (int i = 0; i < hop.getNumberVertexRequests(); ++i) {
                VertexRequest vr = hop.getVertexRequest(i);
                if (!vr.hasIncludeClauses()) continue;
                AsyncGraphAction.addNormalizedBoosts(sourceTermsOrClause, vr);
            }
        }

        private static void addBigOrClause(Map<String, Set<Vertex>> lastHopFindings, BoolQueryBuilder sourceTermsOrClause) {
            int numClauses = sourceTermsOrClause.should().size();
            for (Map.Entry<String, Set<Vertex>> entry : lastHopFindings.entrySet()) {
                numClauses += entry.getValue().size();
            }
            if (numClauses < IndexSearcher.getMaxClauseCount()) {
                for (Map.Entry<String, Set<Vertex>> entry : lastHopFindings.entrySet()) {
                    for (Vertex vertex : entry.getValue()) {
                        sourceTermsOrClause.should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)vertex.getField(), (String)vertex.getTerm())).boost((float)vertex.getWeight()));
                    }
                }
            } else {
                for (Map.Entry<String, Set<Vertex>> entry : lastHopFindings.entrySet()) {
                    ArrayList<String> perFieldTerms = new ArrayList<String>();
                    for (Vertex vertex : entry.getValue()) {
                        perFieldTerms.add(vertex.getTerm());
                    }
                    sourceTermsOrClause.should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), perFieldTerms)));
                }
            }
        }

        public synchronized void start() {
            try {
                SearchRequest searchRequest = new SearchRequest(this.request.indices()).indicesOptions(this.request.indicesOptions());
                if (this.request.routing() != null) {
                    searchRequest.routing(this.request.routing());
                }
                BoolQueryBuilder rootBool = QueryBuilders.boolQuery();
                SamplerAggregationBuilder rootSampleAgg = null;
                if (this.request.sampleDiversityField() != null) {
                    DiversifiedAggregationBuilder diversifiedRootSampleAgg = AggregationBuilders.diversifiedSampler((String)"sample").shardSize(this.request.sampleSize());
                    diversifiedRootSampleAgg.field(this.request.sampleDiversityField());
                    diversifiedRootSampleAgg.maxDocsPerValue(this.request.maxDocsPerDiversityValue());
                    rootSampleAgg = diversifiedRootSampleAgg;
                } else {
                    rootSampleAgg = AggregationBuilders.sampler((String)"sample").shardSize(this.request.sampleSize());
                }
                final Hop rootHop = this.request.getHop(0);
                rootBool.must(rootHop.guidingQuery());
                BoolQueryBuilder includesContainer = QueryBuilders.boolQuery();
                AsyncGraphAction.addUserDefinedIncludesToQuery(rootHop, includesContainer);
                if (includesContainer.should().size() > 0) {
                    rootBool.must((QueryBuilder)includesContainer);
                }
                for (int i = 0; i < rootHop.getNumberVertexRequests(); ++i) {
                    SortedSet includes;
                    VertexRequest vr = rootHop.getVertexRequest(i);
                    if (this.request.useSignificance()) {
                        SignificantTermsAggregationBuilder sigBuilder = AggregationBuilders.significantTerms((String)("field" + i));
                        ((SignificantTermsAggregationBuilder)sigBuilder.field(vr.fieldName())).shardMinDocCount((long)vr.shardMinDocCount()).minDocCount((long)vr.minDocCount()).executionHint("map").size(vr.size());
                        if (vr.hasIncludeClauses()) {
                            includes = vr.includeValuesAsSortedSet();
                            sigBuilder.includeExclude(new IncludeExclude(null, null, includes, null));
                            sigBuilder.size(includes.size());
                        }
                        if (vr.hasExcludeClauses()) {
                            sigBuilder.includeExclude(new IncludeExclude(null, null, null, vr.excludesAsSortedSet()));
                        }
                        rootSampleAgg.subAggregation((AggregationBuilder)sigBuilder);
                        continue;
                    }
                    TermsAggregationBuilder termsBuilder = AggregationBuilders.terms((String)("field" + i));
                    ((TermsAggregationBuilder)termsBuilder.field(vr.fieldName())).executionHint("map").size(vr.size());
                    if (vr.hasIncludeClauses()) {
                        includes = vr.includeValuesAsSortedSet();
                        termsBuilder.includeExclude(new IncludeExclude(null, null, includes, null));
                        termsBuilder.size(includes.size());
                    }
                    if (vr.hasExcludeClauses()) {
                        termsBuilder.includeExclude(new IncludeExclude(null, null, null, vr.excludesAsSortedSet()));
                    }
                    rootSampleAgg.subAggregation((AggregationBuilder)termsBuilder);
                }
                SearchSourceBuilder source = new SearchSourceBuilder().query((QueryBuilder)rootBool).aggregation((AggregationBuilder)rootSampleAgg).size(0);
                if (this.request.timeout() != null) {
                    source.timeout(this.request.timeout());
                }
                searchRequest.source(source);
                logger.trace("executing initial graph search request");
                TransportGraphExploreAction.this.client.search(searchRequest, (ActionListener)new DelegatingActionListener<SearchResponse, GraphExploreResponse>(this.listener){

                    public void onResponse(SearchResponse searchResponse) {
                        AsyncGraphAction.this.addShardFailures((ShardOperationFailedException[])searchResponse.getShardFailures());
                        SingleBucketAggregation sample = (SingleBucketAggregation)searchResponse.getAggregations().get("sample");
                        double totalSignalStrength = this.getInitialTotalSignalStrength(rootHop, sample);
                        for (int j = 0; j < rootHop.getNumberVertexRequests(); ++j) {
                            double signalWeight;
                            List buckets;
                            VertexRequest vr = rootHop.getVertexRequest(j);
                            if (AsyncGraphAction.this.request.useSignificance()) {
                                SignificantTerms significantTerms = (SignificantTerms)sample.getAggregations().get("field" + j);
                                buckets = significantTerms.getBuckets();
                                for (SignificantTerms.Bucket bucket : buckets) {
                                    signalWeight = bucket.getSignificanceScore() / totalSignalStrength;
                                    AsyncGraphAction.this.addVertex(vr.fieldName(), bucket.getKeyAsString(), signalWeight, AsyncGraphAction.this.currentHopNumber, bucket.getSupersetDf(), bucket.getSubsetDf());
                                }
                                continue;
                            }
                            Terms terms = (Terms)sample.getAggregations().get("field" + j);
                            buckets = terms.getBuckets();
                            for (SignificantTerms.Bucket bucket : buckets) {
                                signalWeight = (double)bucket.getDocCount() / totalSignalStrength;
                                AsyncGraphAction.this.addVertex(vr.fieldName(), bucket.getKeyAsString(), signalWeight, AsyncGraphAction.this.currentHopNumber, 0L, 0L);
                            }
                        }
                        AsyncGraphAction.this.expand(searchResponse.isTimedOut());
                    }

                    private double getInitialTotalSignalStrength(Hop rootHop2, SingleBucketAggregation sample) {
                        double totalSignalStrength = 0.0;
                        for (int i = 0; i < rootHop2.getNumberVertexRequests(); ++i) {
                            List buckets;
                            if (AsyncGraphAction.this.request.useSignificance()) {
                                SignificantTerms significantTerms = (SignificantTerms)sample.getAggregations().get("field" + i);
                                buckets = significantTerms.getBuckets();
                                for (SignificantTerms.Bucket bucket : buckets) {
                                    totalSignalStrength += bucket.getSignificanceScore();
                                }
                                continue;
                            }
                            Terms terms = (Terms)sample.getAggregations().get("field" + i);
                            buckets = terms.getBuckets();
                            for (SignificantTerms.Bucket bucket : buckets) {
                                totalSignalStrength += (double)bucket.getDocCount();
                            }
                        }
                        return totalSignalStrength;
                    }
                });
            }
            catch (Exception e) {
                logger.error("unable to execute the graph query", (Throwable)e);
                this.listener.onFailure(e);
            }
        }

        private static void addNormalizedBoosts(BoolQueryBuilder includesContainer, VertexRequest vr) {
            GraphExploreRequest.TermBoost[] termBoosts = vr.includeValues();
            if (includesContainer.should().size() + termBoosts.length > IndexSearcher.getMaxClauseCount()) {
                ArrayList<String> termValues = new ArrayList<String>();
                for (GraphExploreRequest.TermBoost tb : termBoosts) {
                    termValues.add(tb.getTerm());
                }
                includesContainer.should((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termsQuery((String)vr.fieldName(), termValues)));
                return;
            }
            float minBoost = Float.MAX_VALUE;
            for (GraphExploreRequest.TermBoost tb : termBoosts) {
                minBoost = Math.min(minBoost, tb.getBoost());
            }
            for (GraphExploreRequest.TermBoost tb : termBoosts) {
                float normalizedBoost = tb.getBoost() / minBoost;
                includesContainer.should((QueryBuilder)QueryBuilders.termQuery((String)vr.fieldName(), (String)tb.getTerm()).boost(normalizedBoost));
            }
        }

        void addShardFailures(ShardOperationFailedException[] failures) {
            if (!CollectionUtils.isEmpty((Object[])failures)) {
                ShardOperationFailedException[] duplicates = new ShardOperationFailedException[this.shardFailures.length + failures.length];
                System.arraycopy(this.shardFailures, 0, duplicates, 0, this.shardFailures.length);
                System.arraycopy(failures, 0, duplicates, this.shardFailures.length, failures.length);
                this.shardFailures = ExceptionsHelper.groupBy((ShardOperationFailedException[])duplicates);
            }
        }

        protected GraphExploreResponse buildResponse(boolean timedOut) {
            long took = TransportGraphExploreAction.this.threadPool.relativeTimeInMillis() - this.startTime;
            return new GraphExploreResponse(took, timedOut, this.shardFailures, this.vertices, this.connections, this.request.returnDetailedInfo());
        }
    }

    static class VertexPriorityQueue
    extends PriorityQueue<Vertex> {
        VertexPriorityQueue(int maxSize) {
            super(maxSize);
        }

        protected boolean lessThan(Vertex a, Vertex b) {
            return a.getWeight() < b.getWeight();
        }
    }
}

