/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.extras.MatchOnlyTextFieldMapper;
import org.elasticsearch.index.mapper.extras.RankFeatureFieldMapper;
import org.elasticsearch.index.mapper.extras.RankFeatureMetaFieldMapper;
import org.elasticsearch.index.mapper.extras.RankFeatureQueryBuilder;
import org.elasticsearch.index.mapper.extras.RankFeaturesFieldMapper;
import org.elasticsearch.index.mapper.extras.ScaledFloatFieldMapper;
import org.elasticsearch.index.mapper.extras.SearchAsYouTypeFieldMapper;
import org.elasticsearch.index.mapper.extras.TokenCountFieldMapper;
import org.elasticsearch.plugins.MapperPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SearchPlugin;

public class MapperExtrasPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin {
    public Map<String, Mapper.TypeParser> getMappers() {
        LinkedHashMap<String, FieldMapper.TypeParser> mappers = new LinkedHashMap<String, FieldMapper.TypeParser>();
        mappers.put("scaled_float", ScaledFloatFieldMapper.PARSER);
        mappers.put("token_count", TokenCountFieldMapper.PARSER);
        mappers.put("rank_feature", RankFeatureFieldMapper.PARSER);
        mappers.put("rank_features", RankFeaturesFieldMapper.PARSER);
        mappers.put("search_as_you_type", SearchAsYouTypeFieldMapper.PARSER);
        mappers.put("match_only_text", MatchOnlyTextFieldMapper.PARSER);
        return Collections.unmodifiableMap(mappers);
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMappers() {
        return Collections.singletonMap("_feature", RankFeatureMetaFieldMapper.PARSER);
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("rank_feature", RankFeatureQueryBuilder::new, p -> (RankFeatureQueryBuilder)((Object)((Object)RankFeatureQueryBuilder.PARSER.parse(p, null)))));
    }
}

