/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.storage;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingRoleStrategy;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.SnapshotShardSizeInfo;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCapacity;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderContext;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.NodeDecision;
import org.elasticsearch.xpack.autoscaling.storage.NodeDecisions;
import org.elasticsearch.xpack.autoscaling.storage.ShardsAllocationResults;
import org.elasticsearch.xpack.cluster.routing.allocation.DataTierAllocationDecider;

public class ReactiveStorageDeciderService
implements AutoscalingDeciderService {
    public static final String NAME = "reactive_storage";
    static final long NODE_DISK_OVERHEAD = ByteSizeValue.ofMb((long)10L).getBytes();
    private final DiskThresholdSettings diskThresholdSettings;
    private final AllocationDeciders allocationDeciders;
    private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;
    private static final Predicate<String> REMOVE_NODE_LOCKED_FILTER_INITIAL = ReactiveStorageDeciderService.removeNodeLockedFilterPredicate(IndexMetadata.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey());
    private static final Predicate<String> REMOVE_NODE_LOCKED_FILTER_REQUIRE = ReactiveStorageDeciderService.removeNodeLockedFilterPredicate(IndexMetadata.INDEX_ROUTING_REQUIRE_GROUP_SETTING.getKey());
    private static final Predicate<String> REMOVE_NODE_LOCKED_FILTER_INCLUDE = ReactiveStorageDeciderService.removeNodeLockedFilterPredicate(IndexMetadata.INDEX_ROUTING_INCLUDE_GROUP_SETTING.getKey());

    private static Predicate<String> removeNodeLockedFilterPredicate(String settingPrefix) {
        return Predicate.not(DiscoveryNodeFilters.SINGLE_NODE_NAMES.stream().map(settingPrefix::concat).collect(Collectors.toSet())::contains);
    }

    public ReactiveStorageDeciderService(Settings settings, ClusterSettings clusterSettings, AllocationDeciders allocationDeciders, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.allocationDeciders = allocationDeciders;
        this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public List<Setting<?>> deciderSettings() {
        return List.of();
    }

    @Override
    public List<DiscoveryNodeRole> roles() {
        return List.of(DiscoveryNodeRole.DATA_ROLE, DiscoveryNodeRole.DATA_CONTENT_NODE_ROLE, DiscoveryNodeRole.DATA_HOT_NODE_ROLE, DiscoveryNodeRole.DATA_WARM_NODE_ROLE, DiscoveryNodeRole.DATA_COLD_NODE_ROLE);
    }

    @Override
    public AutoscalingDeciderResult scale(Settings configuration, AutoscalingDeciderContext context) {
        AutoscalingCapacity autoscalingCapacity = context.currentCapacity();
        if (autoscalingCapacity == null || autoscalingCapacity.total().storage() == null) {
            return new AutoscalingDeciderResult(null, new ReactiveReason("current capacity not available", -1L, -1L));
        }
        AllocationState allocationState = this.allocationState(context);
        ShardsAllocationResults assignedBytesUnmovableShards = allocationState.storagePreventsRemainOrMove();
        long assignedBytes = assignedBytesUnmovableShards.sizeInBytes();
        ShardsAllocationResults unassignedBytesUnassignedShards = allocationState.storagePreventsAllocation();
        long unassignedBytes = unassignedBytesUnassignedShards.sizeInBytes();
        long maxShardSize = allocationState.maxShardSize();
        long maxNodeLockedSize = allocationState.maxNodeLockedSize();
        assert (assignedBytes >= 0L);
        assert (unassignedBytes >= 0L);
        assert (maxShardSize >= 0L);
        String message = ReactiveStorageDeciderService.message(unassignedBytes, assignedBytes);
        long requiredTotalStorage = autoscalingCapacity.total().storage().getBytes() + unassignedBytes + assignedBytes;
        long minimumNodeSize = requiredTotalStorage > 0L ? ReactiveStorageDeciderService.nodeSizeForDataBelowLowWatermark(Math.max(maxShardSize, maxNodeLockedSize), this.diskThresholdSettings) + NODE_DISK_OVERHEAD : 0L;
        AutoscalingCapacity requiredCapacity = AutoscalingCapacity.builder().total(requiredTotalStorage, null, null).node(minimumNodeSize, null, null).build();
        return new AutoscalingDeciderResult(requiredCapacity, new ReactiveReason(message, unassignedBytes, unassignedBytesUnassignedShards.shardIds(), assignedBytes, assignedBytesUnmovableShards.shardIds(), unassignedBytesUnassignedShards.shardNodeDecisions(), assignedBytesUnmovableShards.shardNodeDecisions()));
    }

    AllocationState allocationState(AutoscalingDeciderContext context) {
        return new AllocationState(context, this.diskThresholdSettings, this.allocationDeciders, this.shardRoutingRoleStrategy);
    }

    static String message(long unassignedBytes, long assignedBytes) {
        return unassignedBytes > 0L || assignedBytes > 0L ? "not enough storage available, needs " + String.valueOf(ByteSizeValue.ofBytes((long)(unassignedBytes + assignedBytes))) : "storage ok";
    }

    static boolean isDiskOnlyNoDecision(Decision decision) {
        return ReactiveStorageDeciderService.singleNoDecision(decision, Predicates.always()).map("disk_threshold"::equals).orElse(false);
    }

    static boolean isResizeOnlyNoDecision(Decision decision) {
        return ReactiveStorageDeciderService.singleNoDecision(decision, Predicates.always()).map("resize"::equals).orElse(false);
    }

    static boolean isFilterTierOnlyDecision(Decision decision, IndexMetadata indexMetadata) {
        return ReactiveStorageDeciderService.singleNoDecision(decision, single -> !"same_shard".equals(single.label())).filter("filter"::equals).map(d -> ReactiveStorageDeciderService.filterLooksLikeTier(indexMetadata)).orElse(false);
    }

    static boolean filterLooksLikeTier(IndexMetadata indexMetadata) {
        return ReactiveStorageDeciderService.isOnlyAttributeValueFilter(indexMetadata.requireFilters()) && ReactiveStorageDeciderService.isOnlyAttributeValueFilter(indexMetadata.includeFilters()) && ReactiveStorageDeciderService.isOnlyAttributeValueFilter(indexMetadata.excludeFilters());
    }

    private static boolean isOnlyAttributeValueFilter(DiscoveryNodeFilters filters) {
        if (filters == null) {
            return true;
        }
        return DiscoveryNodeFilters.trimTier((DiscoveryNodeFilters)filters).isOnlyAttributeValueFilter();
    }

    static Optional<String> singleNoDecision(Decision decision, Predicate<Decision> predicate) {
        List<Decision> nos = decision.getDecisions().stream().filter(single -> single.type() == Decision.Type.NO).filter(predicate).toList();
        if (nos.size() == 1) {
            return Optional.ofNullable(nos.get(0).label());
        }
        return Optional.empty();
    }

    static long nodeSizeForDataBelowLowWatermark(long neededBytes, DiskThresholdSettings thresholdSettings) {
        return thresholdSettings.getMinimumTotalSizeForBelowLowWatermark(ByteSizeValue.ofBytes((long)neededBytes)).getBytes();
    }

    public static class ReactiveReason
    implements AutoscalingDeciderResult.Reason {
        static final int MAX_AMOUNT_OF_SHARDS = 512;
        private static final TransportVersion SHARD_IDS_OUTPUT_VERSION = TransportVersions.V_8_4_0;
        private static final TransportVersion UNASSIGNED_NODE_DECISIONS_OUTPUT_VERSION = TransportVersions.V_8_9_X;
        private final String reason;
        private final long unassigned;
        private final long assigned;
        private final SortedSet<ShardId> unassignedShardIds;
        private final SortedSet<ShardId> assignedShardIds;
        private final Map<ShardId, NodeDecisions> unassignedNodeDecisions;
        private final Map<ShardId, NodeDecisions> assignedNodeDecisions;

        public ReactiveReason(String reason, long unassigned, long assigned) {
            this(reason, unassigned, Collections.emptySortedSet(), assigned, Collections.emptySortedSet(), Map.of(), Map.of());
        }

        ReactiveReason(String reason, long unassigned, SortedSet<ShardId> unassignedShardIds, long assigned, SortedSet<ShardId> assignedShardIds, Map<ShardId, NodeDecisions> unassignedNodeDecisions, Map<ShardId, NodeDecisions> assignedNodeDecisions) {
            this.reason = reason;
            this.unassigned = unassigned;
            this.assigned = assigned;
            this.unassignedShardIds = unassignedShardIds;
            this.assignedShardIds = assignedShardIds;
            this.unassignedNodeDecisions = Objects.requireNonNull(unassignedNodeDecisions);
            this.assignedNodeDecisions = Objects.requireNonNull(assignedNodeDecisions);
        }

        public ReactiveReason(StreamInput in) throws IOException {
            this.reason = in.readString();
            this.unassigned = in.readLong();
            this.assigned = in.readLong();
            if (in.getTransportVersion().onOrAfter((VersionId)SHARD_IDS_OUTPUT_VERSION)) {
                this.unassignedShardIds = Collections.unmodifiableSortedSet(new TreeSet(in.readCollectionAsSet(ShardId::new)));
                this.assignedShardIds = Collections.unmodifiableSortedSet(new TreeSet(in.readCollectionAsSet(ShardId::new)));
            } else {
                this.unassignedShardIds = Collections.emptySortedSet();
                this.assignedShardIds = Collections.emptySortedSet();
            }
            if (in.getTransportVersion().onOrAfter((VersionId)UNASSIGNED_NODE_DECISIONS_OUTPUT_VERSION)) {
                this.unassignedNodeDecisions = in.readMap(ShardId::new, NodeDecisions::new);
                this.assignedNodeDecisions = in.readMap(ShardId::new, NodeDecisions::new);
            } else {
                this.unassignedNodeDecisions = Map.of();
                this.assignedNodeDecisions = Map.of();
            }
        }

        @Override
        public String summary() {
            return this.reason;
        }

        public long unassigned() {
            return this.unassigned;
        }

        public long assigned() {
            return this.assigned;
        }

        public SortedSet<ShardId> unassignedShardIds() {
            return this.unassignedShardIds;
        }

        public SortedSet<ShardId> assignedShardIds() {
            return this.assignedShardIds;
        }

        public Map<ShardId, NodeDecisions> unassignedNodeDecisions() {
            return this.unassignedNodeDecisions;
        }

        public Map<ShardId, NodeDecisions> assignedNodeDecisions() {
            return this.assignedNodeDecisions;
        }

        public String getWriteableName() {
            return ReactiveStorageDeciderService.NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.reason);
            out.writeLong(this.unassigned);
            out.writeLong(this.assigned);
            if (out.getTransportVersion().onOrAfter((VersionId)SHARD_IDS_OUTPUT_VERSION)) {
                out.writeCollection(this.unassignedShardIds);
                out.writeCollection(this.assignedShardIds);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)UNASSIGNED_NODE_DECISIONS_OUTPUT_VERSION)) {
                out.writeMap(this.unassignedNodeDecisions);
                out.writeMap(this.assignedNodeDecisions);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("reason", this.reason);
            builder.field("unassigned", this.unassigned);
            builder.field("unassigned_shards", this.unassignedShardIds.stream().limit(512L).toList());
            builder.field("unassigned_shards_count", this.unassignedShardIds.size());
            builder.field("assigned", this.assigned);
            builder.field("assigned_shards", this.assignedShardIds.stream().limit(512L).toList());
            builder.field("assigned_shards_count", this.assignedShardIds.size());
            builder.xContentValuesMap("unassigned_node_decisions", this.unassignedNodeDecisions.entrySet().stream().collect(Collectors.toMap(e -> ((ShardId)e.getKey()).toString(), Map.Entry::getValue)));
            builder.xContentValuesMap("assigned_node_decisions", this.assignedNodeDecisions.entrySet().stream().collect(Collectors.toMap(e -> ((ShardId)e.getKey()).toString(), Map.Entry::getValue)));
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReactiveReason that = (ReactiveReason)o;
            return this.unassigned == that.unassigned && this.assigned == that.assigned && this.reason.equals(that.reason) && this.unassignedShardIds.equals(that.unassignedShardIds) && this.assignedShardIds.equals(that.assignedShardIds) && Objects.equals(this.unassignedNodeDecisions, that.unassignedNodeDecisions) && Objects.equals(this.assignedNodeDecisions, that.assignedNodeDecisions);
        }

        public int hashCode() {
            return Objects.hash(this.reason, this.unassigned, this.assigned, this.unassignedShardIds, this.assignedShardIds, this.unassignedNodeDecisions, this.assignedNodeDecisions);
        }
    }

    public static class AllocationState {
        static final int MAX_AMOUNT_OF_SHARD_DECISIONS = 5;
        private final ClusterState state;
        private final ClusterState originalState;
        private final AllocationDeciders allocationDeciders;
        private final ShardRoutingRoleStrategy shardRoutingRoleStrategy;
        private final DiskThresholdSettings diskThresholdSettings;
        private final ClusterInfo info;
        private final SnapshotShardSizeInfo shardSizeInfo;
        private final Predicate<DiscoveryNode> nodeTierPredicate;
        private final Set<DiscoveryNode> nodes;
        private final Set<String> nodeIds;
        private final Set<DiscoveryNodeRole> roles;

        AllocationState(AutoscalingDeciderContext context, DiskThresholdSettings diskThresholdSettings, AllocationDeciders allocationDeciders, ShardRoutingRoleStrategy shardRoutingRoleStrategy) {
            this(context.state(), allocationDeciders, shardRoutingRoleStrategy, diskThresholdSettings, context.info(), context.snapshotShardSizeInfo(), context.nodes(), context.roles());
        }

        AllocationState(ClusterState state, AllocationDeciders allocationDeciders, ShardRoutingRoleStrategy shardRoutingRoleStrategy, DiskThresholdSettings diskThresholdSettings, ClusterInfo info, SnapshotShardSizeInfo shardSizeInfo, Set<DiscoveryNode> nodes, Set<DiscoveryNodeRole> roles) {
            this.state = AllocationState.removeNodeLockFilters(state);
            this.originalState = state;
            this.allocationDeciders = allocationDeciders;
            this.shardRoutingRoleStrategy = shardRoutingRoleStrategy;
            this.diskThresholdSettings = diskThresholdSettings;
            this.info = info;
            this.shardSizeInfo = shardSizeInfo;
            this.nodes = nodes;
            this.nodeIds = nodes.stream().map(DiscoveryNode::getId).collect(Collectors.toSet());
            this.nodeTierPredicate = nodes::contains;
            this.roles = roles;
        }

        static <T extends ShardNodeDecision> T preferPrimary(T snd1, T snd2) {
            return snd1.shard().primary() ? snd1 : snd2;
        }

        public ShardsAllocationResults storagePreventsAllocation() {
            RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, this.state, this.info, this.shardSizeInfo, System.nanoTime());
            List unassignedShards = this.state.getRoutingNodes().unassigned().stream().filter(shard -> !this.canAllocate((ShardRouting)shard, allocation)).flatMap(shard -> this.cannotAllocateDueToStorage((ShardRouting)shard, allocation).stream()).toList();
            return new ShardsAllocationResults(unassignedShards.stream().map(e -> e.shard).mapToLong(this::sizeOf).sum(), unassignedShards.stream().map(e -> e.shard.shardId()).collect(Collectors.toCollection(TreeSet::new)), (Map<ShardId, NodeDecisions>)unassignedShards.stream().filter(shardNodeDecisions -> shardNodeDecisions.nodeDecisions.size() > 0).collect(AllocationState.toSortedMap(snd -> snd.shard.shardId(), snd -> new NodeDecisions(snd.nodeDecisions, null))).entrySet().stream().limit(5L).collect(AllocationState.toSortedMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        public ShardsAllocationResults storagePreventsRemainOrMove() {
            RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, this.state, this.info, this.shardSizeInfo, System.nanoTime());
            LinkedList<ShardRouting> candidates = new LinkedList<ShardRouting>();
            for (RoutingNode routingNode : this.state.getRoutingNodes()) {
                for (ShardRouting shard2 : routingNode) {
                    if (!shard2.started() || this.canRemainOnlyHighestTierPreference(shard2, allocation) || this.canAllocate(shard2, allocation)) continue;
                    candidates.add(shard2);
                }
            }
            List unmovableShardNodeDecisions = candidates.stream().filter(s -> this.allocatedToTier((ShardRouting)s, allocation)).flatMap(shard -> this.cannotRemainDueToStorage((ShardRouting)shard, allocation).stream()).toList();
            Map perShardIdUnmovable = unmovableShardNodeDecisions.stream().collect(Collectors.toMap(snd -> snd.shard().shardId(), Function.identity(), AllocationState::preferPrimary, TreeMap::new));
            Map<ShardId, NodeDecisions> otherNodesOnTierAllocationDecisions = perShardIdUnmovable.values().stream().limit(5L).collect(Collectors.toMap(snd -> snd.shard().shardId(), snd -> new NodeDecisions(this.canAllocateDecisions(allocation, snd.shard()), snd.nodeDecision())));
            Set unmovableShards = unmovableShardNodeDecisions.stream().map(e -> e.shard).collect(Collectors.toSet());
            long unmovableBytes = unmovableShards.stream().collect(Collectors.groupingBy(ShardRouting::currentNodeId)).entrySet().stream().mapToLong(e -> this.unmovableSize((String)e.getKey(), (Collection)e.getValue())).sum();
            List unallocatedShardNodeDecisions = candidates.stream().filter(Predicate.not(unmovableShards::contains)).flatMap(shard -> this.cannotAllocateDueToStorage((ShardRouting)shard, allocation).stream()).toList();
            Map perShardIdUnallocated = unallocatedShardNodeDecisions.stream().collect(Collectors.toMap(snd -> snd.shard().shardId(), Function.identity(), AllocationState::preferPrimary, TreeMap::new));
            Map<ShardId, NodeDecisions> canRemainDecisionsForUnallocatedShards = perShardIdUnallocated.values().stream().limit(5L).collect(Collectors.toMap(snd -> snd.shard().shardId(), snd -> new NodeDecisions(snd.nodeDecisions(), this.canRemainDecision(allocation, snd.shard()))));
            long unallocatableBytes = unallocatedShardNodeDecisions.stream().map(e -> e.shard).mapToLong(this::sizeOf).sum();
            Map shardDecisions = Stream.concat(canRemainDecisionsForUnallocatedShards.entrySet().stream(), otherNodesOnTierAllocationDecisions.entrySet().stream()).collect(AllocationState.toSortedMap(Map.Entry::getKey, Map.Entry::getValue)).entrySet().stream().limit(5L).collect(AllocationState.toSortedMap(Map.Entry::getKey, Map.Entry::getValue));
            return new ShardsAllocationResults(unallocatableBytes + unmovableBytes, Stream.concat(unmovableShardNodeDecisions.stream(), unallocatedShardNodeDecisions.stream()).map(e -> ((ShardNodeDecision)((Object)e)).shard().shardId()).collect(Collectors.toCollection(TreeSet::new)), shardDecisions);
        }

        private List<NodeDecision> canAllocateDecisions(RoutingAllocation allocation, ShardRouting shardRouting) {
            return this.state.getRoutingNodes().stream().filter(n -> this.nodeTierPredicate.test(n.node())).filter(n -> !shardRouting.currentNodeId().equals(n.nodeId())).map(n -> new NodeDecision(n.node(), AllocationState.withAllocationDebugEnabled(allocation, () -> this.allocationDeciders.canAllocate(shardRouting, n, allocation)))).toList();
        }

        private NodeDecision canRemainDecision(RoutingAllocation allocation, ShardRouting shard) {
            return new NodeDecision(allocation.routingNodes().node(shard.currentNodeId()).node(), AllocationState.withAllocationDebugEnabled(allocation, () -> this.allocationDeciders.canRemain(shard, allocation.routingNodes().node(shard.currentNodeId()), allocation)));
        }

        private static <T extends Decision> T withAllocationDebugEnabled(RoutingAllocation allocation, Supplier<T> supplier) {
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                Decision decision = (Decision)supplier.get();
                return (T)decision;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        private static <T> Collector<T, ?, SortedMap<ShardId, NodeDecisions>> toSortedMap(Function<T, ShardId> keyMapper, Function<T, NodeDecisions> valueMapper) {
            return Collectors.toMap(keyMapper, valueMapper, (a, b) -> b, TreeMap::new);
        }

        public boolean canRemainOnlyHighestTierPreference(ShardRouting shard, RoutingAllocation allocation) {
            boolean result;
            boolean bl = result = this.allocationDeciders.canRemain(shard, allocation.routingNodes().node(shard.currentNodeId()), allocation) != Decision.NO;
            if (result && this.nodes.isEmpty() && Strings.hasText((String)((String)DataTier.TIER_PREFERENCE_SETTING.get(AllocationState.indexMetadata(shard, allocation).getSettings())))) {
                return !this.isAssignedToTier(shard, allocation);
            }
            return result;
        }

        private boolean allocatedToTier(ShardRouting s, RoutingAllocation allocation) {
            return this.nodeTierPredicate.test(allocation.routingNodes().node(s.currentNodeId()).node());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Optional<ShardNodeAllocationDecision> cannotAllocateDueToStorage(ShardRouting shard, RoutingAllocation allocation) {
            if (this.nodeIds.isEmpty() && this.needsThisTier(shard, allocation)) {
                return Optional.of(new ShardNodeAllocationDecision(shard, List.of()));
            }
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                boolean hasResizeOnly;
                List<NodeDecision> nodeDecisions = this.nodesInTier(allocation.routingNodes()).map(node -> new NodeDecision(node.node(), this.allocationDeciders.canAllocate(shard, node, allocation))).toList();
                List<NodeDecision> diskOnly = nodeDecisions.stream().filter(nar -> ReactiveStorageDeciderService.isDiskOnlyNoDecision(nar.decision())).toList();
                if (diskOnly.size() > 0 && shard.unassigned() && shard.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS && (hasResizeOnly = this.nodesInTier(allocation.routingNodes()).map(node -> this.allocationDeciders.canAllocate(shard, node, allocation)).anyMatch(ReactiveStorageDeciderService::isResizeOnlyNoDecision))) {
                    Optional<ShardNodeAllocationDecision> optional = Optional.empty();
                    return optional;
                }
                Optional<ShardNodeAllocationDecision> optional = diskOnly.size() > 0 ? Optional.of(new ShardNodeAllocationDecision(shard, nodeDecisions)) : Optional.empty();
                return optional;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Optional<ShardNodeRemainDecision> cannotRemainDueToStorage(ShardRouting shard, RoutingAllocation allocation) {
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                RoutingNode node = allocation.routingNodes().node(shard.currentNodeId());
                Decision decision = this.allocationDeciders.canRemain(shard, node, allocation);
                Optional<ShardNodeRemainDecision> optional = ReactiveStorageDeciderService.isDiskOnlyNoDecision(decision) ? Optional.of(new ShardNodeRemainDecision(shard, new NodeDecision(node.node(), decision))) : Optional.empty();
                return optional;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        private boolean canAllocate(ShardRouting shard, RoutingAllocation allocation) {
            return this.nodesInTier(allocation.routingNodes()).anyMatch(node -> this.allocationDeciders.canAllocate(shard, node, allocation) != Decision.NO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean needsThisTier(ShardRouting shard, RoutingAllocation allocation) {
            if (!this.isAssignedToTier(shard, allocation)) {
                return false;
            }
            IndexMetadata indexMetadata = AllocationState.indexMetadata(shard, allocation);
            Set decisionTypes = allocation.routingNodes().stream().map(node -> DataTierAllocationDecider.shouldFilter((IndexMetadata)indexMetadata, (DiscoveryNode)node.node(), AllocationState::highestPreferenceTier, (RoutingAllocation)allocation)).map(Decision::type).collect(Collectors.toSet());
            if (decisionTypes.contains(Decision.Type.NO)) {
                return decisionTypes.size() == 1;
            }
            if (!shard.primary()) {
                return false;
            }
            assert (!allocation.debugDecision());
            allocation.debugDecision(true);
            try {
                boolean bl = allocation.routingNodes().stream().anyMatch(node -> ReactiveStorageDeciderService.isFilterTierOnlyDecision(this.allocationDeciders.canAllocate(shard, node, allocation), indexMetadata));
                return bl;
            }
            finally {
                allocation.debugDecision(false);
            }
        }

        private boolean isAssignedToTier(ShardRouting shard, RoutingAllocation allocation) {
            IndexMetadata indexMetadata = AllocationState.indexMetadata(shard, allocation);
            return AllocationState.isAssignedToTier(indexMetadata, this.roles);
        }

        private static boolean isAssignedToTier(IndexMetadata indexMetadata, Set<DiscoveryNodeRole> roles) {
            List tierPreference = indexMetadata.getTierPreference();
            return tierPreference.isEmpty() || DataTierAllocationDecider.allocationAllowed((String)AllocationState.highestPreferenceTier(tierPreference), roles);
        }

        private static IndexMetadata indexMetadata(ShardRouting shard, RoutingAllocation allocation) {
            return allocation.metadata().getProject().getIndexSafe(shard.index());
        }

        private static Optional<String> highestPreferenceTier(List<String> preferredTiers, DiscoveryNodes unused, DesiredNodes desiredNodes, NodesShutdownMetadata shutdownMetadata) {
            return Optional.of(AllocationState.highestPreferenceTier(preferredTiers));
        }

        private static String highestPreferenceTier(List<String> preferredTiers) {
            assert (!preferredTiers.isEmpty());
            return preferredTiers.get(0);
        }

        public long maxShardSize() {
            return this.nodesInTier(this.state.getRoutingNodes()).flatMap(rn -> StreamSupport.stream(rn.spliterator(), false)).mapToLong(this::sizeOf).max().orElse(0L);
        }

        public long maxNodeLockedSize() {
            Metadata metadata = this.originalState.getMetadata();
            return metadata.getProject().indices().values().stream().mapToLong(imd -> this.nodeLockedSize((IndexMetadata)imd, metadata)).max().orElse(0L);
        }

        private long nodeLockedSize(IndexMetadata indexMetadata, Metadata metadata) {
            IndexMetadata sourceIndexMetadata;
            if (AllocationState.isNodeLocked(indexMetadata)) {
                IndexRoutingTable indexRoutingTable = this.state.getRoutingTable().index(indexMetadata.getIndex());
                long sum = 0L;
                for (int s = 0; s < indexMetadata.getNumberOfShards(); ++s) {
                    ShardRouting shard = indexRoutingTable.shard(s).primaryShard();
                    long size = this.sizeOf(shard);
                    sum += size;
                }
                if (indexMetadata.getResizeSourceIndex() != null) {
                    sum *= 2L;
                }
                return sum;
            }
            Index resizeSourceIndex = indexMetadata.getResizeSourceIndex();
            if (resizeSourceIndex != null && (sourceIndexMetadata = metadata.getProject().index(resizeSourceIndex)) != null && indexMetadata.getNumberOfShards() >= sourceIndexMetadata.getNumberOfShards()) {
                IndexRoutingTable indexRoutingTable = this.state.getRoutingTable().index(resizeSourceIndex);
                long max = 0L;
                for (int s = 0; s < sourceIndexMetadata.getNumberOfShards(); ++s) {
                    ShardRouting shard = indexRoutingTable.shard(s).primaryShard();
                    long size = this.sizeOf(shard);
                    max = Math.max(max, size);
                }
                return max * 2L;
            }
            return 0L;
        }

        long sizeOf(ShardRouting shard) {
            ShardRouting primary;
            long expectedShardSize = this.getExpectedShardSize(shard);
            if (expectedShardSize == 0L && !shard.primary() && (primary = this.state.getRoutingNodes().activePrimary(shard.shardId())) != null) {
                expectedShardSize = this.getExpectedShardSize(primary);
            }
            assert (expectedShardSize >= 0L);
            return expectedShardSize == 0L ? ByteSizeUnit.KB.toBytes(1L) : expectedShardSize;
        }

        private long getExpectedShardSize(ShardRouting shard) {
            ProjectMetadata project = this.state.metadata().projectFor(shard.index());
            return ExpectedShardSizeEstimator.getExpectedShardSize((ShardRouting)shard, (long)0L, (ExpectedShardSizeEstimator.ShardSizeProvider)this.info, (SnapshotShardSizeInfo)this.shardSizeInfo, (ProjectMetadata)project, (RoutingTable)this.state.globalRoutingTable().routingTable(project.id()));
        }

        long unmovableSize(String nodeId, Collection<ShardRouting> shards) {
            DiskUsage diskUsage = (DiskUsage)this.info.getNodeMostAvailableDiskUsages().get(nodeId);
            if (diskUsage == null) {
                return 0L;
            }
            long threshold = this.diskThresholdSettings.getFreeBytesThresholdHighStage(ByteSizeValue.ofBytes((long)diskUsage.totalBytes())).getBytes();
            long missing = threshold - diskUsage.freeBytes();
            return Math.max(missing, shards.stream().mapToLong(this::sizeOf).min().orElseThrow());
        }

        Stream<RoutingNode> nodesInTier(RoutingNodes routingNodes) {
            return this.nodeIds.stream().map(arg_0 -> ((RoutingNodes)routingNodes).node(arg_0));
        }

        public AllocationState forecast(long forecastWindow, long now) {
            if (forecastWindow == 0L) {
                return this;
            }
            DataStreamMetadata dataStreamMetadata = (DataStreamMetadata)this.state.metadata().getProject().custom("data_stream");
            if (dataStreamMetadata == null) {
                return this;
            }
            List<SingleForecast> singleForecasts = dataStreamMetadata.dataStreams().keySet().stream().map(this.state.metadata().getProject().getIndicesLookup()::get).map(DataStream.class::cast).map(ds -> this.forecast(this.state.metadata(), (DataStream)ds, forecastWindow, now)).filter(Objects::nonNull).toList();
            if (singleForecasts.isEmpty()) {
                return this;
            }
            Metadata.Builder metadataBuilder = Metadata.builder((Metadata)this.state.metadata());
            RoutingTable.Builder routingTableBuilder = RoutingTable.builder((ShardRoutingRoleStrategy)this.shardRoutingRoleStrategy, (RoutingTable)this.state.routingTable());
            HashMap sizeBuilder = new HashMap();
            singleForecasts.forEach(p -> p.applyMetadata(metadataBuilder));
            singleForecasts.forEach(p -> p.applyRouting(routingTableBuilder));
            RoutingTable routingTable = routingTableBuilder.build();
            singleForecasts.forEach(p -> p.applySize(sizeBuilder, routingTable));
            ClusterState forecastClusterState = ClusterState.builder((ClusterState)this.state).metadata(metadataBuilder).routingTable(routingTable).build();
            ExtendedClusterInfo forecastInfo = new ExtendedClusterInfo(Collections.unmodifiableMap(sizeBuilder), this.info);
            return new AllocationState(forecastClusterState, this.allocationDeciders, this.shardRoutingRoleStrategy, this.diskThresholdSettings, forecastInfo, this.shardSizeInfo, this.nodes, this.roles);
        }

        private SingleForecast forecast(Metadata metadata, DataStream stream, long forecastWindow, long now) {
            int numberNewIndices;
            long scaledTotalSize;
            List indices = stream.getIndices();
            if (!this.dataStreamAllocatedToNodes(metadata, indices)) {
                return null;
            }
            long minCreationDate = Long.MAX_VALUE;
            long totalSize = 0L;
            int count = 0;
            while (count < indices.size()) {
                IndexMetadata indexMetadata = metadata.getProject().index((Index)indices.get(indices.size() - ++count));
                long creationDate = indexMetadata.getCreationDate();
                if (creationDate < 0L) {
                    return null;
                }
                minCreationDate = Math.min(minCreationDate, creationDate);
                totalSize += this.state.getRoutingTable().allShards(indexMetadata.getIndex().getName()).stream().mapToLong(this::sizeOf).sum();
                if (creationDate > now - forecastWindow) continue;
                break;
            }
            if (totalSize == 0L) {
                return null;
            }
            long avgSizeCeil = (totalSize - 1L) / (long)count + 1L;
            long actualWindow = now - minCreationDate;
            if (actualWindow == 0L) {
                return null;
            }
            if (actualWindow > forecastWindow) {
                scaledTotalSize = BigInteger.valueOf(totalSize).multiply(BigInteger.valueOf(forecastWindow)).divide(BigInteger.valueOf(actualWindow)).longValueExact();
                numberNewIndices = (int)Math.min((scaledTotalSize - 1L) / avgSizeCeil + 1L, (long)indices.size());
                if (scaledTotalSize == 0L) {
                    return null;
                }
            } else {
                numberNewIndices = count;
                scaledTotalSize = totalSize;
            }
            IndexMetadata writeIndex = metadata.getProject().index(stream.getWriteIndex());
            HashMap<IndexMetadata, Long> newIndices = new HashMap<IndexMetadata, Long>();
            for (int i = 0; i < numberNewIndices; ++i) {
                String uuid = UUIDs.randomBase64UUID();
                Tuple rolledDataStreamInfo = stream.unsafeNextWriteIndexAndGeneration(this.state.metadata().getProject(), stream.getDataComponent());
                stream = stream.unsafeRollover(new Index((String)rolledDataStreamInfo.v1(), uuid), ((Long)rolledDataStreamInfo.v2()).longValue(), null, stream.getAutoShardingEvent());
                IndexMetadata newIndex = IndexMetadata.builder((IndexMetadata)writeIndex).index(stream.getWriteIndex().getName()).settings(Settings.builder().put(writeIndex.getSettings()).put("index.uuid", uuid)).build();
                long size = Math.min(avgSizeCeil, scaledTotalSize - avgSizeCeil * (long)i);
                assert (size > 0L);
                newIndices.put(newIndex, size);
            }
            return new SingleForecast(newIndices, stream);
        }

        private boolean dataStreamAllocatedToNodes(Metadata metadata, List<Index> indices) {
            for (int i = 0; i < indices.size(); ++i) {
                IndexMetadata indexMetadata = metadata.getProject().index(indices.get(indices.size() - i - 1));
                Set inNodes = this.state.getRoutingTable().allShards(indexMetadata.getIndex().getName()).stream().map(ShardRouting::currentNodeId).filter(Objects::nonNull).map(this.nodeIds::contains).collect(Collectors.toSet());
                if (inNodes.contains(false)) {
                    return false;
                }
                if (!inNodes.contains(true)) continue;
                return true;
            }
            return false;
        }

        ClusterState state() {
            return this.state;
        }

        ClusterInfo info() {
            return this.info;
        }

        private static ClusterState removeNodeLockFilters(ClusterState state) {
            ClusterState.Builder builder = ClusterState.builder((ClusterState)state);
            builder.metadata(AllocationState.removeNodeLockFilters(state.metadata()));
            return builder.build();
        }

        private static Metadata removeNodeLockFilters(Metadata metadata) {
            ProjectMetadata updatedProject = AllocationState.removeNodeLockFilters(metadata.getProject());
            return Metadata.builder((Metadata)metadata).put(updatedProject).build();
        }

        private static ProjectMetadata removeNodeLockFilters(ProjectMetadata project) {
            ProjectMetadata.Builder builder = ProjectMetadata.builder((ProjectMetadata)project);
            project.stream().filter(AllocationState::isNodeLocked).map(AllocationState::removeNodeLockFilters).forEach(imd -> builder.put(imd, false));
            return builder.build();
        }

        private static IndexMetadata removeNodeLockFilters(IndexMetadata indexMetadata) {
            Settings settings = indexMetadata.getSettings();
            settings = AllocationState.removeNodeLockFilters(settings, REMOVE_NODE_LOCKED_FILTER_INITIAL, indexMetadata.getInitialRecoveryFilters());
            settings = AllocationState.removeNodeLockFilters(settings, REMOVE_NODE_LOCKED_FILTER_REQUIRE, indexMetadata.requireFilters());
            settings = AllocationState.removeNodeLockFilters(settings, REMOVE_NODE_LOCKED_FILTER_INCLUDE, indexMetadata.includeFilters());
            return IndexMetadata.builder((IndexMetadata)indexMetadata).settings(settings).build();
        }

        private static Settings removeNodeLockFilters(Settings settings, Predicate<String> predicate, DiscoveryNodeFilters filters) {
            if (filters != null && filters.isSingleNodeFilter()) {
                return settings.filter(predicate);
            }
            return settings;
        }

        private static boolean isNodeLocked(IndexMetadata indexMetadata) {
            return AllocationState.isNodeLocked(indexMetadata.requireFilters()) || AllocationState.isNodeLocked(indexMetadata.includeFilters()) || AllocationState.isNodeLocked(indexMetadata.getInitialRecoveryFilters());
        }

        private static boolean isNodeLocked(DiscoveryNodeFilters filters) {
            return filters != null && filters.isSingleNodeFilter();
        }

        private static interface ShardNodeDecision {
            public ShardRouting shard();
        }

        record ShardNodeAllocationDecision(ShardRouting shard, List<NodeDecision> nodeDecisions) implements ShardNodeDecision
        {
        }

        record ShardNodeRemainDecision(ShardRouting shard, NodeDecision nodeDecision) implements ShardNodeDecision
        {
        }

        private static class ExtendedClusterInfo
        extends ClusterInfo {
            private final ClusterInfo delegate;

            private ExtendedClusterInfo(Map<String, Long> extraShardSizes, ClusterInfo info) {
                super(info.getNodeLeastAvailableDiskUsages(), info.getNodeMostAvailableDiskUsages(), extraShardSizes, Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of());
                this.delegate = info;
            }

            public Long getShardSize(ShardRouting shardRouting) {
                Long shardSize = super.getShardSize(shardRouting);
                if (shardSize != null) {
                    return shardSize;
                }
                return this.delegate.getShardSize(shardRouting);
            }

            public long getShardSize(ShardRouting shardRouting, long defaultValue) {
                Long shardSize = super.getShardSize(shardRouting);
                if (shardSize != null) {
                    return shardSize;
                }
                return this.delegate.getShardSize(shardRouting, defaultValue);
            }

            public Optional<Long> getShardDataSetSize(ShardId shardId) {
                return this.delegate.getShardDataSetSize(shardId);
            }

            public String getDataPath(ShardRouting shardRouting) {
                return this.delegate.getDataPath(shardRouting);
            }

            public ClusterInfo.ReservedSpace getReservedSpace(String nodeId, String dataPath) {
                return this.delegate.getReservedSpace(nodeId, dataPath);
            }

            public void writeTo(StreamOutput out) throws IOException {
                throw new UnsupportedOperationException();
            }

            public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
                throw new UnsupportedOperationException();
            }
        }

        private static class SingleForecast {
            private final Map<IndexMetadata, Long> additionalIndices;
            private final DataStream updatedDataStream;

            private SingleForecast(Map<IndexMetadata, Long> additionalIndices, DataStream updatedDataStream) {
                this.additionalIndices = additionalIndices;
                this.updatedDataStream = updatedDataStream;
            }

            public void applyRouting(RoutingTable.Builder routing) {
                this.additionalIndices.keySet().forEach(indexMetadata -> routing.addAsNew(indexMetadata));
            }

            public void applyMetadata(Metadata.Builder metadataBuilder) {
                ProjectId projectId = ProjectId.DEFAULT;
                ProjectMetadata.Builder projectBuilder = metadataBuilder.getProject(projectId);
                if (projectBuilder == null) {
                    projectBuilder = ProjectMetadata.builder((ProjectId)projectId);
                    metadataBuilder.put(projectBuilder);
                }
                this.applyProjectMetadata(projectBuilder);
            }

            public void applyProjectMetadata(ProjectMetadata.Builder projectBuilder) {
                this.additionalIndices.keySet().forEach(imd -> projectBuilder.put(imd, false));
                projectBuilder.put(this.updatedDataStream);
            }

            public void applySize(Map<String, Long> builder, RoutingTable updatedRoutingTable) {
                for (Map.Entry<IndexMetadata, Long> entry : this.additionalIndices.entrySet()) {
                    List shardRoutings = updatedRoutingTable.allShards(entry.getKey().getIndex().getName());
                    long size = entry.getValue() / (long)shardRoutings.size();
                    shardRoutings.forEach(s -> builder.put(ClusterInfo.shardIdentifierFromRouting((ShardRouting)s), size));
                }
            }
        }
    }
}

