/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.docbuilder;

import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import java.util.List;

public record MappingHints(boolean aggregateMetricDouble, boolean docCount) {
    public static final String MAPPING_HINTS = "elasticsearch.mapping.hints";
    public static final String AGGREGATE_METRIC_DOUBLE = "aggregate_metric_double";
    public static final String DOC_COUNT = "_doc_count";
    private static final MappingHints EMPTY = new MappingHints(false, false);

    public static MappingHints fromAttributes(List<KeyValue> attributes) {
        boolean aggregateMetricDouble = false;
        boolean docCount = false;
        int attributesSize = attributes.size();
        for (int i = 0; i < attributesSize; ++i) {
            KeyValue attribute = attributes.get(i);
            if (!attribute.getKey().equals(MAPPING_HINTS)) continue;
            if (attribute.getValue().hasArrayValue()) {
                List<AnyValue> valuesList = attribute.getValue().getArrayValue().getValuesList();
                int valuesListSize = valuesList.size();
                for (int j = 0; j < valuesListSize; ++j) {
                    AnyValue hint = valuesList.get(j);
                    if (!hint.hasStringValue()) continue;
                    String value = hint.getStringValue();
                    if (value.equals(AGGREGATE_METRIC_DOUBLE)) {
                        aggregateMetricDouble = true;
                        continue;
                    }
                    if (!value.equals(DOC_COUNT)) continue;
                    docCount = true;
                }
            }
            return new MappingHints(aggregateMetricDouble, docCount);
        }
        return EMPTY;
    }

    public static MappingHints empty() {
        return EMPTY;
    }

    public static boolean isMappingHintsAttribute(String attributeKey) {
        return attributeKey.equals(MAPPING_HINTS);
    }
}

