/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.datapoint;

import io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.HistogramDataPoint;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;

class HistogramConverter {
    HistogramConverter() {
    }

    static <E extends Exception> void counts(ExponentialHistogramDataPoint dp, CheckedLongConsumer<E> counts) throws E {
        ExponentialHistogramDataPoint.Buckets negative = dp.getNegative();
        for (int i = negative.getBucketCountsCount() - 1; i >= 0; --i) {
            long count = negative.getBucketCounts(i);
            if (count == 0L) continue;
            counts.accept(count);
        }
        long zeroCount = dp.getZeroCount();
        if (zeroCount > 0L) {
            counts.accept(zeroCount);
        }
        ExponentialHistogramDataPoint.Buckets positive = dp.getPositive();
        for (int i = 0; i < positive.getBucketCountsCount(); ++i) {
            long count = positive.getBucketCounts(i);
            if (count == 0L) continue;
            counts.accept(count);
        }
    }

    static <E extends Exception> void centroidValues(ExponentialHistogramDataPoint dp, CheckedDoubleConsumer<E> values) throws E {
        int scale = dp.getScale();
        ExponentialHistogramDataPoint.Buckets negative = dp.getNegative();
        int offset = negative.getOffset();
        for (int i = negative.getBucketCountsCount() - 1; i >= 0; --i) {
            long count = negative.getBucketCounts(i);
            if (count == 0L) continue;
            double lb = -ExponentialScaleUtils.getUpperBucketBoundary((long)(offset + i), (int)scale);
            double ub = -ExponentialScaleUtils.getLowerBucketBoundary((long)(offset + i), (int)scale);
            values.accept(lb + (ub - lb) / 2.0);
        }
        long zeroCount = dp.getZeroCount();
        if (zeroCount > 0L) {
            values.accept(0.0);
        }
        ExponentialHistogramDataPoint.Buckets positive = dp.getPositive();
        offset = positive.getOffset();
        for (int i = 0; i < positive.getBucketCountsCount(); ++i) {
            long count = positive.getBucketCounts(i);
            if (count == 0L) continue;
            double lb = ExponentialScaleUtils.getLowerBucketBoundary((long)(offset + i), (int)scale);
            double ub = ExponentialScaleUtils.getUpperBucketBoundary((long)(offset + i), (int)scale);
            values.accept(lb + (ub - lb) / 2.0);
        }
    }

    static <E extends Exception> void counts(HistogramDataPoint dp, CheckedLongConsumer<E> counts) throws E {
        for (int i = 0; i < dp.getBucketCountsCount(); ++i) {
            long count = dp.getBucketCounts(i);
            if (count == 0L) continue;
            counts.accept(count);
        }
    }

    static <E extends Exception> void centroidValues(HistogramDataPoint dp, CheckedDoubleConsumer<E> values) throws E {
        int size = dp.getBucketCountsCount();
        for (int i = 0; i < size; ++i) {
            double value;
            long count = dp.getBucketCounts(i);
            if (count == 0L) continue;
            if (i == 0) {
                value = dp.getExplicitBounds(i);
                if (value > 0.0) {
                    value /= 2.0;
                }
            } else {
                value = i == size - 1 ? dp.getExplicitBounds(i - 1) : dp.getExplicitBounds(i - 1) + (dp.getExplicitBounds(i) - dp.getExplicitBounds(i - 1)) / 2.0;
            }
            values.accept(value);
        }
    }

    static interface CheckedLongConsumer<E extends Exception> {
        public void accept(long var1) throws E;
    }

    static interface CheckedDoubleConsumer<E extends Exception> {
        public void accept(double var1) throws E;
    }
}

