/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.oteldata.otlp.datapoint;

import com.google.protobuf.ByteString;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.cluster.routing.TsidBuilder;
import org.elasticsearch.common.hash.BufferedMurmur3Hasher;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.DataPoint;
import org.elasticsearch.xpack.oteldata.otlp.datapoint.TargetIndex;
import org.elasticsearch.xpack.oteldata.otlp.proto.BufferedByteStringAccessor;
import org.elasticsearch.xpack.oteldata.otlp.tsid.DataPointTsidFunnel;
import org.elasticsearch.xpack.oteldata.otlp.tsid.ResourceTsidFunnel;
import org.elasticsearch.xpack.oteldata.otlp.tsid.ScopeTsidFunnel;

public class DataPointGroupingContext {
    private final BufferedByteStringAccessor byteStringAccessor;
    private final Map<MurmurHash3.Hash128, ResourceGroup> resourceGroups = new HashMap<MurmurHash3.Hash128, ResourceGroup>();
    private final Set<String> ignoredDataPointMessages = new HashSet<String>();
    private int totalDataPoints = 0;
    private int ignoredDataPoints = 0;

    public DataPointGroupingContext(BufferedByteStringAccessor byteStringAccessor) {
        this.byteStringAccessor = byteStringAccessor;
    }

    public void groupDataPoints(ExportMetricsServiceRequest exportMetricsServiceRequest) {
        List<ResourceMetrics> resourceMetricsList = exportMetricsServiceRequest.getResourceMetricsList();
        for (int i = 0; i < resourceMetricsList.size(); ++i) {
            ResourceMetrics resourceMetrics = resourceMetricsList.get(i);
            ResourceGroup resourceGroup = this.getOrCreateResourceGroup(resourceMetrics);
            List<ScopeMetrics> scopeMetricsList = resourceMetrics.getScopeMetricsList();
            for (int j = 0; j < scopeMetricsList.size(); ++j) {
                ScopeMetrics scopeMetrics = scopeMetricsList.get(j);
                ScopeGroup scopeGroup = resourceGroup.getOrCreateScope(scopeMetrics);
                List<Metric> metricsList = scopeMetrics.getMetricsList();
                block9: for (int k = 0; k < metricsList.size(); ++k) {
                    Metric metric = metricsList.get(k);
                    switch (metric.getDataCase()) {
                        case SUM: {
                            scopeGroup.addDataPoints(metric, metric.getSum().getDataPointsList(), DataPoint.Number::new);
                            continue block9;
                        }
                        case GAUGE: {
                            scopeGroup.addDataPoints(metric, metric.getGauge().getDataPointsList(), DataPoint.Number::new);
                            continue block9;
                        }
                        case EXPONENTIAL_HISTOGRAM: {
                            scopeGroup.addDataPoints(metric, metric.getExponentialHistogram().getDataPointsList(), DataPoint.ExponentialHistogram::new);
                            continue block9;
                        }
                        case HISTOGRAM: {
                            scopeGroup.addDataPoints(metric, metric.getHistogram().getDataPointsList(), DataPoint.Histogram::new);
                            continue block9;
                        }
                        case SUMMARY: {
                            scopeGroup.addDataPoints(metric, metric.getSummary().getDataPointsList(), DataPoint.Summary::new);
                            continue block9;
                        }
                        default: {
                            ++this.ignoredDataPoints;
                            this.ignoredDataPointMessages.add("unsupported metric type " + String.valueOf((Object)metric.getDataCase()));
                        }
                    }
                }
            }
        }
    }

    public <E extends Exception> void consume(CheckedConsumer<DataPointGroup, E> consumer) throws E {
        Iterator<ResourceGroup> iterator = this.resourceGroups.values().iterator();
        while (iterator.hasNext()) {
            ResourceGroup resourceGroup = iterator.next();
            iterator.remove();
            resourceGroup.forEach(consumer);
        }
    }

    public int totalDataPoints() {
        return this.totalDataPoints;
    }

    public int getIgnoredDataPoints() {
        return this.ignoredDataPoints;
    }

    public String getIgnoredDataPointsMessage() {
        return this.ignoredDataPointMessages.isEmpty() ? "" : String.join((CharSequence)"\n", this.ignoredDataPointMessages);
    }

    private ResourceGroup getOrCreateResourceGroup(ResourceMetrics resourceMetrics) {
        TsidBuilder resourceTsidBuilder = ResourceTsidFunnel.forResource(this.byteStringAccessor, resourceMetrics);
        MurmurHash3.Hash128 resourceHash = resourceTsidBuilder.hash();
        ResourceGroup resourceGroup = this.resourceGroups.get(resourceHash);
        if (resourceGroup == null) {
            resourceGroup = new ResourceGroup(resourceMetrics.getResource(), resourceMetrics.getSchemaUrlBytes(), resourceTsidBuilder);
            this.resourceGroups.put(resourceHash, resourceGroup);
        }
        return resourceGroup;
    }

    class ResourceGroup {
        private final Resource resource;
        private final ByteString resourceSchemaUrl;
        private final TsidBuilder resourceTsidBuilder;
        private final Map<MurmurHash3.Hash128, ScopeGroup> scopes;

        ResourceGroup(Resource resource, ByteString resourceSchemaUrl, TsidBuilder resourceTsidBuilder) {
            this.resource = resource;
            this.resourceSchemaUrl = resourceSchemaUrl;
            this.resourceTsidBuilder = resourceTsidBuilder;
            this.scopes = new HashMap<MurmurHash3.Hash128, ScopeGroup>();
        }

        public ScopeGroup getOrCreateScope(ScopeMetrics scopeMetrics) {
            TsidBuilder scopeTsidBuilder = ScopeTsidFunnel.forScope(DataPointGroupingContext.this.byteStringAccessor, scopeMetrics);
            MurmurHash3.Hash128 scopeHash = scopeTsidBuilder.hash();
            scopeTsidBuilder.addAll(this.resourceTsidBuilder);
            ScopeGroup scopeGroup = this.scopes.get(scopeHash);
            if (scopeGroup == null) {
                scopeGroup = new ScopeGroup(this, scopeMetrics.getScope(), scopeMetrics.getSchemaUrlBytes(), scopeTsidBuilder);
                this.scopes.put(scopeHash, scopeGroup);
            }
            return scopeGroup;
        }

        public <E extends Exception> void forEach(CheckedConsumer<DataPointGroup, E> consumer) throws E {
            for (ScopeGroup scopeGroup : this.scopes.values()) {
                scopeGroup.forEach(consumer);
            }
        }
    }

    class ScopeGroup {
        private static final String RECEIVER = "/receiver/";
        private final ResourceGroup resourceGroup;
        private final InstrumentationScope scope;
        private final ByteString scopeSchemaUrl;
        private final TsidBuilder scopeTsidBuilder;
        @Nullable
        private final String receiverName;
        private final Map<TargetIndex, Map<MurmurHash3.Hash128, Map<MurmurHash3.Hash128, DataPointGroup>>> dataPointGroupsByIndexAndTimestamp;

        ScopeGroup(ResourceGroup resourceGroup, InstrumentationScope scope, ByteString scopeSchemaUrl, TsidBuilder scopeTsidBuilder) {
            this.resourceGroup = resourceGroup;
            this.scope = scope;
            this.scopeSchemaUrl = scopeSchemaUrl;
            this.scopeTsidBuilder = scopeTsidBuilder;
            this.dataPointGroupsByIndexAndTimestamp = new HashMap<TargetIndex, Map<MurmurHash3.Hash128, Map<MurmurHash3.Hash128, DataPointGroup>>>();
            this.receiverName = this.extractReceiverName(scope);
        }

        @Nullable
        private String extractReceiverName(InstrumentationScope scope) {
            String scopeName = scope.getName();
            int indexOfReceiver = scopeName.indexOf(RECEIVER);
            if (indexOfReceiver >= 0) {
                int beginIndex = indexOfReceiver + RECEIVER.length();
                int endIndex = scopeName.indexOf(47, beginIndex);
                if (endIndex < 0) {
                    endIndex = scopeName.length();
                }
                return scopeName.substring(beginIndex, endIndex);
            }
            return null;
        }

        public <T> void addDataPoints(Metric metric, List<T> dataPoints, BiFunction<T, Metric, DataPoint> createDataPoint) {
            for (int i = 0; i < dataPoints.size(); ++i) {
                T dataPoint = dataPoints.get(i);
                this.addDataPoint(createDataPoint.apply(dataPoint, metric));
            }
        }

        public void addDataPoint(DataPoint dataPoint) {
            ++DataPointGroupingContext.this.totalDataPoints;
            if (!dataPoint.isValid(DataPointGroupingContext.this.ignoredDataPointMessages)) {
                ++DataPointGroupingContext.this.ignoredDataPoints;
                return;
            }
            DataPointGroup dataPointGroup = this.getOrCreateDataPointGroup(dataPoint);
            if (!dataPointGroup.addDataPoint(DataPointGroupingContext.this.ignoredDataPointMessages, dataPoint)) {
                ++DataPointGroupingContext.this.ignoredDataPoints;
            }
        }

        private DataPointGroup getOrCreateDataPointGroup(DataPoint dataPoint) {
            TsidBuilder dataPointGroupTsidBuilder = DataPointTsidFunnel.forDataPoint(DataPointGroupingContext.this.byteStringAccessor, dataPoint, this.scopeTsidBuilder.size());
            MurmurHash3.Hash128 dataPointGroupHash = dataPointGroupTsidBuilder.hash();
            dataPointGroupTsidBuilder.addAll(this.scopeTsidBuilder);
            MurmurHash3.Hash128 timestamp = new MurmurHash3.Hash128(dataPoint.getTimestampUnixNano(), dataPoint.getStartTimestampUnixNano());
            TargetIndex targetIndex = TargetIndex.evaluate("metrics", dataPoint.getAttributes(), this.receiverName, this.scope.getAttributesList(), this.resourceGroup.resource.getAttributesList());
            Map dataPointGroupsByTimestamp = this.dataPointGroupsByIndexAndTimestamp.computeIfAbsent(targetIndex, k -> new HashMap());
            Map dataPointGroups = dataPointGroupsByTimestamp.computeIfAbsent(timestamp, k -> new HashMap());
            DataPointGroup dataPointGroup = (DataPointGroup)dataPointGroups.get(dataPointGroupHash);
            if (dataPointGroup == null) {
                dataPointGroup = new DataPointGroup(this.resourceGroup.resource, this.resourceGroup.resourceSchemaUrl, this.scope, this.scopeSchemaUrl, dataPointGroupTsidBuilder, dataPoint.getAttributes(), dataPoint.getUnit(), targetIndex);
                dataPointGroups.put(dataPointGroupHash, dataPointGroup);
            }
            return dataPointGroup;
        }

        public <E extends Exception> void forEach(CheckedConsumer<DataPointGroup, E> consumer) throws E {
            for (Map<MurmurHash3.Hash128, Map<MurmurHash3.Hash128, DataPointGroup>> dataPointGroupsByTime : this.dataPointGroupsByIndexAndTimestamp.values()) {
                for (Map<MurmurHash3.Hash128, DataPointGroup> dataPointGroups : dataPointGroupsByTime.values()) {
                    for (DataPointGroup dataPointGroup : dataPointGroups.values()) {
                        consumer.accept((Object)dataPointGroup);
                    }
                }
            }
        }
    }

    public static final class DataPointGroup {
        private final Resource resource;
        private final ByteString resourceSchemaUrl;
        private final InstrumentationScope scope;
        private final ByteString scopeSchemaUrl;
        private final TsidBuilder tsidBuilder;
        private final List<KeyValue> dataPointAttributes;
        private final String unit;
        private final Set<String> metricNames = new HashSet<String>();
        private final List<DataPoint> dataPoints = new ArrayList<DataPoint>();
        private final TargetIndex targetIndex;
        private String metricNamesHash;

        public DataPointGroup(Resource resource, ByteString resourceSchemaUrl, InstrumentationScope scope, ByteString scopeSchemaUrl, TsidBuilder tsidBuilder, List<KeyValue> dataPointAttributes, String unit, TargetIndex targetIndex) {
            this.resource = resource;
            this.resourceSchemaUrl = resourceSchemaUrl;
            this.scope = scope;
            this.scopeSchemaUrl = scopeSchemaUrl;
            this.tsidBuilder = tsidBuilder;
            this.dataPointAttributes = dataPointAttributes;
            this.unit = unit;
            this.targetIndex = targetIndex;
        }

        public long getTimestampUnixNano() {
            return this.dataPoints.getFirst().getTimestampUnixNano();
        }

        public long getStartTimestampUnixNano() {
            return this.dataPoints.getFirst().getStartTimestampUnixNano();
        }

        public String getMetricNamesHash(BufferedMurmur3Hasher hasher) {
            if (this.metricNamesHash == null) {
                hasher.reset();
                for (int i = 0; i < this.dataPoints.size(); ++i) {
                    hasher.addString(this.dataPoints.get(i).getMetricName());
                }
                this.metricNamesHash = Integer.toHexString(hasher.digestHash().hashCode());
            }
            return this.metricNamesHash;
        }

        public boolean addDataPoint(Set<String> ignoredDataPointMessages, DataPoint dataPoint) {
            this.metricNamesHash = null;
            if (!this.metricNames.add(dataPoint.getMetricName())) {
                ignoredDataPointMessages.add("Duplicate metric name '" + dataPoint.getMetricName() + "' for timestamp " + this.getTimestampUnixNano());
                return false;
            }
            this.dataPoints.add(dataPoint);
            return true;
        }

        public Resource resource() {
            return this.resource;
        }

        public ByteString resourceSchemaUrl() {
            return this.resourceSchemaUrl;
        }

        public InstrumentationScope scope() {
            return this.scope;
        }

        public ByteString scopeSchemaUrl() {
            return this.scopeSchemaUrl;
        }

        public TsidBuilder tsidBuilder() {
            return this.tsidBuilder;
        }

        public List<KeyValue> dataPointAttributes() {
            return this.dataPointAttributes;
        }

        public String unit() {
            return this.unit;
        }

        public List<DataPoint> dataPoints() {
            return this.dataPoints;
        }

        public TargetIndex targetIndex() {
            return this.targetIndex;
        }
    }
}

