/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.proto.trace.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilder;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.SingleFieldBuilder;
import com.google.protobuf.UninitializedMessageException;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.common.v1.KeyValueOrBuilder;
import io.opentelemetry.proto.trace.v1.SpanOrBuilder;
import io.opentelemetry.proto.trace.v1.Status;
import io.opentelemetry.proto.trace.v1.StatusOrBuilder;
import io.opentelemetry.proto.trace.v1.TraceProto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Span
extends GeneratedMessage
implements SpanOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int TRACE_ID_FIELD_NUMBER = 1;
    private ByteString traceId_ = ByteString.EMPTY;
    public static final int SPAN_ID_FIELD_NUMBER = 2;
    private ByteString spanId_ = ByteString.EMPTY;
    public static final int TRACE_STATE_FIELD_NUMBER = 3;
    private volatile Object traceState_ = "";
    public static final int PARENT_SPAN_ID_FIELD_NUMBER = 4;
    private ByteString parentSpanId_ = ByteString.EMPTY;
    public static final int FLAGS_FIELD_NUMBER = 16;
    private int flags_ = 0;
    public static final int NAME_FIELD_NUMBER = 5;
    private volatile Object name_ = "";
    public static final int KIND_FIELD_NUMBER = 6;
    private int kind_ = 0;
    public static final int START_TIME_UNIX_NANO_FIELD_NUMBER = 7;
    private long startTimeUnixNano_ = 0L;
    public static final int END_TIME_UNIX_NANO_FIELD_NUMBER = 8;
    private long endTimeUnixNano_ = 0L;
    public static final int ATTRIBUTES_FIELD_NUMBER = 9;
    private List<KeyValue> attributes_;
    public static final int DROPPED_ATTRIBUTES_COUNT_FIELD_NUMBER = 10;
    private int droppedAttributesCount_ = 0;
    public static final int EVENTS_FIELD_NUMBER = 11;
    private List<Event> events_;
    public static final int DROPPED_EVENTS_COUNT_FIELD_NUMBER = 12;
    private int droppedEventsCount_ = 0;
    public static final int LINKS_FIELD_NUMBER = 13;
    private List<Link> links_;
    public static final int DROPPED_LINKS_COUNT_FIELD_NUMBER = 14;
    private int droppedLinksCount_ = 0;
    public static final int STATUS_FIELD_NUMBER = 15;
    private Status status_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Span DEFAULT_INSTANCE;
    private static final Parser<Span> PARSER;

    private Span(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private Span() {
        this.traceId_ = ByteString.EMPTY;
        this.spanId_ = ByteString.EMPTY;
        this.traceState_ = "";
        this.parentSpanId_ = ByteString.EMPTY;
        this.name_ = "";
        this.kind_ = 0;
        this.attributes_ = Collections.emptyList();
        this.events_ = Collections.emptyList();
        this.links_ = Collections.emptyList();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_descriptor;
    }

    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_fieldAccessorTable.ensureFieldAccessorsInitialized(Span.class, Builder.class);
    }

    @Override
    public ByteString getTraceId() {
        return this.traceId_;
    }

    @Override
    public ByteString getSpanId() {
        return this.spanId_;
    }

    @Override
    public String getTraceState() {
        Object ref = this.traceState_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.traceState_ = s;
        return s;
    }

    @Override
    public ByteString getTraceStateBytes() {
        Object ref = this.traceState_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.traceState_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public ByteString getParentSpanId() {
        return this.parentSpanId_;
    }

    @Override
    public int getFlags() {
        return this.flags_;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getKindValue() {
        return this.kind_;
    }

    @Override
    public SpanKind getKind() {
        SpanKind result = SpanKind.forNumber(this.kind_);
        return result == null ? SpanKind.UNRECOGNIZED : result;
    }

    @Override
    public long getStartTimeUnixNano() {
        return this.startTimeUnixNano_;
    }

    @Override
    public long getEndTimeUnixNano() {
        return this.endTimeUnixNano_;
    }

    @Override
    public List<KeyValue> getAttributesList() {
        return this.attributes_;
    }

    @Override
    public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes_.size();
    }

    @Override
    public KeyValue getAttributes(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public KeyValueOrBuilder getAttributesOrBuilder(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public int getDroppedAttributesCount() {
        return this.droppedAttributesCount_;
    }

    @Override
    public List<Event> getEventsList() {
        return this.events_;
    }

    @Override
    public List<? extends EventOrBuilder> getEventsOrBuilderList() {
        return this.events_;
    }

    @Override
    public int getEventsCount() {
        return this.events_.size();
    }

    @Override
    public Event getEvents(int index) {
        return this.events_.get(index);
    }

    @Override
    public EventOrBuilder getEventsOrBuilder(int index) {
        return this.events_.get(index);
    }

    @Override
    public int getDroppedEventsCount() {
        return this.droppedEventsCount_;
    }

    @Override
    public List<Link> getLinksList() {
        return this.links_;
    }

    @Override
    public List<? extends LinkOrBuilder> getLinksOrBuilderList() {
        return this.links_;
    }

    @Override
    public int getLinksCount() {
        return this.links_.size();
    }

    @Override
    public Link getLinks(int index) {
        return this.links_.get(index);
    }

    @Override
    public LinkOrBuilder getLinksOrBuilder(int index) {
        return this.links_.get(index);
    }

    @Override
    public int getDroppedLinksCount() {
        return this.droppedLinksCount_;
    }

    @Override
    public boolean hasStatus() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Status getStatus() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    @Override
    public StatusOrBuilder getStatusOrBuilder() {
        return this.status_ == null ? Status.getDefaultInstance() : this.status_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!this.traceId_.isEmpty()) {
            output.writeBytes(1, this.traceId_);
        }
        if (!this.spanId_.isEmpty()) {
            output.writeBytes(2, this.spanId_);
        }
        if (!GeneratedMessage.isStringEmpty((Object)this.traceState_)) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)3, (Object)this.traceState_);
        }
        if (!this.parentSpanId_.isEmpty()) {
            output.writeBytes(4, this.parentSpanId_);
        }
        if (!GeneratedMessage.isStringEmpty((Object)this.name_)) {
            GeneratedMessage.writeString((CodedOutputStream)output, (int)5, (Object)this.name_);
        }
        if (this.kind_ != SpanKind.SPAN_KIND_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.kind_);
        }
        if (this.startTimeUnixNano_ != 0L) {
            output.writeFixed64(7, this.startTimeUnixNano_);
        }
        if (this.endTimeUnixNano_ != 0L) {
            output.writeFixed64(8, this.endTimeUnixNano_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.attributes_.get(i));
        }
        if (this.droppedAttributesCount_ != 0) {
            output.writeUInt32(10, this.droppedAttributesCount_);
        }
        for (i = 0; i < this.events_.size(); ++i) {
            output.writeMessage(11, (MessageLite)this.events_.get(i));
        }
        if (this.droppedEventsCount_ != 0) {
            output.writeUInt32(12, this.droppedEventsCount_);
        }
        for (i = 0; i < this.links_.size(); ++i) {
            output.writeMessage(13, (MessageLite)this.links_.get(i));
        }
        if (this.droppedLinksCount_ != 0) {
            output.writeUInt32(14, this.droppedLinksCount_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(15, (MessageLite)this.getStatus());
        }
        if (this.flags_ != 0) {
            output.writeFixed32(16, this.flags_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.traceId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)1, (ByteString)this.traceId_);
        }
        if (!this.spanId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)2, (ByteString)this.spanId_);
        }
        if (!GeneratedMessage.isStringEmpty((Object)this.traceState_)) {
            size += GeneratedMessage.computeStringSize((int)3, (Object)this.traceState_);
        }
        if (!this.parentSpanId_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)4, (ByteString)this.parentSpanId_);
        }
        if (!GeneratedMessage.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessage.computeStringSize((int)5, (Object)this.name_);
        }
        if (this.kind_ != SpanKind.SPAN_KIND_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.kind_);
        }
        if (this.startTimeUnixNano_ != 0L) {
            size += CodedOutputStream.computeFixed64Size((int)7, (long)this.startTimeUnixNano_);
        }
        if (this.endTimeUnixNano_ != 0L) {
            size += CodedOutputStream.computeFixed64Size((int)8, (long)this.endTimeUnixNano_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.attributes_.get(i)));
        }
        if (this.droppedAttributesCount_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)10, (int)this.droppedAttributesCount_);
        }
        for (i = 0; i < this.events_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)((MessageLite)this.events_.get(i)));
        }
        if (this.droppedEventsCount_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)12, (int)this.droppedEventsCount_);
        }
        for (i = 0; i < this.links_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)13, (MessageLite)((MessageLite)this.links_.get(i)));
        }
        if (this.droppedLinksCount_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)14, (int)this.droppedLinksCount_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getStatus());
        }
        if (this.flags_ != 0) {
            size += CodedOutputStream.computeFixed32Size((int)16, (int)this.flags_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Span)) {
            return super.equals(obj);
        }
        Span other = (Span)obj;
        if (!this.getTraceId().equals((Object)other.getTraceId())) {
            return false;
        }
        if (!this.getSpanId().equals((Object)other.getSpanId())) {
            return false;
        }
        if (!this.getTraceState().equals(other.getTraceState())) {
            return false;
        }
        if (!this.getParentSpanId().equals((Object)other.getParentSpanId())) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.kind_ != other.kind_) {
            return false;
        }
        if (this.getStartTimeUnixNano() != other.getStartTimeUnixNano()) {
            return false;
        }
        if (this.getEndTimeUnixNano() != other.getEndTimeUnixNano()) {
            return false;
        }
        if (!this.getAttributesList().equals(other.getAttributesList())) {
            return false;
        }
        if (this.getDroppedAttributesCount() != other.getDroppedAttributesCount()) {
            return false;
        }
        if (!this.getEventsList().equals(other.getEventsList())) {
            return false;
        }
        if (this.getDroppedEventsCount() != other.getDroppedEventsCount()) {
            return false;
        }
        if (!this.getLinksList().equals(other.getLinksList())) {
            return false;
        }
        if (this.getDroppedLinksCount() != other.getDroppedLinksCount()) {
            return false;
        }
        if (this.hasStatus() != other.hasStatus()) {
            return false;
        }
        if (this.hasStatus() && !this.getStatus().equals(other.getStatus())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Span.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getTraceId().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getSpanId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getTraceState().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getParentSpanId().hashCode();
        hash = 37 * hash + 16;
        hash = 53 * hash + this.getFlags();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 6;
        hash = 53 * hash + this.kind_;
        hash = 37 * hash + 7;
        hash = 53 * hash + Internal.hashLong((long)this.getStartTimeUnixNano());
        hash = 37 * hash + 8;
        hash = 53 * hash + Internal.hashLong((long)this.getEndTimeUnixNano());
        if (this.getAttributesCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAttributesList().hashCode();
        }
        hash = 37 * hash + 10;
        hash = 53 * hash + this.getDroppedAttributesCount();
        if (this.getEventsCount() > 0) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getEventsList().hashCode();
        }
        hash = 37 * hash + 12;
        hash = 53 * hash + this.getDroppedEventsCount();
        if (this.getLinksCount() > 0) {
            hash = 37 * hash + 13;
            hash = 53 * hash + this.getLinksList().hashCode();
        }
        hash = 37 * hash + 14;
        hash = 53 * hash + this.getDroppedLinksCount();
        if (this.hasStatus()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getStatus().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Span parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Span)PARSER.parseFrom(data);
    }

    public static Span parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Span)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Span parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Span)PARSER.parseFrom(data);
    }

    public static Span parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Span)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Span parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Span)PARSER.parseFrom(data);
    }

    public static Span parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Span)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Span parseFrom(InputStream input) throws IOException {
        return (Span)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Span parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Span)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Span parseDelimitedFrom(InputStream input) throws IOException {
        return (Span)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Span parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Span)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Span parseFrom(CodedInputStream input) throws IOException {
        return (Span)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Span parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Span)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Span.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Span prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Span getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Span> parser() {
        return PARSER;
    }

    public Parser<Span> getParserForType() {
        return PARSER;
    }

    public Span getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)32, (int)0, (String)"", (String)Span.class.getName());
        DEFAULT_INSTANCE = new Span();
        PARSER = new AbstractParser<Span>(){

            public Span parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = Span.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements SpanOrBuilder {
        private int bitField0_;
        private ByteString traceId_ = ByteString.EMPTY;
        private ByteString spanId_ = ByteString.EMPTY;
        private Object traceState_ = "";
        private ByteString parentSpanId_ = ByteString.EMPTY;
        private int flags_;
        private Object name_ = "";
        private int kind_ = 0;
        private long startTimeUnixNano_;
        private long endTimeUnixNano_;
        private List<KeyValue> attributes_ = Collections.emptyList();
        private RepeatedFieldBuilder<KeyValue, KeyValue.Builder, KeyValueOrBuilder> attributesBuilder_;
        private int droppedAttributesCount_;
        private List<Event> events_ = Collections.emptyList();
        private RepeatedFieldBuilder<Event, Event.Builder, EventOrBuilder> eventsBuilder_;
        private int droppedEventsCount_;
        private List<Link> links_ = Collections.emptyList();
        private RepeatedFieldBuilder<Link, Link.Builder, LinkOrBuilder> linksBuilder_;
        private int droppedLinksCount_;
        private Status status_;
        private SingleFieldBuilder<Status, Status.Builder, StatusOrBuilder> statusBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_fieldAccessorTable.ensureFieldAccessorsInitialized(Span.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.internalGetAttributesFieldBuilder();
                this.internalGetEventsFieldBuilder();
                this.internalGetLinksFieldBuilder();
                this.internalGetStatusFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.traceId_ = ByteString.EMPTY;
            this.spanId_ = ByteString.EMPTY;
            this.traceState_ = "";
            this.parentSpanId_ = ByteString.EMPTY;
            this.flags_ = 0;
            this.name_ = "";
            this.kind_ = 0;
            this.startTimeUnixNano_ = 0L;
            this.endTimeUnixNano_ = 0L;
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
            } else {
                this.attributes_ = null;
                this.attributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFDFF;
            this.droppedAttributesCount_ = 0;
            if (this.eventsBuilder_ == null) {
                this.events_ = Collections.emptyList();
            } else {
                this.events_ = null;
                this.eventsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFF7FF;
            this.droppedEventsCount_ = 0;
            if (this.linksBuilder_ == null) {
                this.links_ = Collections.emptyList();
            } else {
                this.links_ = null;
                this.linksBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFDFFF;
            this.droppedLinksCount_ = 0;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_descriptor;
        }

        public Span getDefaultInstanceForType() {
            return Span.getDefaultInstance();
        }

        public Span build() {
            Span result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Span buildPartial() {
            Span result = new Span(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Span result) {
            if (this.attributesBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                    this.bitField0_ &= 0xFFFFFDFF;
                }
                result.attributes_ = this.attributes_;
            } else {
                result.attributes_ = this.attributesBuilder_.build();
            }
            if (this.eventsBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0) {
                    this.events_ = Collections.unmodifiableList(this.events_);
                    this.bitField0_ &= 0xFFFFF7FF;
                }
                result.events_ = this.events_;
            } else {
                result.events_ = this.eventsBuilder_.build();
            }
            if (this.linksBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0) {
                    this.links_ = Collections.unmodifiableList(this.links_);
                    this.bitField0_ &= 0xFFFFDFFF;
                }
                result.links_ = this.links_;
            } else {
                result.links_ = this.linksBuilder_.build();
            }
        }

        private void buildPartial0(Span result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.traceId_ = this.traceId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.spanId_ = this.spanId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.traceState_ = this.traceState_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.parentSpanId_ = this.parentSpanId_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.flags_ = this.flags_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.kind_ = this.kind_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.startTimeUnixNano_ = this.startTimeUnixNano_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.endTimeUnixNano_ = this.endTimeUnixNano_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.droppedAttributesCount_ = this.droppedAttributesCount_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.droppedEventsCount_ = this.droppedEventsCount_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.droppedLinksCount_ = this.droppedLinksCount_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 0x8000) != 0) {
                result.status_ = this.statusBuilder_ == null ? this.status_ : (Status)this.statusBuilder_.build();
                to_bitField0_ |= 1;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Span) {
                return this.mergeFrom((Span)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Span other) {
            if (other == Span.getDefaultInstance()) {
                return this;
            }
            if (!other.getTraceId().isEmpty()) {
                this.setTraceId(other.getTraceId());
            }
            if (!other.getSpanId().isEmpty()) {
                this.setSpanId(other.getSpanId());
            }
            if (!other.getTraceState().isEmpty()) {
                this.traceState_ = other.traceState_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (!other.getParentSpanId().isEmpty()) {
                this.setParentSpanId(other.getParentSpanId());
            }
            if (other.getFlags() != 0) {
                this.setFlags(other.getFlags());
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (other.kind_ != 0) {
                this.setKindValue(other.getKindValue());
            }
            if (other.getStartTimeUnixNano() != 0L) {
                this.setStartTimeUnixNano(other.getStartTimeUnixNano());
            }
            if (other.getEndTimeUnixNano() != 0L) {
                this.setEndTimeUnixNano(other.getEndTimeUnixNano());
            }
            if (this.attributesBuilder_ == null) {
                if (!other.attributes_.isEmpty()) {
                    if (this.attributes_.isEmpty()) {
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFDFF;
                    } else {
                        this.ensureAttributesIsMutable();
                        this.attributes_.addAll(other.attributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributes_.isEmpty()) {
                if (this.attributesBuilder_.isEmpty()) {
                    this.attributesBuilder_.dispose();
                    this.attributesBuilder_ = null;
                    this.attributes_ = other.attributes_;
                    this.bitField0_ &= 0xFFFFFDFF;
                    this.attributesBuilder_ = alwaysUseFieldBuilders ? this.internalGetAttributesFieldBuilder() : null;
                } else {
                    this.attributesBuilder_.addAllMessages(other.attributes_);
                }
            }
            if (other.getDroppedAttributesCount() != 0) {
                this.setDroppedAttributesCount(other.getDroppedAttributesCount());
            }
            if (this.eventsBuilder_ == null) {
                if (!other.events_.isEmpty()) {
                    if (this.events_.isEmpty()) {
                        this.events_ = other.events_;
                        this.bitField0_ &= 0xFFFFF7FF;
                    } else {
                        this.ensureEventsIsMutable();
                        this.events_.addAll(other.events_);
                    }
                    this.onChanged();
                }
            } else if (!other.events_.isEmpty()) {
                if (this.eventsBuilder_.isEmpty()) {
                    this.eventsBuilder_.dispose();
                    this.eventsBuilder_ = null;
                    this.events_ = other.events_;
                    this.bitField0_ &= 0xFFFFF7FF;
                    this.eventsBuilder_ = alwaysUseFieldBuilders ? this.internalGetEventsFieldBuilder() : null;
                } else {
                    this.eventsBuilder_.addAllMessages(other.events_);
                }
            }
            if (other.getDroppedEventsCount() != 0) {
                this.setDroppedEventsCount(other.getDroppedEventsCount());
            }
            if (this.linksBuilder_ == null) {
                if (!other.links_.isEmpty()) {
                    if (this.links_.isEmpty()) {
                        this.links_ = other.links_;
                        this.bitField0_ &= 0xFFFFDFFF;
                    } else {
                        this.ensureLinksIsMutable();
                        this.links_.addAll(other.links_);
                    }
                    this.onChanged();
                }
            } else if (!other.links_.isEmpty()) {
                if (this.linksBuilder_.isEmpty()) {
                    this.linksBuilder_.dispose();
                    this.linksBuilder_ = null;
                    this.links_ = other.links_;
                    this.bitField0_ &= 0xFFFFDFFF;
                    this.linksBuilder_ = alwaysUseFieldBuilders ? this.internalGetLinksFieldBuilder() : null;
                } else {
                    this.linksBuilder_.addAllMessages(other.links_);
                }
            }
            if (other.getDroppedLinksCount() != 0) {
                this.setDroppedLinksCount(other.getDroppedLinksCount());
            }
            if (other.hasStatus()) {
                this.mergeStatus(other.getStatus());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block24: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block24;
                        }
                        case 10: {
                            this.traceId_ = input.readBytes();
                            this.bitField0_ |= 1;
                            continue block24;
                        }
                        case 18: {
                            this.spanId_ = input.readBytes();
                            this.bitField0_ |= 2;
                            continue block24;
                        }
                        case 26: {
                            this.traceState_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block24;
                        }
                        case 34: {
                            this.parentSpanId_ = input.readBytes();
                            this.bitField0_ |= 8;
                            continue block24;
                        }
                        case 42: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block24;
                        }
                        case 48: {
                            this.kind_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block24;
                        }
                        case 57: {
                            this.startTimeUnixNano_ = input.readFixed64();
                            this.bitField0_ |= 0x80;
                            continue block24;
                        }
                        case 65: {
                            this.endTimeUnixNano_ = input.readFixed64();
                            this.bitField0_ |= 0x100;
                            continue block24;
                        }
                        case 74: {
                            GeneratedMessage m = (KeyValue)input.readMessage(KeyValue.parser(), extensionRegistry);
                            if (this.attributesBuilder_ == null) {
                                this.ensureAttributesIsMutable();
                                this.attributes_.add((KeyValue)m);
                                continue block24;
                            }
                            this.attributesBuilder_.addMessage(m);
                            continue block24;
                        }
                        case 80: {
                            this.droppedAttributesCount_ = input.readUInt32();
                            this.bitField0_ |= 0x400;
                            continue block24;
                        }
                        case 90: {
                            GeneratedMessage m = (Event)input.readMessage(Event.parser(), extensionRegistry);
                            if (this.eventsBuilder_ == null) {
                                this.ensureEventsIsMutable();
                                this.events_.add((Event)m);
                                continue block24;
                            }
                            this.eventsBuilder_.addMessage(m);
                            continue block24;
                        }
                        case 96: {
                            this.droppedEventsCount_ = input.readUInt32();
                            this.bitField0_ |= 0x1000;
                            continue block24;
                        }
                        case 106: {
                            GeneratedMessage m = (Link)input.readMessage(Link.parser(), extensionRegistry);
                            if (this.linksBuilder_ == null) {
                                this.ensureLinksIsMutable();
                                this.links_.add((Link)m);
                                continue block24;
                            }
                            this.linksBuilder_.addMessage(m);
                            continue block24;
                        }
                        case 112: {
                            this.droppedLinksCount_ = input.readUInt32();
                            this.bitField0_ |= 0x4000;
                            continue block24;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.internalGetStatusFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x8000;
                            continue block24;
                        }
                        case 133: {
                            this.flags_ = input.readFixed32();
                            this.bitField0_ |= 0x10;
                            continue block24;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public ByteString getTraceId() {
            return this.traceId_;
        }

        public Builder setTraceId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.traceId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearTraceId() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.traceId_ = Span.getDefaultInstance().getTraceId();
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getSpanId() {
            return this.spanId_;
        }

        public Builder setSpanId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.spanId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearSpanId() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.spanId_ = Span.getDefaultInstance().getSpanId();
            this.onChanged();
            return this;
        }

        @Override
        public String getTraceState() {
            Object ref = this.traceState_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.traceState_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTraceStateBytes() {
            Object ref = this.traceState_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.traceState_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTraceState(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.traceState_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearTraceState() {
            this.traceState_ = Span.getDefaultInstance().getTraceState();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setTraceStateBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Span.checkByteStringIsUtf8((ByteString)value);
            this.traceState_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getParentSpanId() {
            return this.parentSpanId_;
        }

        public Builder setParentSpanId(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.parentSpanId_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearParentSpanId() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.parentSpanId_ = Span.getDefaultInstance().getParentSpanId();
            this.onChanged();
            return this;
        }

        @Override
        public int getFlags() {
            return this.flags_;
        }

        public Builder setFlags(int value) {
            this.flags_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearFlags() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.flags_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Span.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Span.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public int getKindValue() {
            return this.kind_;
        }

        public Builder setKindValue(int value) {
            this.kind_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public SpanKind getKind() {
            SpanKind result = SpanKind.forNumber(this.kind_);
            return result == null ? SpanKind.UNRECOGNIZED : result;
        }

        public Builder setKind(SpanKind value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.kind_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearKind() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.kind_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getStartTimeUnixNano() {
            return this.startTimeUnixNano_;
        }

        public Builder setStartTimeUnixNano(long value) {
            this.startTimeUnixNano_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearStartTimeUnixNano() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.startTimeUnixNano_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getEndTimeUnixNano() {
            return this.endTimeUnixNano_;
        }

        public Builder setEndTimeUnixNano(long value) {
            this.endTimeUnixNano_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearEndTimeUnixNano() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.endTimeUnixNano_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureAttributesIsMutable() {
            if ((this.bitField0_ & 0x200) == 0) {
                this.attributes_ = new ArrayList<KeyValue>(this.attributes_);
                this.bitField0_ |= 0x200;
            }
        }

        @Override
        public List<KeyValue> getAttributesList() {
            if (this.attributesBuilder_ == null) {
                return Collections.unmodifiableList(this.attributes_);
            }
            return this.attributesBuilder_.getMessageList();
        }

        @Override
        public int getAttributesCount() {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.size();
            }
            return this.attributesBuilder_.getCount();
        }

        @Override
        public KeyValue getAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (KeyValue)this.attributesBuilder_.getMessage(index);
        }

        public Builder setAttributes(int index, KeyValue value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setAttributes(int index, KeyValue.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(KeyValue value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addAttributes(int index, KeyValue value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addAttributes(KeyValue.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(int index, KeyValue.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributes(Iterable<? extends KeyValue> values) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributes_);
                this.onChanged();
            } else {
                this.attributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributes() {
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFDFF;
                this.onChanged();
            } else {
                this.attributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.remove(index);
                this.onChanged();
            } else {
                this.attributesBuilder_.remove(index);
            }
            return this;
        }

        public KeyValue.Builder getAttributesBuilder(int index) {
            return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public KeyValueOrBuilder getAttributesOrBuilder(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (KeyValueOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
            if (this.attributesBuilder_ != null) {
                return this.attributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributes_);
        }

        public KeyValue.Builder addAttributesBuilder() {
            return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().addBuilder((GeneratedMessage)KeyValue.getDefaultInstance());
        }

        public KeyValue.Builder addAttributesBuilder(int index) {
            return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().addBuilder(index, (GeneratedMessage)KeyValue.getDefaultInstance());
        }

        public List<KeyValue.Builder> getAttributesBuilderList() {
            return this.internalGetAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<KeyValue, KeyValue.Builder, KeyValueOrBuilder> internalGetAttributesFieldBuilder() {
            if (this.attributesBuilder_ == null) {
                this.attributesBuilder_ = new RepeatedFieldBuilder(this.attributes_, (this.bitField0_ & 0x200) != 0, this.getParentForChildren(), this.isClean());
                this.attributes_ = null;
            }
            return this.attributesBuilder_;
        }

        @Override
        public int getDroppedAttributesCount() {
            return this.droppedAttributesCount_;
        }

        public Builder setDroppedAttributesCount(int value) {
            this.droppedAttributesCount_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearDroppedAttributesCount() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.droppedAttributesCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureEventsIsMutable() {
            if ((this.bitField0_ & 0x800) == 0) {
                this.events_ = new ArrayList<Event>(this.events_);
                this.bitField0_ |= 0x800;
            }
        }

        @Override
        public List<Event> getEventsList() {
            if (this.eventsBuilder_ == null) {
                return Collections.unmodifiableList(this.events_);
            }
            return this.eventsBuilder_.getMessageList();
        }

        @Override
        public int getEventsCount() {
            if (this.eventsBuilder_ == null) {
                return this.events_.size();
            }
            return this.eventsBuilder_.getCount();
        }

        @Override
        public Event getEvents(int index) {
            if (this.eventsBuilder_ == null) {
                return this.events_.get(index);
            }
            return (Event)this.eventsBuilder_.getMessage(index);
        }

        public Builder setEvents(int index, Event value) {
            if (this.eventsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEventsIsMutable();
                this.events_.set(index, value);
                this.onChanged();
            } else {
                this.eventsBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setEvents(int index, Event.Builder builderForValue) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.eventsBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEvents(Event value) {
            if (this.eventsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEventsIsMutable();
                this.events_.add(value);
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addEvents(int index, Event value) {
            if (this.eventsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEventsIsMutable();
                this.events_.add(index, value);
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addEvents(Event.Builder builderForValue) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEvents(int index, Event.Builder builderForValue) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.eventsBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllEvents(Iterable<? extends Event> values) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.events_);
                this.onChanged();
            } else {
                this.eventsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearEvents() {
            if (this.eventsBuilder_ == null) {
                this.events_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFF7FF;
                this.onChanged();
            } else {
                this.eventsBuilder_.clear();
            }
            return this;
        }

        public Builder removeEvents(int index) {
            if (this.eventsBuilder_ == null) {
                this.ensureEventsIsMutable();
                this.events_.remove(index);
                this.onChanged();
            } else {
                this.eventsBuilder_.remove(index);
            }
            return this;
        }

        public Event.Builder getEventsBuilder(int index) {
            return (Event.Builder)this.internalGetEventsFieldBuilder().getBuilder(index);
        }

        @Override
        public EventOrBuilder getEventsOrBuilder(int index) {
            if (this.eventsBuilder_ == null) {
                return this.events_.get(index);
            }
            return (EventOrBuilder)this.eventsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends EventOrBuilder> getEventsOrBuilderList() {
            if (this.eventsBuilder_ != null) {
                return this.eventsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.events_);
        }

        public Event.Builder addEventsBuilder() {
            return (Event.Builder)this.internalGetEventsFieldBuilder().addBuilder((GeneratedMessage)Event.getDefaultInstance());
        }

        public Event.Builder addEventsBuilder(int index) {
            return (Event.Builder)this.internalGetEventsFieldBuilder().addBuilder(index, (GeneratedMessage)Event.getDefaultInstance());
        }

        public List<Event.Builder> getEventsBuilderList() {
            return this.internalGetEventsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<Event, Event.Builder, EventOrBuilder> internalGetEventsFieldBuilder() {
            if (this.eventsBuilder_ == null) {
                this.eventsBuilder_ = new RepeatedFieldBuilder(this.events_, (this.bitField0_ & 0x800) != 0, this.getParentForChildren(), this.isClean());
                this.events_ = null;
            }
            return this.eventsBuilder_;
        }

        @Override
        public int getDroppedEventsCount() {
            return this.droppedEventsCount_;
        }

        public Builder setDroppedEventsCount(int value) {
            this.droppedEventsCount_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearDroppedEventsCount() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.droppedEventsCount_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureLinksIsMutable() {
            if ((this.bitField0_ & 0x2000) == 0) {
                this.links_ = new ArrayList<Link>(this.links_);
                this.bitField0_ |= 0x2000;
            }
        }

        @Override
        public List<Link> getLinksList() {
            if (this.linksBuilder_ == null) {
                return Collections.unmodifiableList(this.links_);
            }
            return this.linksBuilder_.getMessageList();
        }

        @Override
        public int getLinksCount() {
            if (this.linksBuilder_ == null) {
                return this.links_.size();
            }
            return this.linksBuilder_.getCount();
        }

        @Override
        public Link getLinks(int index) {
            if (this.linksBuilder_ == null) {
                return this.links_.get(index);
            }
            return (Link)this.linksBuilder_.getMessage(index);
        }

        public Builder setLinks(int index, Link value) {
            if (this.linksBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLinksIsMutable();
                this.links_.set(index, value);
                this.onChanged();
            } else {
                this.linksBuilder_.setMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder setLinks(int index, Link.Builder builderForValue) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.linksBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addLinks(Link value) {
            if (this.linksBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLinksIsMutable();
                this.links_.add(value);
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage((GeneratedMessage)value);
            }
            return this;
        }

        public Builder addLinks(int index, Link value) {
            if (this.linksBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLinksIsMutable();
                this.links_.add(index, value);
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage(index, (GeneratedMessage)value);
            }
            return this;
        }

        public Builder addLinks(Link.Builder builderForValue) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage((GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addLinks(int index, Link.Builder builderForValue) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.linksBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllLinks(Iterable<? extends Link> values) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.links_);
                this.onChanged();
            } else {
                this.linksBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearLinks() {
            if (this.linksBuilder_ == null) {
                this.links_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFDFFF;
                this.onChanged();
            } else {
                this.linksBuilder_.clear();
            }
            return this;
        }

        public Builder removeLinks(int index) {
            if (this.linksBuilder_ == null) {
                this.ensureLinksIsMutable();
                this.links_.remove(index);
                this.onChanged();
            } else {
                this.linksBuilder_.remove(index);
            }
            return this;
        }

        public Link.Builder getLinksBuilder(int index) {
            return (Link.Builder)this.internalGetLinksFieldBuilder().getBuilder(index);
        }

        @Override
        public LinkOrBuilder getLinksOrBuilder(int index) {
            if (this.linksBuilder_ == null) {
                return this.links_.get(index);
            }
            return (LinkOrBuilder)this.linksBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends LinkOrBuilder> getLinksOrBuilderList() {
            if (this.linksBuilder_ != null) {
                return this.linksBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.links_);
        }

        public Link.Builder addLinksBuilder() {
            return (Link.Builder)this.internalGetLinksFieldBuilder().addBuilder((GeneratedMessage)Link.getDefaultInstance());
        }

        public Link.Builder addLinksBuilder(int index) {
            return (Link.Builder)this.internalGetLinksFieldBuilder().addBuilder(index, (GeneratedMessage)Link.getDefaultInstance());
        }

        public List<Link.Builder> getLinksBuilderList() {
            return this.internalGetLinksFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilder<Link, Link.Builder, LinkOrBuilder> internalGetLinksFieldBuilder() {
            if (this.linksBuilder_ == null) {
                this.linksBuilder_ = new RepeatedFieldBuilder(this.links_, (this.bitField0_ & 0x2000) != 0, this.getParentForChildren(), this.isClean());
                this.links_ = null;
            }
            return this.linksBuilder_;
        }

        @Override
        public int getDroppedLinksCount() {
            return this.droppedLinksCount_;
        }

        public Builder setDroppedLinksCount(int value) {
            this.droppedLinksCount_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearDroppedLinksCount() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.droppedLinksCount_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStatus() {
            return (this.bitField0_ & 0x8000) != 0;
        }

        @Override
        public Status getStatus() {
            if (this.statusBuilder_ == null) {
                return this.status_ == null ? Status.getDefaultInstance() : this.status_;
            }
            return (Status)this.statusBuilder_.getMessage();
        }

        public Builder setStatus(Status value) {
            if (this.statusBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.status_ = value;
            } else {
                this.statusBuilder_.setMessage((GeneratedMessage)value);
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder setStatus(Status.Builder builderForValue) {
            if (this.statusBuilder_ == null) {
                this.status_ = builderForValue.build();
            } else {
                this.statusBuilder_.setMessage((GeneratedMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder mergeStatus(Status value) {
            if (this.statusBuilder_ == null) {
                if ((this.bitField0_ & 0x8000) != 0 && this.status_ != null && this.status_ != Status.getDefaultInstance()) {
                    this.getStatusBuilder().mergeFrom(value);
                } else {
                    this.status_ = value;
                }
            } else {
                this.statusBuilder_.mergeFrom((GeneratedMessage)value);
            }
            if (this.status_ != null) {
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.status_ = null;
            if (this.statusBuilder_ != null) {
                this.statusBuilder_.dispose();
                this.statusBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Status.Builder getStatusBuilder() {
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return (Status.Builder)this.internalGetStatusFieldBuilder().getBuilder();
        }

        @Override
        public StatusOrBuilder getStatusOrBuilder() {
            if (this.statusBuilder_ != null) {
                return (StatusOrBuilder)this.statusBuilder_.getMessageOrBuilder();
            }
            return this.status_ == null ? Status.getDefaultInstance() : this.status_;
        }

        private SingleFieldBuilder<Status, Status.Builder, StatusOrBuilder> internalGetStatusFieldBuilder() {
            if (this.statusBuilder_ == null) {
                this.statusBuilder_ = new SingleFieldBuilder((GeneratedMessage)this.getStatus(), this.getParentForChildren(), this.isClean());
                this.status_ = null;
            }
            return this.statusBuilder_;
        }
    }

    public static enum SpanKind implements ProtocolMessageEnum
    {
        SPAN_KIND_UNSPECIFIED(0),
        SPAN_KIND_INTERNAL(1),
        SPAN_KIND_SERVER(2),
        SPAN_KIND_CLIENT(3),
        SPAN_KIND_PRODUCER(4),
        SPAN_KIND_CONSUMER(5),
        UNRECOGNIZED(-1);

        public static final int SPAN_KIND_UNSPECIFIED_VALUE = 0;
        public static final int SPAN_KIND_INTERNAL_VALUE = 1;
        public static final int SPAN_KIND_SERVER_VALUE = 2;
        public static final int SPAN_KIND_CLIENT_VALUE = 3;
        public static final int SPAN_KIND_PRODUCER_VALUE = 4;
        public static final int SPAN_KIND_CONSUMER_VALUE = 5;
        private static final Internal.EnumLiteMap<SpanKind> internalValueMap;
        private static final SpanKind[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static SpanKind valueOf(int value) {
            return SpanKind.forNumber(value);
        }

        public static SpanKind forNumber(int value) {
            switch (value) {
                case 0: {
                    return SPAN_KIND_UNSPECIFIED;
                }
                case 1: {
                    return SPAN_KIND_INTERNAL;
                }
                case 2: {
                    return SPAN_KIND_SERVER;
                }
                case 3: {
                    return SPAN_KIND_CLIENT;
                }
                case 4: {
                    return SPAN_KIND_PRODUCER;
                }
                case 5: {
                    return SPAN_KIND_CONSUMER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<SpanKind> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)SpanKind.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return SpanKind.getDescriptor();
        }

        public static Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Span.getDescriptor().getEnumTypes().get(0);
        }

        public static SpanKind valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != SpanKind.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private SpanKind(int value) {
            this.value = value;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)32, (int)0, (String)"", (String)SpanKind.class.getName());
            internalValueMap = new Internal.EnumLiteMap<SpanKind>(){

                public SpanKind findValueByNumber(int number) {
                    return SpanKind.forNumber(number);
                }
            };
            VALUES = SpanKind.values();
        }
    }

    public static final class Event
    extends GeneratedMessage
    implements EventOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TIME_UNIX_NANO_FIELD_NUMBER = 1;
        private long timeUnixNano_ = 0L;
        public static final int NAME_FIELD_NUMBER = 2;
        private volatile Object name_ = "";
        public static final int ATTRIBUTES_FIELD_NUMBER = 3;
        private List<KeyValue> attributes_;
        public static final int DROPPED_ATTRIBUTES_COUNT_FIELD_NUMBER = 4;
        private int droppedAttributesCount_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Event DEFAULT_INSTANCE;
        private static final Parser<Event> PARSER;

        private Event(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private Event() {
            this.name_ = "";
            this.attributes_ = Collections.emptyList();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_fieldAccessorTable.ensureFieldAccessorsInitialized(Event.class, Builder.class);
        }

        @Override
        public long getTimeUnixNano() {
            return this.timeUnixNano_;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.name_ = s;
            return s;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<KeyValue> getAttributesList() {
            return this.attributes_;
        }

        @Override
        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
            return this.attributes_;
        }

        @Override
        public int getAttributesCount() {
            return this.attributes_.size();
        }

        @Override
        public KeyValue getAttributes(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public KeyValueOrBuilder getAttributesOrBuilder(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public int getDroppedAttributesCount() {
            return this.droppedAttributesCount_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (this.timeUnixNano_ != 0L) {
                output.writeFixed64(1, this.timeUnixNano_);
            }
            if (!GeneratedMessage.isStringEmpty((Object)this.name_)) {
                GeneratedMessage.writeString((CodedOutputStream)output, (int)2, (Object)this.name_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                output.writeMessage(3, (MessageLite)this.attributes_.get(i));
            }
            if (this.droppedAttributesCount_ != 0) {
                output.writeUInt32(4, this.droppedAttributesCount_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.timeUnixNano_ != 0L) {
                size += CodedOutputStream.computeFixed64Size((int)1, (long)this.timeUnixNano_);
            }
            if (!GeneratedMessage.isStringEmpty((Object)this.name_)) {
                size += GeneratedMessage.computeStringSize((int)2, (Object)this.name_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.attributes_.get(i)));
            }
            if (this.droppedAttributesCount_ != 0) {
                size += CodedOutputStream.computeUInt32Size((int)4, (int)this.droppedAttributesCount_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Event)) {
                return super.equals(obj);
            }
            Event other = (Event)obj;
            if (this.getTimeUnixNano() != other.getTimeUnixNano()) {
                return false;
            }
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (!this.getAttributesList().equals(other.getAttributesList())) {
                return false;
            }
            if (this.getDroppedAttributesCount() != other.getDroppedAttributesCount()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Event.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + Internal.hashLong((long)this.getTimeUnixNano());
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getName().hashCode();
            if (this.getAttributesCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getAttributesList().hashCode();
            }
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getDroppedAttributesCount();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Event parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Event)PARSER.parseFrom(data);
        }

        public static Event parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Event)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Event parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Event)PARSER.parseFrom(data);
        }

        public static Event parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Event)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Event parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Event)PARSER.parseFrom(data);
        }

        public static Event parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Event)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Event parseFrom(InputStream input) throws IOException {
            return (Event)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Event parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Event)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Event parseDelimitedFrom(InputStream input) throws IOException {
            return (Event)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Event parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Event)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Event parseFrom(CodedInputStream input) throws IOException {
            return (Event)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Event parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Event)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Event.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Event prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Event getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Event> parser() {
            return PARSER;
        }

        public Parser<Event> getParserForType() {
            return PARSER;
        }

        public Event getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)32, (int)0, (String)"", (String)Event.class.getName());
            DEFAULT_INSTANCE = new Event();
            PARSER = new AbstractParser<Event>(){

                public Event parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = Event.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements EventOrBuilder {
            private int bitField0_;
            private long timeUnixNano_;
            private Object name_ = "";
            private List<KeyValue> attributes_ = Collections.emptyList();
            private RepeatedFieldBuilder<KeyValue, KeyValue.Builder, KeyValueOrBuilder> attributesBuilder_;
            private int droppedAttributesCount_;

            public static final Descriptors.Descriptor getDescriptor() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_descriptor;
            }

            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_fieldAccessorTable.ensureFieldAccessorsInitialized(Event.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(AbstractMessage.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.timeUnixNano_ = 0L;
                this.name_ = "";
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                } else {
                    this.attributes_ = null;
                    this.attributesBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFFB;
                this.droppedAttributesCount_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Event_descriptor;
            }

            public Event getDefaultInstanceForType() {
                return Event.getDefaultInstance();
            }

            public Event build() {
                Event result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Event buildPartial() {
                Event result = new Event(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(Event result) {
                if (this.attributesBuilder_ == null) {
                    if ((this.bitField0_ & 4) != 0) {
                        this.attributes_ = Collections.unmodifiableList(this.attributes_);
                        this.bitField0_ &= 0xFFFFFFFB;
                    }
                    result.attributes_ = this.attributes_;
                } else {
                    result.attributes_ = this.attributesBuilder_.build();
                }
            }

            private void buildPartial0(Event result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.timeUnixNano_ = this.timeUnixNano_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.name_ = this.name_;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.droppedAttributesCount_ = this.droppedAttributesCount_;
                }
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Event) {
                    return this.mergeFrom((Event)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Event other) {
                if (other == Event.getDefaultInstance()) {
                    return this;
                }
                if (other.getTimeUnixNano() != 0L) {
                    this.setTimeUnixNano(other.getTimeUnixNano());
                }
                if (!other.getName().isEmpty()) {
                    this.name_ = other.name_;
                    this.bitField0_ |= 2;
                    this.onChanged();
                }
                if (this.attributesBuilder_ == null) {
                    if (!other.attributes_.isEmpty()) {
                        if (this.attributes_.isEmpty()) {
                            this.attributes_ = other.attributes_;
                            this.bitField0_ &= 0xFFFFFFFB;
                        } else {
                            this.ensureAttributesIsMutable();
                            this.attributes_.addAll(other.attributes_);
                        }
                        this.onChanged();
                    }
                } else if (!other.attributes_.isEmpty()) {
                    if (this.attributesBuilder_.isEmpty()) {
                        this.attributesBuilder_.dispose();
                        this.attributesBuilder_ = null;
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFFB;
                        this.attributesBuilder_ = alwaysUseFieldBuilders ? this.internalGetAttributesFieldBuilder() : null;
                    } else {
                        this.attributesBuilder_.addAllMessages(other.attributes_);
                    }
                }
                if (other.getDroppedAttributesCount() != 0) {
                    this.setDroppedAttributesCount(other.getDroppedAttributesCount());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block12: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block12;
                            }
                            case 9: {
                                this.timeUnixNano_ = input.readFixed64();
                                this.bitField0_ |= 1;
                                continue block12;
                            }
                            case 18: {
                                this.name_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block12;
                            }
                            case 26: {
                                KeyValue m = (KeyValue)input.readMessage(KeyValue.parser(), extensionRegistry);
                                if (this.attributesBuilder_ == null) {
                                    this.ensureAttributesIsMutable();
                                    this.attributes_.add(m);
                                    continue block12;
                                }
                                this.attributesBuilder_.addMessage((GeneratedMessage)m);
                                continue block12;
                            }
                            case 32: {
                                this.droppedAttributesCount_ = input.readUInt32();
                                this.bitField0_ |= 8;
                                continue block12;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public long getTimeUnixNano() {
                return this.timeUnixNano_;
            }

            public Builder setTimeUnixNano(long value) {
                this.timeUnixNano_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearTimeUnixNano() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.timeUnixNano_ = 0L;
                this.onChanged();
                return this;
            }

            @Override
            public String getName() {
                Object ref = this.name_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.name_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNameBytes() {
                Object ref = this.name_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.name_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.name_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearName() {
                this.name_ = Event.getDefaultInstance().getName();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
                return this;
            }

            public Builder setNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Event.checkByteStringIsUtf8((ByteString)value);
                this.name_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            private void ensureAttributesIsMutable() {
                if ((this.bitField0_ & 4) == 0) {
                    this.attributes_ = new ArrayList<KeyValue>(this.attributes_);
                    this.bitField0_ |= 4;
                }
            }

            @Override
            public List<KeyValue> getAttributesList() {
                if (this.attributesBuilder_ == null) {
                    return Collections.unmodifiableList(this.attributes_);
                }
                return this.attributesBuilder_.getMessageList();
            }

            @Override
            public int getAttributesCount() {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.size();
                }
                return this.attributesBuilder_.getCount();
            }

            @Override
            public KeyValue getAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return (KeyValue)this.attributesBuilder_.getMessage(index);
            }

            public Builder setAttributes(int index, KeyValue value) {
                if (this.attributesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, value);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, (GeneratedMessage)value);
                }
                return this;
            }

            public Builder setAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(KeyValue value) {
                if (this.attributesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(value);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage((GeneratedMessage)value);
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue value) {
                if (this.attributesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, value);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, (GeneratedMessage)value);
                }
                return this;
            }

            public Builder addAttributes(KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllAttributes(Iterable<? extends KeyValue> values) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.attributes_);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearAttributes() {
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.onChanged();
                } else {
                    this.attributesBuilder_.clear();
                }
                return this;
            }

            public Builder removeAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.remove(index);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.remove(index);
                }
                return this;
            }

            public KeyValue.Builder getAttributesBuilder(int index) {
                return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().getBuilder(index);
            }

            @Override
            public KeyValueOrBuilder getAttributesOrBuilder(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return (KeyValueOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
                if (this.attributesBuilder_ != null) {
                    return this.attributesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.attributes_);
            }

            public KeyValue.Builder addAttributesBuilder() {
                return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().addBuilder((GeneratedMessage)KeyValue.getDefaultInstance());
            }

            public KeyValue.Builder addAttributesBuilder(int index) {
                return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().addBuilder(index, (GeneratedMessage)KeyValue.getDefaultInstance());
            }

            public List<KeyValue.Builder> getAttributesBuilderList() {
                return this.internalGetAttributesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilder<KeyValue, KeyValue.Builder, KeyValueOrBuilder> internalGetAttributesFieldBuilder() {
                if (this.attributesBuilder_ == null) {
                    this.attributesBuilder_ = new RepeatedFieldBuilder(this.attributes_, (this.bitField0_ & 4) != 0, this.getParentForChildren(), this.isClean());
                    this.attributes_ = null;
                }
                return this.attributesBuilder_;
            }

            @Override
            public int getDroppedAttributesCount() {
                return this.droppedAttributesCount_;
            }

            public Builder setDroppedAttributesCount(int value) {
                this.droppedAttributesCount_ = value;
                this.bitField0_ |= 8;
                this.onChanged();
                return this;
            }

            public Builder clearDroppedAttributesCount() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.droppedAttributesCount_ = 0;
                this.onChanged();
                return this;
            }
        }
    }

    public static interface EventOrBuilder
    extends MessageOrBuilder {
        public long getTimeUnixNano();

        public String getName();

        public ByteString getNameBytes();

        public List<KeyValue> getAttributesList();

        public KeyValue getAttributes(int var1);

        public int getAttributesCount();

        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList();

        public KeyValueOrBuilder getAttributesOrBuilder(int var1);

        public int getDroppedAttributesCount();
    }

    public static final class Link
    extends GeneratedMessage
    implements LinkOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int TRACE_ID_FIELD_NUMBER = 1;
        private ByteString traceId_ = ByteString.EMPTY;
        public static final int SPAN_ID_FIELD_NUMBER = 2;
        private ByteString spanId_ = ByteString.EMPTY;
        public static final int TRACE_STATE_FIELD_NUMBER = 3;
        private volatile Object traceState_ = "";
        public static final int ATTRIBUTES_FIELD_NUMBER = 4;
        private List<KeyValue> attributes_;
        public static final int DROPPED_ATTRIBUTES_COUNT_FIELD_NUMBER = 5;
        private int droppedAttributesCount_ = 0;
        public static final int FLAGS_FIELD_NUMBER = 6;
        private int flags_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final Link DEFAULT_INSTANCE;
        private static final Parser<Link> PARSER;

        private Link(GeneratedMessage.Builder<?> builder) {
            super(builder);
        }

        private Link() {
            this.traceId_ = ByteString.EMPTY;
            this.spanId_ = ByteString.EMPTY;
            this.traceState_ = "";
            this.attributes_ = Collections.emptyList();
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_fieldAccessorTable.ensureFieldAccessorsInitialized(Link.class, Builder.class);
        }

        @Override
        public ByteString getTraceId() {
            return this.traceId_;
        }

        @Override
        public ByteString getSpanId() {
            return this.spanId_;
        }

        @Override
        public String getTraceState() {
            Object ref = this.traceState_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.traceState_ = s;
            return s;
        }

        @Override
        public ByteString getTraceStateBytes() {
            Object ref = this.traceState_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.traceState_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public List<KeyValue> getAttributesList() {
            return this.attributes_;
        }

        @Override
        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
            return this.attributes_;
        }

        @Override
        public int getAttributesCount() {
            return this.attributes_.size();
        }

        @Override
        public KeyValue getAttributes(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public KeyValueOrBuilder getAttributesOrBuilder(int index) {
            return this.attributes_.get(index);
        }

        @Override
        public int getDroppedAttributesCount() {
            return this.droppedAttributesCount_;
        }

        @Override
        public int getFlags() {
            return this.flags_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!this.traceId_.isEmpty()) {
                output.writeBytes(1, this.traceId_);
            }
            if (!this.spanId_.isEmpty()) {
                output.writeBytes(2, this.spanId_);
            }
            if (!GeneratedMessage.isStringEmpty((Object)this.traceState_)) {
                GeneratedMessage.writeString((CodedOutputStream)output, (int)3, (Object)this.traceState_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                output.writeMessage(4, (MessageLite)this.attributes_.get(i));
            }
            if (this.droppedAttributesCount_ != 0) {
                output.writeUInt32(5, this.droppedAttributesCount_);
            }
            if (this.flags_ != 0) {
                output.writeFixed32(6, this.flags_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!this.traceId_.isEmpty()) {
                size += CodedOutputStream.computeBytesSize((int)1, (ByteString)this.traceId_);
            }
            if (!this.spanId_.isEmpty()) {
                size += CodedOutputStream.computeBytesSize((int)2, (ByteString)this.spanId_);
            }
            if (!GeneratedMessage.isStringEmpty((Object)this.traceState_)) {
                size += GeneratedMessage.computeStringSize((int)3, (Object)this.traceState_);
            }
            for (int i = 0; i < this.attributes_.size(); ++i) {
                size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.attributes_.get(i)));
            }
            if (this.droppedAttributesCount_ != 0) {
                size += CodedOutputStream.computeUInt32Size((int)5, (int)this.droppedAttributesCount_);
            }
            if (this.flags_ != 0) {
                size += CodedOutputStream.computeFixed32Size((int)6, (int)this.flags_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Link)) {
                return super.equals(obj);
            }
            Link other = (Link)obj;
            if (!this.getTraceId().equals((Object)other.getTraceId())) {
                return false;
            }
            if (!this.getSpanId().equals((Object)other.getSpanId())) {
                return false;
            }
            if (!this.getTraceState().equals(other.getTraceState())) {
                return false;
            }
            if (!this.getAttributesList().equals(other.getAttributesList())) {
                return false;
            }
            if (this.getDroppedAttributesCount() != other.getDroppedAttributesCount()) {
                return false;
            }
            if (this.getFlags() != other.getFlags()) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + Link.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getTraceId().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getSpanId().hashCode();
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getTraceState().hashCode();
            if (this.getAttributesCount() > 0) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getAttributesList().hashCode();
            }
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getDroppedAttributesCount();
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getFlags();
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static Link parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (Link)PARSER.parseFrom(data);
        }

        public static Link parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Link)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Link parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (Link)PARSER.parseFrom(data);
        }

        public static Link parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Link)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Link parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (Link)PARSER.parseFrom(data);
        }

        public static Link parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (Link)PARSER.parseFrom(data, extensionRegistry);
        }

        public static Link parseFrom(InputStream input) throws IOException {
            return (Link)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
        }

        public static Link parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Link)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Link parseDelimitedFrom(InputStream input) throws IOException {
            return (Link)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static Link parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Link)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static Link parseFrom(CodedInputStream input) throws IOException {
            return (Link)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static Link parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (Link)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return Link.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(Link prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static Link getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<Link> parser() {
            return PARSER;
        }

        public Parser<Link> getParserForType() {
            return PARSER;
        }

        public Link getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static {
            RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)32, (int)0, (String)"", (String)Link.class.getName());
            DEFAULT_INSTANCE = new Link();
            PARSER = new AbstractParser<Link>(){

                public Link parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = Link.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };
        }

        public static final class Builder
        extends GeneratedMessage.Builder<Builder>
        implements LinkOrBuilder {
            private int bitField0_;
            private ByteString traceId_ = ByteString.EMPTY;
            private ByteString spanId_ = ByteString.EMPTY;
            private Object traceState_ = "";
            private List<KeyValue> attributes_ = Collections.emptyList();
            private RepeatedFieldBuilder<KeyValue, KeyValue.Builder, KeyValueOrBuilder> attributesBuilder_;
            private int droppedAttributesCount_;
            private int flags_;

            public static final Descriptors.Descriptor getDescriptor() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_descriptor;
            }

            protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_fieldAccessorTable.ensureFieldAccessorsInitialized(Link.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(AbstractMessage.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.traceId_ = ByteString.EMPTY;
                this.spanId_ = ByteString.EMPTY;
                this.traceState_ = "";
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                } else {
                    this.attributes_ = null;
                    this.attributesBuilder_.clear();
                }
                this.bitField0_ &= 0xFFFFFFF7;
                this.droppedAttributesCount_ = 0;
                this.flags_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return TraceProto.internal_static_opentelemetry_proto_trace_v1_Span_Link_descriptor;
            }

            public Link getDefaultInstanceForType() {
                return Link.getDefaultInstance();
            }

            public Link build() {
                Link result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public Link buildPartial() {
                Link result = new Link(this);
                this.buildPartialRepeatedFields(result);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartialRepeatedFields(Link result) {
                if (this.attributesBuilder_ == null) {
                    if ((this.bitField0_ & 8) != 0) {
                        this.attributes_ = Collections.unmodifiableList(this.attributes_);
                        this.bitField0_ &= 0xFFFFFFF7;
                    }
                    result.attributes_ = this.attributes_;
                } else {
                    result.attributes_ = this.attributesBuilder_.build();
                }
            }

            private void buildPartial0(Link result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.traceId_ = this.traceId_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.spanId_ = this.spanId_;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.traceState_ = this.traceState_;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.droppedAttributesCount_ = this.droppedAttributesCount_;
                }
                if ((from_bitField0_ & 0x20) != 0) {
                    result.flags_ = this.flags_;
                }
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof Link) {
                    return this.mergeFrom((Link)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(Link other) {
                if (other == Link.getDefaultInstance()) {
                    return this;
                }
                if (!other.getTraceId().isEmpty()) {
                    this.setTraceId(other.getTraceId());
                }
                if (!other.getSpanId().isEmpty()) {
                    this.setSpanId(other.getSpanId());
                }
                if (!other.getTraceState().isEmpty()) {
                    this.traceState_ = other.traceState_;
                    this.bitField0_ |= 4;
                    this.onChanged();
                }
                if (this.attributesBuilder_ == null) {
                    if (!other.attributes_.isEmpty()) {
                        if (this.attributes_.isEmpty()) {
                            this.attributes_ = other.attributes_;
                            this.bitField0_ &= 0xFFFFFFF7;
                        } else {
                            this.ensureAttributesIsMutable();
                            this.attributes_.addAll(other.attributes_);
                        }
                        this.onChanged();
                    }
                } else if (!other.attributes_.isEmpty()) {
                    if (this.attributesBuilder_.isEmpty()) {
                        this.attributesBuilder_.dispose();
                        this.attributesBuilder_ = null;
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFF7;
                        this.attributesBuilder_ = alwaysUseFieldBuilders ? this.internalGetAttributesFieldBuilder() : null;
                    } else {
                        this.attributesBuilder_.addAllMessages(other.attributes_);
                    }
                }
                if (other.getDroppedAttributesCount() != 0) {
                    this.setDroppedAttributesCount(other.getDroppedAttributesCount());
                }
                if (other.getFlags() != 0) {
                    this.setFlags(other.getFlags());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block14: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block14;
                            }
                            case 10: {
                                this.traceId_ = input.readBytes();
                                this.bitField0_ |= 1;
                                continue block14;
                            }
                            case 18: {
                                this.spanId_ = input.readBytes();
                                this.bitField0_ |= 2;
                                continue block14;
                            }
                            case 26: {
                                this.traceState_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 4;
                                continue block14;
                            }
                            case 34: {
                                KeyValue m = (KeyValue)input.readMessage(KeyValue.parser(), extensionRegistry);
                                if (this.attributesBuilder_ == null) {
                                    this.ensureAttributesIsMutable();
                                    this.attributes_.add(m);
                                    continue block14;
                                }
                                this.attributesBuilder_.addMessage((GeneratedMessage)m);
                                continue block14;
                            }
                            case 40: {
                                this.droppedAttributesCount_ = input.readUInt32();
                                this.bitField0_ |= 0x10;
                                continue block14;
                            }
                            case 53: {
                                this.flags_ = input.readFixed32();
                                this.bitField0_ |= 0x20;
                                continue block14;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public ByteString getTraceId() {
                return this.traceId_;
            }

            public Builder setTraceId(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.traceId_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearTraceId() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.traceId_ = Link.getDefaultInstance().getTraceId();
                this.onChanged();
                return this;
            }

            @Override
            public ByteString getSpanId() {
                return this.spanId_;
            }

            public Builder setSpanId(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.spanId_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearSpanId() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.spanId_ = Link.getDefaultInstance().getSpanId();
                this.onChanged();
                return this;
            }

            @Override
            public String getTraceState() {
                Object ref = this.traceState_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.traceState_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getTraceStateBytes() {
                Object ref = this.traceState_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.traceState_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setTraceState(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.traceState_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearTraceState() {
                this.traceState_ = Link.getDefaultInstance().getTraceState();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder setTraceStateBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                Link.checkByteStringIsUtf8((ByteString)value);
                this.traceState_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            private void ensureAttributesIsMutable() {
                if ((this.bitField0_ & 8) == 0) {
                    this.attributes_ = new ArrayList<KeyValue>(this.attributes_);
                    this.bitField0_ |= 8;
                }
            }

            @Override
            public List<KeyValue> getAttributesList() {
                if (this.attributesBuilder_ == null) {
                    return Collections.unmodifiableList(this.attributes_);
                }
                return this.attributesBuilder_.getMessageList();
            }

            @Override
            public int getAttributesCount() {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.size();
                }
                return this.attributesBuilder_.getCount();
            }

            @Override
            public KeyValue getAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return (KeyValue)this.attributesBuilder_.getMessage(index);
            }

            public Builder setAttributes(int index, KeyValue value) {
                if (this.attributesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, value);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, (GeneratedMessage)value);
                }
                return this;
            }

            public Builder setAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.set(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.setMessage(index, (GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(KeyValue value) {
                if (this.attributesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(value);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage((GeneratedMessage)value);
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue value) {
                if (this.attributesBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, value);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, (GeneratedMessage)value);
                }
                return this;
            }

            public Builder addAttributes(KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage((GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAttributes(int index, KeyValue.Builder builderForValue) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.add(index, builderForValue.build());
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addMessage(index, (GeneratedMessage)builderForValue.build());
                }
                return this;
            }

            public Builder addAllAttributes(Iterable<? extends KeyValue> values) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    AbstractMessageLite.Builder.addAll(values, this.attributes_);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.addAllMessages(values);
                }
                return this;
            }

            public Builder clearAttributes() {
                if (this.attributesBuilder_ == null) {
                    this.attributes_ = Collections.emptyList();
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.onChanged();
                } else {
                    this.attributesBuilder_.clear();
                }
                return this;
            }

            public Builder removeAttributes(int index) {
                if (this.attributesBuilder_ == null) {
                    this.ensureAttributesIsMutable();
                    this.attributes_.remove(index);
                    this.onChanged();
                } else {
                    this.attributesBuilder_.remove(index);
                }
                return this;
            }

            public KeyValue.Builder getAttributesBuilder(int index) {
                return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().getBuilder(index);
            }

            @Override
            public KeyValueOrBuilder getAttributesOrBuilder(int index) {
                if (this.attributesBuilder_ == null) {
                    return this.attributes_.get(index);
                }
                return (KeyValueOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
            }

            @Override
            public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList() {
                if (this.attributesBuilder_ != null) {
                    return this.attributesBuilder_.getMessageOrBuilderList();
                }
                return Collections.unmodifiableList(this.attributes_);
            }

            public KeyValue.Builder addAttributesBuilder() {
                return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().addBuilder((GeneratedMessage)KeyValue.getDefaultInstance());
            }

            public KeyValue.Builder addAttributesBuilder(int index) {
                return (KeyValue.Builder)this.internalGetAttributesFieldBuilder().addBuilder(index, (GeneratedMessage)KeyValue.getDefaultInstance());
            }

            public List<KeyValue.Builder> getAttributesBuilderList() {
                return this.internalGetAttributesFieldBuilder().getBuilderList();
            }

            private RepeatedFieldBuilder<KeyValue, KeyValue.Builder, KeyValueOrBuilder> internalGetAttributesFieldBuilder() {
                if (this.attributesBuilder_ == null) {
                    this.attributesBuilder_ = new RepeatedFieldBuilder(this.attributes_, (this.bitField0_ & 8) != 0, this.getParentForChildren(), this.isClean());
                    this.attributes_ = null;
                }
                return this.attributesBuilder_;
            }

            @Override
            public int getDroppedAttributesCount() {
                return this.droppedAttributesCount_;
            }

            public Builder setDroppedAttributesCount(int value) {
                this.droppedAttributesCount_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearDroppedAttributesCount() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.droppedAttributesCount_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public int getFlags() {
                return this.flags_;
            }

            public Builder setFlags(int value) {
                this.flags_ = value;
                this.bitField0_ |= 0x20;
                this.onChanged();
                return this;
            }

            public Builder clearFlags() {
                this.bitField0_ &= 0xFFFFFFDF;
                this.flags_ = 0;
                this.onChanged();
                return this;
            }
        }
    }

    public static interface LinkOrBuilder
    extends MessageOrBuilder {
        public ByteString getTraceId();

        public ByteString getSpanId();

        public String getTraceState();

        public ByteString getTraceStateBytes();

        public List<KeyValue> getAttributesList();

        public KeyValue getAttributes(int var1);

        public int getAttributesCount();

        public List<? extends KeyValueOrBuilder> getAttributesOrBuilderList();

        public KeyValueOrBuilder getAttributesOrBuilder(int var1);

        public int getDroppedAttributesCount();

        public int getFlags();
    }
}

