/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.implementation.TimeAndFormat;
import com.azure.storage.common.sas.AccountSasPermission;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import java.time.OffsetDateTime;

public class AccountSasImplUtil {
    private static final ClientLogger LOGGER = new ClientLogger(AccountSasImplUtil.class);
    private static final String VERSION = Constants.SAS_SERVICE_VERSION;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String services;
    private String resourceTypes;
    private String encryptionScope;

    public AccountSasImplUtil(AccountSasSignatureValues sasValues, String encryptionScope) {
        this.protocol = sasValues.getProtocol();
        this.startTime = sasValues.getStartTime();
        this.expiryTime = sasValues.getExpiryTime();
        this.permissions = sasValues.getPermissions();
        this.sasIpRange = sasValues.getSasIpRange();
        this.services = sasValues.getServices();
        this.resourceTypes = sasValues.getResourceTypes();
        this.encryptionScope = encryptionScope;
    }

    public String generateSas(StorageSharedKeyCredential storageSharedKeyCredentials, Context context) {
        StorageImplUtils.assertNotNull("storageSharedKeyCredentials", storageSharedKeyCredentials);
        StorageImplUtils.assertNotNull("services", this.services);
        StorageImplUtils.assertNotNull("resourceTypes", this.resourceTypes);
        StorageImplUtils.assertNotNull("expiryTime", this.expiryTime);
        StorageImplUtils.assertNotNull("permissions", this.permissions);
        String stringToSign = this.stringToSign(storageSharedKeyCredentials);
        StorageImplUtils.logStringToSign(LOGGER, stringToSign, context);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return this.encode(signature);
    }

    private String stringToSign(StorageSharedKeyCredential storageSharedKeyCredentials) {
        if (VERSION.compareTo("2020-10-02") <= 0) {
            return String.join((CharSequence)"\n", storageSharedKeyCredentials.getAccountName(), AccountSasPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, "");
        }
        return String.join((CharSequence)"\n", storageSharedKeyCredentials.getAccountName(), AccountSasPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), VERSION, this.encryptionScope == null ? "" : this.encryptionScope, "");
    }

    private String encode(String signature) {
        StringBuilder sb = new StringBuilder();
        SasImplUtils.tryAppendQueryParameter(sb, "sv", VERSION);
        SasImplUtils.tryAppendQueryParameter(sb, "ss", this.services);
        SasImplUtils.tryAppendQueryParameter(sb, "srt", this.resourceTypes);
        SasImplUtils.tryAppendQueryParameter(sb, "spr", (Object)this.protocol);
        SasImplUtils.tryAppendQueryParameter(sb, "st", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(this.startTime, null)));
        SasImplUtils.tryAppendQueryParameter(sb, "se", SasImplUtils.formatQueryParameterDate(new TimeAndFormat(this.expiryTime, null)));
        SasImplUtils.tryAppendQueryParameter(sb, "sip", this.sasIpRange);
        SasImplUtils.tryAppendQueryParameter(sb, "sp", this.permissions);
        SasImplUtils.tryAppendQueryParameter(sb, "ses", this.encryptionScope);
        SasImplUtils.tryAppendQueryParameter(sb, "sig", signature);
        return sb.toString();
    }
}

