/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.queries.CommonTermsQuery;
import org.apache.lucene.queries.function.FunctionScoreQuery;
import org.apache.lucene.queries.spans.FieldMaskingSpanQuery;
import org.apache.lucene.queries.spans.SpanFirstQuery;
import org.apache.lucene.queries.spans.SpanNearQuery;
import org.apache.lucene.queries.spans.SpanNotQuery;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.queries.spans.SpanWeight;
import org.apache.lucene.queries.spans.Spans;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.OffsetLimitTokenFilter;
import org.apache.lucene.search.highlight.PositionSpan;
import org.apache.lucene.search.highlight.TermVectorLeafReader;
import org.apache.lucene.search.highlight.TokenStreamFromTermVector;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;

public class WeightedSpanTermExtractor {
    private String fieldName;
    private TokenStream tokenStream;
    private final String defaultField;
    private boolean expandMultiTermQuery;
    private boolean cachedTokenStream;
    private boolean wrapToCaching = true;
    private int maxDocCharsToAnalyze;
    private boolean usePayloads = false;
    private LeafReader internalReader = null;

    public WeightedSpanTermExtractor() {
        this(null);
    }

    public WeightedSpanTermExtractor(String defaultField) {
        this.defaultField = defaultField;
    }

    protected void extract(Query query, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
        if (query instanceof BoostQuery) {
            BoostQuery boostQuery = (BoostQuery)query;
            this.extract(boostQuery.getQuery(), boost * boostQuery.getBoost(), terms);
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : (BooleanQuery)query) {
                if (clause.isProhibited()) continue;
                this.extract(clause.query(), boost, terms);
            }
        } else if (query instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query;
            Term[] phraseQueryTerms = phraseQuery.getTerms();
            if (phraseQueryTerms.length == 1) {
                this.extractWeightedSpanTerms(terms, (SpanQuery)new SpanTermQuery(phraseQueryTerms[0]), boost);
            } else {
                SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
                for (int i = 0; i < phraseQueryTerms.length; ++i) {
                    clauses[i] = new SpanTermQuery(phraseQueryTerms[i]);
                }
                int positionGaps = 0;
                int[] positions = phraseQuery.getPositions();
                if (positions.length >= 2) {
                    positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
                }
                boolean inorder = phraseQuery.getSlop() == 0;
                SpanNearQuery sp = new SpanNearQuery(clauses, phraseQuery.getSlop() + positionGaps, inorder);
                this.extractWeightedSpanTerms(terms, (SpanQuery)sp, boost);
            }
        } else if (query instanceof IndexOrDocValuesQuery) {
            Query indexQuery = ((IndexOrDocValuesQuery)query).getIndexQuery();
            if (indexQuery != null) {
                this.extract(indexQuery, boost, terms);
            }
        } else if (query instanceof TermQuery || query instanceof SynonymQuery) {
            this.extractWeightedTerms(terms, query, boost);
        } else if (query instanceof SpanQuery) {
            this.extractWeightedSpanTerms(terms, (SpanQuery)query, boost);
        } else if (query instanceof ConstantScoreQuery) {
            Query q = ((ConstantScoreQuery)query).getQuery();
            if (q != null) {
                this.extract(q, boost, terms);
            }
        } else if (query instanceof CommonTermsQuery) {
            this.extractWeightedTerms(terms, query, boost);
        } else if (query instanceof DisjunctionMaxQuery) {
            for (Query clause : (DisjunctionMaxQuery)query) {
                this.extract(clause, boost, terms);
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            Term[][] termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                for (int i = 0; i < positions.length - 1; ++i) {
                    if (positions[i] <= maxPosition) continue;
                    maxPosition = positions[i];
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                for (int i = 0; i < termArrays.length; ++i) {
                    Term[] termArray = termArrays[i];
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    for (List list : termArray) {
                        disjuncts.add(new SpanTermQuery((Term)list));
                    }
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                for (List list : disjunctLists) {
                    if (list != null) {
                        clauses[position++] = new SpanOrQuery(list.toArray(new SpanQuery[list.size()]));
                        continue;
                    }
                    ++positionGaps;
                }
                if (clauses.length == 1) {
                    this.extractWeightedSpanTerms(terms, clauses[0], boost);
                } else {
                    int slop = mpq.getSlop();
                    boolean inorder = slop == 0;
                    SpanNearQuery sp = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                    this.extractWeightedSpanTerms(terms, (SpanQuery)sp, boost);
                }
            }
        } else if (!(query instanceof MatchAllDocsQuery) && !(query instanceof FieldExistsQuery)) {
            if (query instanceof FunctionScoreQuery) {
                this.extract(((FunctionScoreQuery)query).getWrappedQuery(), boost, terms);
            } else if (!this.isQueryUnsupported(query.getClass())) {
                if (!(!(query instanceof MultiTermQuery) || this.expandMultiTermQuery && this.fieldNameComparator(((MultiTermQuery)query).getField()))) {
                    return;
                }
                LeafReader reader = this.getLeafContext().reader();
                Query rewritten = query instanceof MultiTermQuery ? MultiTermQuery.SCORING_BOOLEAN_REWRITE.rewrite(new IndexSearcher((IndexReader)reader), (MultiTermQuery)query) : query.rewrite(new IndexSearcher((IndexReader)reader));
                if (rewritten != query) {
                    this.extract(rewritten, boost, terms);
                } else {
                    this.extractUnknownQuery(query, terms);
                }
            }
        }
    }

    protected boolean isQueryUnsupported(Class<? extends Query> clazz) {
        if (clazz.getName().startsWith("org.apache.lucene.spatial.")) {
            return true;
        }
        return clazz.getName().startsWith("org.apache.lucene.spatial3d.");
    }

    protected void extractUnknownQuery(Query query, Map<String, WeightedSpanTerm> terms) throws IOException {
    }

    protected void extractWeightedSpanTerms(Map<String, WeightedSpanTerm> terms, SpanQuery spanQuery, float boost) throws IOException {
        HashSet<String> queryFieldNames = new HashSet<String>();
        this.collectSpanQueryFields(spanQuery, queryFieldNames);
        if (!(this.fieldName == null || queryFieldNames.contains(this.fieldName) || this.defaultField != null && queryFieldNames.contains(this.defaultField))) {
            return;
        }
        boolean mustRewriteQuery = this.mustRewriteQuery(spanQuery);
        IndexSearcher searcher = new IndexSearcher((IndexReaderContext)this.getLeafContext());
        searcher.setQueryCache(null);
        SpanQuery query = mustRewriteQuery ? (SpanQuery)searcher.rewrite((Query)spanQuery) : spanQuery;
        HashSet nonWeightedTerms = new HashSet();
        query.visit(QueryVisitor.termCollector(nonWeightedTerms));
        if (nonWeightedTerms.isEmpty()) {
            return;
        }
        ArrayList<PositionSpan> spanPositions = new ArrayList<PositionSpan>();
        LeafReaderContext context = this.getLeafContext();
        SpanWeight w = (SpanWeight)searcher.createWeight(searcher.rewrite((Query)query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Spans spans = w.getSpans(context, SpanWeight.Postings.POSITIONS);
        if (spans == null) {
            return;
        }
        Bits acceptDocs = context.reader().getLiveDocs();
        while (spans.nextDoc() != Integer.MAX_VALUE) {
            if (acceptDocs != null && !acceptDocs.get(spans.docID())) continue;
            while (spans.nextStartPosition() != Integer.MAX_VALUE) {
                spanPositions.add(new PositionSpan(spans.startPosition(), spans.endPosition() - 1));
            }
        }
        if (spanPositions.isEmpty()) {
            return;
        }
        for (Term queryTerm : nonWeightedTerms) {
            if (!this.fieldNameComparator(queryTerm.field())) continue;
            WeightedSpanTerm weightedSpanTerm = terms.get(queryTerm.text());
            if (weightedSpanTerm == null) {
                weightedSpanTerm = new WeightedSpanTerm(boost, queryTerm.text());
                weightedSpanTerm.addPositionSpans(spanPositions);
                weightedSpanTerm.positionSensitive = true;
                terms.put(queryTerm.text(), weightedSpanTerm);
                continue;
            }
            if (spanPositions.size() <= 0) continue;
            weightedSpanTerm.addPositionSpans(spanPositions);
        }
    }

    protected void extractWeightedTerms(Map<String, WeightedSpanTerm> terms, Query query, float boost) throws IOException {
        HashSet nonWeightedTerms = new HashSet();
        IndexSearcher searcher = new IndexSearcher((IndexReaderContext)this.getLeafContext());
        searcher.rewrite(query).visit(QueryVisitor.termCollector(nonWeightedTerms));
        for (Term queryTerm : nonWeightedTerms) {
            if (!this.fieldNameComparator(queryTerm.field())) continue;
            WeightedSpanTerm weightedSpanTerm = new WeightedSpanTerm(boost, queryTerm.text());
            terms.put(queryTerm.text(), weightedSpanTerm);
        }
    }

    protected boolean fieldNameComparator(String fieldNameToCheck) {
        return this.fieldName == null || this.fieldName.equals(fieldNameToCheck) || this.defaultField != null && this.defaultField.equals(fieldNameToCheck);
    }

    protected LeafReaderContext getLeafContext() throws IOException {
        if (this.internalReader == null) {
            boolean cacheIt;
            boolean bl = cacheIt = this.wrapToCaching && !(this.tokenStream instanceof CachingTokenFilter);
            if (this.tokenStream instanceof TokenStreamFromTermVector) {
                cacheIt = false;
                Terms termVectorTerms = ((TokenStreamFromTermVector)this.tokenStream).getTermVectorTerms();
                if (termVectorTerms.hasPositions() && termVectorTerms.hasOffsets()) {
                    this.internalReader = new TermVectorLeafReader("shadowed_field", termVectorTerms);
                }
            }
            if (this.internalReader == null) {
                MemoryIndex indexer = new MemoryIndex(true, this.usePayloads);
                if (cacheIt) {
                    assert (!this.cachedTokenStream);
                    this.tokenStream = new CachingTokenFilter((TokenStream)new OffsetLimitTokenFilter(this.tokenStream, this.maxDocCharsToAnalyze));
                    this.cachedTokenStream = true;
                    indexer.addField("shadowed_field", this.tokenStream);
                } else {
                    indexer.addField("shadowed_field", (TokenStream)new OffsetLimitTokenFilter(this.tokenStream, this.maxDocCharsToAnalyze));
                }
                IndexSearcher searcher = indexer.createSearcher();
                this.internalReader = ((LeafReaderContext)searcher.getTopReaderContext()).reader();
            }
            this.internalReader = new DelegatingLeafReader(this.internalReader);
        }
        return this.internalReader.getContext();
    }

    public Map<String, WeightedSpanTerm> getWeightedSpanTerms(Query query, float boost, TokenStream tokenStream) throws IOException {
        return this.getWeightedSpanTerms(query, boost, tokenStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WeightedSpanTerm> getWeightedSpanTerms(Query query, float boost, TokenStream tokenStream, String fieldName) throws IOException {
        this.fieldName = fieldName;
        PositionCheckingMap<String> terms = new PositionCheckingMap<String>();
        this.tokenStream = tokenStream;
        try {
            this.extract(query, boost, terms);
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.internalReader});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.internalReader});
        return terms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WeightedSpanTerm> getWeightedSpanTermsWithScores(Query query, float boost, TokenStream tokenStream, String fieldName, IndexReader reader) throws IOException {
        this.fieldName = fieldName;
        this.tokenStream = tokenStream;
        PositionCheckingMap<String> terms = new PositionCheckingMap<String>();
        this.extract(query, boost, terms);
        int totalNumDocs = reader.maxDoc();
        Set weightedTerms = terms.keySet();
        Iterator it = weightedTerms.iterator();
        try {
            while (it.hasNext()) {
                WeightedSpanTerm weightedSpanTerm = (WeightedSpanTerm)terms.get(it.next());
                int docFreq = reader.docFreq(new Term(fieldName, weightedSpanTerm.term));
                float idf = (float)(Math.log((double)totalNumDocs / (double)(docFreq + 1)) + 1.0);
                weightedSpanTerm.weight *= idf;
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.internalReader});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.internalReader});
        return terms;
    }

    protected void collectSpanQueryFields(SpanQuery spanQuery, Set<String> fieldNames) {
        if (spanQuery instanceof FieldMaskingSpanQuery) {
            this.collectSpanQueryFields(((FieldMaskingSpanQuery)spanQuery).getMaskedQuery(), fieldNames);
        } else if (spanQuery instanceof SpanFirstQuery) {
            this.collectSpanQueryFields(((SpanFirstQuery)spanQuery).getMatch(), fieldNames);
        } else if (spanQuery instanceof SpanNearQuery) {
            for (SpanQuery clause : ((SpanNearQuery)spanQuery).getClauses()) {
                this.collectSpanQueryFields(clause, fieldNames);
            }
        } else if (spanQuery instanceof SpanNotQuery) {
            this.collectSpanQueryFields(((SpanNotQuery)spanQuery).getInclude(), fieldNames);
        } else if (spanQuery instanceof SpanOrQuery) {
            for (SpanQuery clause : ((SpanOrQuery)spanQuery).getClauses()) {
                this.collectSpanQueryFields(clause, fieldNames);
            }
        } else {
            fieldNames.add(spanQuery.getField());
        }
    }

    protected boolean mustRewriteQuery(SpanQuery spanQuery) {
        if (!this.expandMultiTermQuery) {
            return false;
        }
        if (spanQuery instanceof FieldMaskingSpanQuery) {
            return this.mustRewriteQuery(((FieldMaskingSpanQuery)spanQuery).getMaskedQuery());
        }
        if (spanQuery instanceof SpanFirstQuery) {
            return this.mustRewriteQuery(((SpanFirstQuery)spanQuery).getMatch());
        }
        if (spanQuery instanceof SpanNearQuery) {
            for (SpanQuery clause : ((SpanNearQuery)spanQuery).getClauses()) {
                if (!this.mustRewriteQuery(clause)) continue;
                return true;
            }
            return false;
        }
        if (spanQuery instanceof SpanNotQuery) {
            SpanNotQuery spanNotQuery = (SpanNotQuery)spanQuery;
            return this.mustRewriteQuery(spanNotQuery.getInclude()) || this.mustRewriteQuery(spanNotQuery.getExclude());
        }
        if (spanQuery instanceof SpanOrQuery) {
            for (SpanQuery clause : ((SpanOrQuery)spanQuery).getClauses()) {
                if (!this.mustRewriteQuery(clause)) continue;
                return true;
            }
            return false;
        }
        return !(spanQuery instanceof SpanTermQuery);
    }

    public boolean getExpandMultiTermQuery() {
        return this.expandMultiTermQuery;
    }

    public void setExpandMultiTermQuery(boolean expandMultiTermQuery) {
        this.expandMultiTermQuery = expandMultiTermQuery;
    }

    public boolean isUsePayloads() {
        return this.usePayloads;
    }

    public void setUsePayloads(boolean usePayloads) {
        this.usePayloads = usePayloads;
    }

    public boolean isCachedTokenStream() {
        return this.cachedTokenStream;
    }

    public TokenStream getTokenStream() {
        assert (this.tokenStream != null);
        return this.tokenStream;
    }

    public void setWrapIfNotCachingTokenFilter(boolean wrap) {
        this.wrapToCaching = wrap;
    }

    protected final void setMaxDocCharsToAnalyze(int maxDocCharsToAnalyze) {
        this.maxDocCharsToAnalyze = maxDocCharsToAnalyze;
    }

    static final class DelegatingLeafReader
    extends FilterLeafReader {
        private static final String FIELD_NAME = "shadowed_field";

        DelegatingLeafReader(LeafReader in) {
            super(in);
        }

        public FieldInfos getFieldInfos() {
            throw new UnsupportedOperationException();
        }

        public Terms terms(String field) throws IOException {
            return super.terms(FIELD_NAME);
        }

        public NumericDocValues getNumericDocValues(String field) throws IOException {
            return super.getNumericDocValues(FIELD_NAME);
        }

        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            return super.getBinaryDocValues(FIELD_NAME);
        }

        public SortedDocValues getSortedDocValues(String field) throws IOException {
            return super.getSortedDocValues(FIELD_NAME);
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            return super.getNormValues(FIELD_NAME);
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }

    protected static class PositionCheckingMap<K>
    extends HashMap<K, WeightedSpanTerm> {
        protected PositionCheckingMap() {
        }

        @Override
        public void putAll(Map<? extends K, ? extends WeightedSpanTerm> m) {
            for (Map.Entry<K, WeightedSpanTerm> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public WeightedSpanTerm put(K key, WeightedSpanTerm newTerm) {
            WeightedSpanTerm prevTerm = super.put(key, newTerm);
            if (prevTerm != null && !prevTerm.positionSensitive) {
                newTerm.positionSensitive = false;
            }
            return prevTerm;
        }
    }
}

