/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.AuthorizationServiceField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetBitsetCache;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.DocumentSubsetReader;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;

public class SecurityIndexReaderWrapper
implements CheckedFunction<DirectoryReader, DirectoryReader, IOException> {
    private static final Logger logger = LogManager.getLogger(SecurityIndexReaderWrapper.class);
    private final Function<ShardId, SearchExecutionContext> searchExecutionContextProvider;
    private final DocumentSubsetBitsetCache bitsetCache;
    private final XPackLicenseState licenseState;
    private final SecurityContext securityContext;
    private final ScriptService scriptService;

    public SecurityIndexReaderWrapper(Function<ShardId, SearchExecutionContext> searchExecutionContextProvider, DocumentSubsetBitsetCache bitsetCache, SecurityContext securityContext, XPackLicenseState licenseState, ScriptService scriptService) {
        this.scriptService = scriptService;
        this.searchExecutionContextProvider = searchExecutionContextProvider;
        this.bitsetCache = bitsetCache;
        this.securityContext = securityContext;
        this.licenseState = licenseState;
    }

    public DirectoryReader apply(DirectoryReader reader) {
        if (!SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState)) {
            return reader;
        }
        try {
            BooleanQuery filterQuery;
            IndicesAccessControl indicesAccessControl = this.getIndicesAccessControl();
            assert (indicesAccessControl.isGranted());
            ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
            if (shardId == null) {
                throw new IllegalStateException(LoggerMessageFormat.format((String)"couldn't extract shardId from reader [{}]", (Object[])new Object[]{reader}));
            }
            IndicesAccessControl.IndexAccessControl permissions = indicesAccessControl.getIndexPermissions(shardId.getIndexName());
            if (permissions == null) {
                return reader;
            }
            Object wrappedReader = reader;
            DocumentPermissions documentPermissions = permissions.getDocumentPermissions();
            if (documentPermissions.hasDocumentLevelPermissions() && (filterQuery = documentPermissions.filter(this.getUser(), this.scriptService, shardId, this.searchExecutionContextProvider)) != null) {
                wrappedReader = DocumentSubsetReader.wrap(wrappedReader, this.bitsetCache, (Query)new ConstantScoreQuery((Query)filterQuery));
            }
            IndexVersion indexVersionCreated = this.searchExecutionContextProvider.apply(shardId).indexVersionCreated();
            return permissions.getFieldPermissions().filter((DirectoryReader)wrappedReader, indexVersionCreated);
        }
        catch (IOException e) {
            logger.error("Unable to apply field level security");
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected IndicesAccessControl getIndicesAccessControl() {
        ThreadContext threadContext = this.securityContext.getThreadContext();
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)AuthorizationServiceField.INDICES_PERMISSIONS_VALUE.get(threadContext);
        if (indicesAccessControl == null) {
            throw Exceptions.authorizationError("no indices permissions found", new Object[0]);
        }
        return indicesAccessControl;
    }

    protected User getUser() {
        return Objects.requireNonNull(this.securityContext.getUser());
    }
}

