/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.gcs;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ProjectSecrets;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.gcs.GcsRepositoryStatsCollector;
import org.elasticsearch.repositories.gcs.GoogleCloudStorageClientSettings;
import org.elasticsearch.repositories.gcs.MeteredStorage;
import org.elasticsearch.repositories.gcs.ShouldRetryDecorator;

public class GoogleCloudStorageService {
    private static final Logger logger = LogManager.getLogger(GoogleCloudStorageService.class);
    private final GoogleCloudStorageClientsManager clientsManager;
    private final boolean isServerless;

    public GoogleCloudStorageService(ClusterService clusterService, ProjectResolver projectResolver) {
        Settings nodeSettings = clusterService.getSettings();
        this.isServerless = DiscoveryNode.isStateless((Settings)nodeSettings);
        this.clientsManager = new GoogleCloudStorageClientsManager(nodeSettings, projectResolver.supportsMultipleProjects());
        if (projectResolver.supportsMultipleProjects()) {
            clusterService.addHighPriorityApplier((ClusterStateApplier)this.clientsManager);
        }
    }

    public boolean isServerless() {
        return this.isServerless;
    }

    public void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
        this.clientsManager.refreshAndClearCacheForClusterClients(clientsSettings);
    }

    public MeteredStorage client(@Nullable ProjectId projectId, String clientName, String repositoryName, GcsRepositoryStatsCollector statsCollector) throws IOException {
        return this.clientsManager.client(projectId, clientName, repositoryName, statsCollector);
    }

    void closeRepositoryClients(@Nullable ProjectId projectId, String repositoryName) {
        this.clientsManager.closeRepositoryClients(projectId, repositoryName);
    }

    GoogleCloudStorageClientsManager getClientsManager() {
        return this.clientsManager;
    }

    private MeteredStorage createClient(GoogleCloudStorageClientSettings gcsClientSettings, GcsRepositoryStatsCollector statsCollector) throws IOException {
        NetHttpTransport httpTransport;
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        try {
            KeyStore certTrustStore = SecurityUtils.getJavaKeyStore();
            try (InputStream keyStoreStream = GoogleUtils.class.getResourceAsStream("google.jks");){
                SecurityUtils.loadKeyStore((KeyStore)certTrustStore, (InputStream)keyStoreStream, (String)"notasecret");
            }
            builder.trustCertificates(certTrustStore);
            Proxy proxy = gcsClientSettings.getProxy();
            if (proxy != null) {
                builder.setProxy(proxy);
                this.notifyProxyIsSet(proxy);
            }
            httpTransport = builder.build();
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HttpTransportOptions httpTransportOptions = new HttpTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(GoogleCloudStorageService.toTimeout(gcsClientSettings.getConnectTimeout()).intValue()).setReadTimeout(GoogleCloudStorageService.toTimeout(gcsClientSettings.getReadTimeout()).intValue()).setHttpTransportFactory(() -> GoogleCloudStorageService.lambda$createClient$0((HttpTransport)httpTransport))){

            public HttpRequestInitializer getHttpRequestInitializer(ServiceOptions<?, ?> serviceOptions) {
                HttpRequestInitializer requestInitializer = super.getHttpRequestInitializer(serviceOptions);
                return httpRequest -> {
                    if (requestInitializer != null) {
                        requestInitializer.initialize(httpRequest);
                    }
                    httpRequest.setResponseInterceptor(GcsRepositoryStatsCollector.METERING_INTERCEPTOR);
                };
            }
        };
        StorageOptions storageOptions = this.createStorageOptions(gcsClientSettings, httpTransportOptions);
        return new MeteredStorage((Storage)storageOptions.getService(), statsCollector);
    }

    StorageOptions createStorageOptions(GoogleCloudStorageClientSettings gcsClientSettings, HttpTransportOptions httpTransportOptions) {
        StorageOptions.Builder storageOptionsBuilder = (StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setStorageRetryStrategy(this.getRetryStrategy()).setTransportOptions((TransportOptions)httpTransportOptions)).setHeaderProvider(() -> org.elasticsearch.common.Strings.hasLength((String)gcsClientSettings.getApplicationName()) ? Map.of("user-agent", gcsClientSettings.getApplicationName()) : Map.of());
        if (org.elasticsearch.common.Strings.hasLength((String)gcsClientSettings.getHost())) {
            storageOptionsBuilder.setHost(gcsClientSettings.getHost());
        }
        if (org.elasticsearch.common.Strings.hasLength((String)gcsClientSettings.getProjectId())) {
            storageOptionsBuilder.setProjectId(gcsClientSettings.getProjectId());
        } else {
            String defaultProjectId = null;
            try {
                defaultProjectId = ServiceOptions.getDefaultProjectId();
                if (defaultProjectId != null) {
                    storageOptionsBuilder.setProjectId(defaultProjectId);
                }
            }
            catch (Exception e) {
                logger.warn("failed to load default project id", (Throwable)e);
            }
            if (defaultProjectId == null) {
                try {
                    String projectId = GoogleCloudStorageService.getDefaultProjectId(gcsClientSettings.getProxy());
                    if (projectId != null) {
                        storageOptionsBuilder.setProjectId(projectId);
                    }
                }
                catch (Exception e) {
                    logger.warn("failed to load default project id fallback", (Throwable)e);
                }
            }
        }
        if (gcsClientSettings.getCredential() == null) {
            try {
                storageOptionsBuilder.setCredentials((Credentials)GoogleCredentials.getApplicationDefault());
            }
            catch (Exception e) {
                logger.warn("failed to load Application Default Credentials", (Throwable)e);
            }
        } else {
            ServiceAccountCredentials serviceAccountCredentials = gcsClientSettings.getCredential();
            URI tokenServerUri = gcsClientSettings.getTokenUri();
            if (org.elasticsearch.common.Strings.hasLength((String)tokenServerUri.toString())) {
                serviceAccountCredentials = serviceAccountCredentials.toBuilder().setTokenServerUri(tokenServerUri).build();
            }
            storageOptionsBuilder.setCredentials((Credentials)serviceAccountCredentials);
        }
        return storageOptionsBuilder.build();
    }

    protected StorageRetryStrategy getRetryStrategy() {
        return ShouldRetryDecorator.decorate(StorageRetryStrategy.getLegacyStorageRetryStrategy(), (prevThrowable, prevResponse, delegate) -> {
            if (ExceptionsHelper.unwrap((Throwable)prevThrowable, (Class[])new Class[]{UnknownHostException.class}) != null) {
                return true;
            }
            if (ExceptionsHelper.unwrap((Throwable)prevThrowable, (Class[])new Class[]{SocketException.class}) != null) {
                return true;
            }
            return delegate.shouldRetry(prevThrowable, prevResponse);
        });
    }

    @SuppressForbidden(reason="ok to open connection here")
    static String getDefaultProjectId(@Nullable Proxy proxy) throws IOException {
        block12: {
            String metaHost = System.getenv("GCE_METADATA_HOST");
            if (metaHost == null) {
                metaHost = "metadata.google.internal";
            }
            URL url = new URL("http://" + metaHost + "/computeMetadata/v1/project/project-id");
            HttpURLConnection connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setRequestProperty("Metadata-Flavor", "Google");
            try (InputStream input = connection.getInputStream();){
                String string;
                if (connection.getResponseCode() != 200) break block12;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
                    string = reader.readLine();
                }
                return string;
            }
        }
        return null;
    }

    static Integer toTimeout(TimeValue timeout) {
        if (timeout == null || TimeValue.ZERO.equals((Object)timeout)) {
            return -1;
        }
        if (TimeValue.MINUS_ONE.equals((Object)timeout)) {
            return 0;
        }
        return Math.toIntExact(timeout.getMillis());
    }

    void notifyProxyIsSet(Proxy proxy) {
    }

    private static /* synthetic */ HttpTransport lambda$createClient$0(HttpTransport httpTransport) {
        return httpTransport;
    }

    class GoogleCloudStorageClientsManager
    implements ClusterStateApplier {
        private static final String GCS_SETTING_PREFIX = "gcs.";
        private final Settings nodeGcsSettings;
        private final Map<ProjectId, PerProjectClientsHolder> perProjectClientsHolders;
        private final ClusterClientsHolder clusterClientsHolder;

        GoogleCloudStorageClientsManager(Settings nodeSettings, boolean supportsMultipleProjects) {
            this.nodeGcsSettings = Settings.builder().put(nodeSettings.getByPrefix(GCS_SETTING_PREFIX), false).normalizePrefix(GCS_SETTING_PREFIX).build();
            this.perProjectClientsHolders = supportsMultipleProjects ? ConcurrentCollections.newConcurrentMap() : null;
            this.clusterClientsHolder = new ClusterClientsHolder(GoogleCloudStorageService.this);
        }

        public void applyClusterState(ClusterChangedEvent event) {
            assert (this.perProjectClientsHolders != null);
            Map currentProjects = event.state().metadata().projects();
            HashMap<ProjectId, PerProjectClientsHolder> updatedPerProjectClients = new HashMap<ProjectId, PerProjectClientsHolder>();
            for (ProjectMetadata project : currentProjects.values()) {
                if (ProjectId.DEFAULT.equals((Object)project.id())) continue;
                ProjectSecrets projectSecrets = (ProjectSecrets)project.custom("project_state_secrets");
                if (projectSecrets == null || projectSecrets.getSettingNames().stream().noneMatch(key -> key.startsWith(GCS_SETTING_PREFIX))) {
                    this.perProjectClientsHolders.remove(project.id());
                    continue;
                }
                Settings currentSettings = Settings.builder().put(this.nodeGcsSettings).setSecureSettings(projectSecrets.getSettings()).build();
                Map<String, GoogleCloudStorageClientSettings> allClientSettings = GoogleCloudStorageClientSettings.load(currentSettings);
                assert (!allClientSettings.isEmpty());
                Map<String, GoogleCloudStorageClientSettings> clientSettingsWithCredentials = allClientSettings.entrySet().stream().filter(entry -> ((GoogleCloudStorageClientSettings)entry.getValue()).getCredential() != null).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!this.newOrUpdated(project.id(), clientSettingsWithCredentials)) continue;
                if (allClientSettings.size() != clientSettingsWithCredentials.size()) {
                    logger.warn("Project [{}] has [{}] GCS client settings, but [{}] is usable due to missing credentials for clients {}", (Object)project.id(), (Object)allClientSettings.size(), (Object)clientSettingsWithCredentials.size(), (Object)Sets.difference(allClientSettings.keySet(), clientSettingsWithCredentials.keySet()));
                }
                updatedPerProjectClients.put(project.id(), new PerProjectClientsHolder(GoogleCloudStorageService.this, clientSettingsWithCredentials));
            }
            for (ProjectId projectId : updatedPerProjectClients.keySet()) {
                assert (!ProjectId.DEFAULT.equals((Object)projectId));
                this.perProjectClientsHolders.put(projectId, (PerProjectClientsHolder)updatedPerProjectClients.get(projectId));
            }
            for (ProjectId projectId : this.perProjectClientsHolders.keySet()) {
                if (currentProjects.containsKey(projectId)) continue;
                assert (!ProjectId.DEFAULT.equals((Object)projectId));
                this.perProjectClientsHolders.remove(projectId);
            }
        }

        void refreshAndClearCacheForClusterClients(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
            this.clusterClientsHolder.refreshAndClearCache(clientsSettings);
        }

        MeteredStorage client(ProjectId projectId, String clientName, String repositoryName, GcsRepositoryStatsCollector statsCollector) throws IOException {
            if (projectId == null || ProjectId.DEFAULT.equals((Object)projectId)) {
                return this.clusterClientsHolder.client(clientName, repositoryName, statsCollector);
            }
            return this.getClientsHolderSafe(projectId).client(clientName, repositoryName, statsCollector);
        }

        void closeRepositoryClients(ProjectId projectId, String repositoryName) {
            if (projectId == null || ProjectId.DEFAULT.equals((Object)projectId)) {
                this.clusterClientsHolder.closeRepositoryClients(repositoryName);
            } else {
                PerProjectClientsHolder old = this.perProjectClientsHolders.get(projectId);
                if (old != null) {
                    old.closeRepositoryClients(repositoryName);
                }
            }
        }

        ClusterClientsHolder getClusterClientsHolder() {
            return this.clusterClientsHolder;
        }

        Map<ProjectId, ClientsHolder> getPerProjectClientsHolders() {
            return this.perProjectClientsHolders == null ? null : Map.copyOf(this.perProjectClientsHolders);
        }

        private boolean newOrUpdated(ProjectId projectId, Map<String, GoogleCloudStorageClientSettings> currentClientSettings) {
            PerProjectClientsHolder old = this.perProjectClientsHolders.get(projectId);
            if (old == null) {
                return true;
            }
            return !currentClientSettings.equals(old.allClientSettings());
        }

        private ClientsHolder getClientsHolderSafe(ProjectId projectId) {
            assert (!ProjectId.DEFAULT.equals((Object)projectId));
            PerProjectClientsHolder clientsHolder = this.perProjectClientsHolders.get(projectId);
            if (clientsHolder == null) {
                throw new IllegalArgumentException("No GCS client is configured for project [" + String.valueOf(projectId) + "]");
            }
            return clientsHolder;
        }
    }

    final class PerProjectClientsHolder
    extends ClientsHolder {
        private final Map<String, GoogleCloudStorageClientSettings> clientSettings;

        PerProjectClientsHolder(GoogleCloudStorageService this$0, Map<String, GoogleCloudStorageClientSettings> clientSettings) {
            this.clientSettings = clientSettings;
        }

        @Override
        protected Map<String, GoogleCloudStorageClientSettings> allClientSettings() {
            return this.clientSettings;
        }
    }

    final class ClusterClientsHolder
    extends ClientsHolder {
        private volatile Map<String, GoogleCloudStorageClientSettings> clientSettings = Collections.emptyMap();

        ClusterClientsHolder(GoogleCloudStorageService this$0) {
        }

        @Override
        protected Map<String, GoogleCloudStorageClientSettings> allClientSettings() {
            return this.clientSettings;
        }

        synchronized void refreshAndClearCache(Map<String, GoogleCloudStorageClientSettings> clientsSettings) {
            this.clientCache = Collections.emptyMap();
            this.clientSettings = Maps.ofEntries(clientsSettings.entrySet());
        }
    }

    abstract class ClientsHolder {
        protected volatile Map<String, MeteredStorage> clientCache = Collections.emptyMap();

        ClientsHolder() {
        }

        protected abstract Map<String, GoogleCloudStorageClientSettings> allClientSettings();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MeteredStorage client(String clientName, String repositoryName, GcsRepositoryStatsCollector statsCollector) throws IOException {
            MeteredStorage storage = this.clientCache.get(repositoryName);
            if (storage != null) {
                return storage;
            }
            ClientsHolder clientsHolder = this;
            synchronized (clientsHolder) {
                MeteredStorage existing = this.clientCache.get(repositoryName);
                if (existing != null) {
                    return existing;
                }
                GoogleCloudStorageClientSettings settings = this.allClientSettings().get(clientName);
                if (settings == null) {
                    throw new IllegalArgumentException("Unknown client name [" + clientName + "]. Existing client configs: " + String.valueOf(this.allClientSettings().keySet()));
                }
                logger.debug(() -> Strings.format((String)"creating GCS client with client_name [%s], endpoint [%s]", (Object[])new Object[]{clientName, settings.getHost()}));
                MeteredStorage storage2 = GoogleCloudStorageService.this.createClient(settings, statsCollector);
                this.clientCache = Maps.copyMapWithAddedEntry(this.clientCache, (Object)repositoryName, (Object)storage2);
                return storage2;
            }
        }

        synchronized void closeRepositoryClients(String repositoryName) {
            this.clientCache = this.clientCache.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(repositoryName)).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        final boolean hasCachedClientForRepository(String repositoryName) {
            return this.clientCache.containsKey(repositoryName);
        }
    }
}

