/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.random.AbstractDistribution1D;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;

public final class Normal1D
extends AbstractDistribution1D {
    private final Array1D<Double> myLocations;
    private final Array1D<Double> myScales;

    static Access2D<?> correlations(Access2D<?> covariances) {
        int tmpDim = (int)covariances.countRows();
        Array2D retVal = (Array2D)Array2D.PRIMITIVE64.make(tmpDim, tmpDim);
        Array1D tmpStdDev = (Array1D)Array1D.PRIMITIVE64.make(tmpDim);
        for (int ij = 0; ij < tmpDim; ++ij) {
            tmpStdDev.set((long)ij, PrimitiveMath.SQRT.invoke(covariances.doubleValue(ij, ij)));
        }
        for (int j = 0; j < tmpDim; ++j) {
            retVal.set((long)j, (long)j, PrimitiveMath.ONE);
            for (int i = j + 1; i < tmpDim; ++i) {
                double tmpCorrelation = covariances.doubleValue(i, j) / (tmpStdDev.doubleValue(i) * tmpStdDev.doubleValue(j));
                retVal.set((long)i, (long)j, tmpCorrelation);
                retVal.set((long)j, (long)i, tmpCorrelation);
            }
        }
        return retVal;
    }

    public Normal1D(Access1D<?> locations, Access2D<?> covariances) {
        super(Normal1D.correlations(covariances));
        int tmpDim = (int)covariances.countRows();
        this.myLocations = Array1D.PRIMITIVE64.copy((Access1D)locations);
        this.myScales = (Array1D)Array1D.PRIMITIVE64.make(tmpDim);
        for (int ij = 0; ij < tmpDim; ++ij) {
            this.myScales.set((long)ij, PrimitiveMath.SQRT.invoke(covariances.doubleValue(ij, ij)));
        }
    }

    private Normal1D(Access2D<?> correlations) {
        super(correlations);
        this.myLocations = null;
        this.myScales = null;
    }

    public Array1D<Double> doubleValue() {
        Array1D<Double> retVal = this.random().nextGaussian();
        int i = 0;
        while ((long)i < retVal.length) {
            retVal.set((long)i, this.myLocations.doubleValue(i) + this.myScales.doubleValue(i) * retVal.doubleValue(i));
            ++i;
        }
        return retVal;
    }

    @Override
    public Array1D<Double> getExpected() {
        return this.myLocations;
    }

    @Override
    public Array1D<Double> getStandardDeviation() {
        return this.myScales;
    }
}

