/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.IntSupplier;
import org.ojalgo.OjAlgoUtils;
import org.ojalgo.concurrent.DaemonPoolExecutor;
import org.ojalgo.concurrent.Parallelism;

public abstract class DivideAndConquer {
    static void call(ExecutorService executor, int first, int limit, int threshold, int workers, Conquerer conquerer) {
        int count = limit - first;
        if (count > threshold && workers > 1) {
            int split = first + count / 2;
            int nextWorkers = workers / 2;
            Future<?> firstPart = executor.submit(() -> DivideAndConquer.call(executor, first, split, threshold, nextWorkers, conquerer));
            Future<?> secondPart = executor.submit(() -> DivideAndConquer.call(executor, split, limit, threshold, nextWorkers, conquerer));
            try {
                firstPart.get();
                secondPart.get();
            }
            catch (InterruptedException | ExecutionException cause) {
                throw new RuntimeException(cause);
            }
        } else {
            conquerer.conquer(first, limit);
        }
    }

    public final void invoke(int first, int limit, int threshold) {
        int availableWorkers = OjAlgoUtils.ENVIRONMENT.threads;
        DivideAndConquer.call(DaemonPoolExecutor.INSTANCE, first, limit, threshold, availableWorkers, this::conquer);
    }

    protected abstract void conquer(int var1, int var2);

    public static final class Divider {
        private final ExecutorService myExecutor;
        private IntSupplier myParallelism = Parallelism.THREADS;
        private int myThreshold = 128;

        Divider(ExecutorService executor) {
            this.myExecutor = executor;
        }

        public void divide(int limit, Conquerer conquerer) {
            this.divide(0, limit, conquerer);
        }

        public void divide(int first, int limit, Conquerer conquerer) {
            DivideAndConquer.call(this.myExecutor, first, limit, this.myThreshold, this.myParallelism.getAsInt(), conquerer);
        }

        public Divider parallelism(IntSupplier parallelism) {
            if (parallelism != null) {
                this.myParallelism = parallelism;
            }
            return this;
        }

        public Divider threshold(int threshold) {
            this.myThreshold = threshold;
            return this;
        }
    }

    @FunctionalInterface
    public static interface Conquerer {
        public void conquer(int var1, int var2);
    }
}

