/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.logsdb.patterntext.Arg;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextValueProcessor;

public final class PatternTextDocValues
extends BinaryDocValues {
    private final SortedSetDocValues templateDocValues;
    private final SortedSetDocValues argsDocValues;
    private final SortedSetDocValues argsInfoDocValues;

    PatternTextDocValues(SortedSetDocValues templateDocValues, SortedSetDocValues argsDocValues, SortedSetDocValues argsInfoDocValues) {
        this.templateDocValues = templateDocValues;
        this.argsDocValues = argsDocValues;
        this.argsInfoDocValues = argsInfoDocValues;
    }

    static PatternTextDocValues from(LeafReader leafReader, String templateFieldName, String argsFieldName, String argsInfoFieldName) throws IOException {
        SortedSetDocValues templateDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)templateFieldName);
        SortedSetDocValues argsDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)argsFieldName);
        SortedSetDocValues argsInfoDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)argsInfoFieldName);
        return new PatternTextDocValues(templateDocValues, argsDocValues, argsInfoDocValues);
    }

    private String getNextStringValue() throws IOException {
        assert (this.templateDocValues.docValueCount() == 1);
        assert (this.argsInfoDocValues.docValueCount() == 1);
        String template = this.templateDocValues.lookupOrd(this.templateDocValues.nextOrd()).utf8ToString();
        List<Arg.Info> argsInfo = Arg.decodeInfo(this.argsInfoDocValues.lookupOrd(this.argsInfoDocValues.nextOrd()).utf8ToString());
        if (!argsInfo.isEmpty()) {
            assert (this.argsDocValues.docValueCount() == 1);
            BytesRef mergedArgs = this.argsDocValues.lookupOrd(this.argsDocValues.nextOrd());
            String[] args = Arg.decodeRemainingArgs(mergedArgs.utf8ToString());
            assert (args.length == argsInfo.size());
            return PatternTextValueProcessor.merge(template, args, argsInfo);
        }
        return template;
    }

    public BytesRef binaryValue() throws IOException {
        return new BytesRef((CharSequence)this.getNextStringValue());
    }

    public boolean advanceExact(int i) throws IOException {
        this.argsDocValues.advanceExact(i);
        this.argsInfoDocValues.advanceExact(i);
        return this.templateDocValues.advanceExact(i);
    }

    public int docID() {
        return this.templateDocValues.docID();
    }

    public int nextDoc() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int advance(int i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long cost() {
        return this.templateDocValues.cost() + this.argsDocValues.cost() + this.argsInfoDocValues.cost();
    }
}

