/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.Map;
import org.elasticsearch.xpack.profiling.action.CostEntry;
import org.elasticsearch.xpack.profiling.action.HostMetadata;
import org.elasticsearch.xpack.profiling.action.InstanceTypeService;

final class CostCalculator {
    private static final double SECONDS_PER_HOUR = 3600.0;
    private static final double SECONDS_PER_YEAR = 3.1536E7;
    public static final double DEFAULT_COST_USD_PER_CORE_HOUR = 0.0425;
    private static final double DEFAULT_COST_FACTOR = 1.0;
    private static final double DEFAULT_AWS_COST_FACTOR = 1.0;
    private static final double DEFAULT_AZURE_COST_FACTOR = 1.0;
    private final Map<String, HostMetadata> hostMetadata;
    private final double samplingDurationInSeconds;
    private final double customCostPerCoreHour;
    private final Map<String, Double> providerCostFactors;

    CostCalculator(Map<String, HostMetadata> hostMetadata, double samplingDurationInSeconds, Double awsCostFactor, Double azureCostFactor, Double customCostPerCoreHour) {
        this.hostMetadata = hostMetadata;
        this.samplingDurationInSeconds = samplingDurationInSeconds > 0.0 ? samplingDurationInSeconds : 1.0;
        this.customCostPerCoreHour = customCostPerCoreHour == null ? 0.0425 : customCostPerCoreHour;
        this.providerCostFactors = Map.of("aws", awsCostFactor == null ? 1.0 : awsCostFactor, "azure", azureCostFactor == null ? 1.0 : azureCostFactor);
    }

    public double annualCostsUSD(String hostID, double samples, double samplingFrequency) {
        double annualCoreHours = CostCalculator.annualCoreHours(this.samplingDurationInSeconds, samples, samplingFrequency);
        HostMetadata host = this.hostMetadata.get(hostID);
        if (host == null) {
            return annualCoreHours * this.customCostPerCoreHour;
        }
        double providerCostFactor = this.providerCostFactors.getOrDefault(host.instanceType.provider, 1.0);
        CostEntry costs = InstanceTypeService.getCosts(host.instanceType);
        if (costs == null) {
            return annualCoreHours * this.customCostPerCoreHour * providerCostFactor;
        }
        return annualCoreHours * (costs.usd_per_hour / (double)host.profilingNumCores) * providerCostFactor;
    }

    public static double annualCoreHours(double duration, double samples, double samplingFrequency) {
        return 3.1536E7 / duration * samples / samplingFrequency / 3600.0;
    }
}

