/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;

final class ScaleAdjustingBucketIterator
implements BucketIterator {
    private final BucketIterator delegate;
    private final int scaleAdjustment;
    private long currentIndex;
    private long currentCount;
    boolean hasNextValue;

    ScaleAdjustingBucketIterator(BucketIterator delegate, int targetScale) {
        this.delegate = delegate;
        this.scaleAdjustment = targetScale - delegate.scale();
        this.hasNextValue = true;
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextValue;
    }

    @Override
    public long peekCount() {
        this.assertEndNotReached();
        return this.currentCount;
    }

    @Override
    public long peekIndex() {
        this.assertEndNotReached();
        return this.currentIndex;
    }

    @Override
    public void advance() {
        this.assertEndNotReached();
        this.hasNextValue = this.delegate.hasNext();
        if (!this.hasNextValue) {
            return;
        }
        this.currentIndex = ExponentialScaleUtils.adjustScale(this.delegate.peekIndex(), this.delegate.scale(), this.scaleAdjustment);
        this.currentCount = this.delegate.peekCount();
        this.delegate.advance();
        while (this.delegate.hasNext() && ExponentialScaleUtils.adjustScale(this.delegate.peekIndex(), this.delegate.scale(), this.scaleAdjustment) == this.currentIndex) {
            this.currentCount += this.delegate.peekCount();
            this.delegate.advance();
        }
    }

    private void assertEndNotReached() {
        if (!this.hasNextValue) {
            throw new IllegalStateException("Iterator has no more buckets");
        }
    }

    @Override
    public int scale() {
        return this.delegate.scale() + this.scaleAdjustment;
    }
}

