/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobLeaseAsyncClient;
import com.azure.storage.blob.specialized.BlobLeaseClient;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={BlobLeaseClient.class, BlobLeaseAsyncClient.class})
public final class BlobLeaseClientBuilder {
    private HttpPipeline pipeline;
    private String url;
    private String containerName;
    private String blobName;
    private String leaseId;
    private boolean isBlob;
    private String accountName;
    private BlobServiceVersion serviceVersion;

    public BlobLeaseClient buildClient() {
        return new BlobLeaseClient(this.buildAsyncClient());
    }

    public BlobLeaseAsyncClient buildAsyncClient() {
        BlobServiceVersion version = this.serviceVersion == null ? BlobServiceVersion.getLatest() : this.serviceVersion;
        return new BlobLeaseAsyncClient(this.pipeline, this.url, this.containerName, this.blobName, this.getLeaseId(), this.isBlob, this.accountName, version.getVersion());
    }

    public BlobLeaseClientBuilder blobClient(BlobClientBase blobClient) {
        Objects.requireNonNull(blobClient);
        this.pipeline = blobClient.getHttpPipeline();
        this.url = blobClient.getAccountUrl();
        this.containerName = blobClient.getContainerName();
        this.blobName = blobClient.getBlobName();
        this.isBlob = true;
        this.accountName = blobClient.getAccountName();
        this.serviceVersion = blobClient.getServiceVersion();
        return this;
    }

    public BlobLeaseClientBuilder blobAsyncClient(BlobAsyncClientBase blobAsyncClient) {
        Objects.requireNonNull(blobAsyncClient);
        this.pipeline = blobAsyncClient.getHttpPipeline();
        this.url = blobAsyncClient.getAccountUrl();
        this.containerName = blobAsyncClient.getContainerName();
        this.blobName = blobAsyncClient.getBlobName();
        this.isBlob = true;
        this.accountName = blobAsyncClient.getAccountName();
        this.serviceVersion = blobAsyncClient.getServiceVersion();
        return this;
    }

    public BlobLeaseClientBuilder containerClient(BlobContainerClient blobContainerClient) {
        Objects.requireNonNull(blobContainerClient);
        this.pipeline = blobContainerClient.getHttpPipeline();
        this.url = blobContainerClient.getAccountUrl();
        this.containerName = blobContainerClient.getBlobContainerName();
        this.isBlob = false;
        this.accountName = blobContainerClient.getAccountName();
        this.serviceVersion = blobContainerClient.getServiceVersion();
        return this;
    }

    public BlobLeaseClientBuilder containerAsyncClient(BlobContainerAsyncClient blobContainerAsyncClient) {
        Objects.requireNonNull(blobContainerAsyncClient);
        this.pipeline = blobContainerAsyncClient.getHttpPipeline();
        this.url = blobContainerAsyncClient.getAccountUrl();
        this.containerName = blobContainerAsyncClient.getBlobContainerName();
        this.isBlob = false;
        this.accountName = blobContainerAsyncClient.getAccountName();
        this.serviceVersion = blobContainerAsyncClient.getServiceVersion();
        return this;
    }

    public BlobLeaseClientBuilder leaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    private String getLeaseId() {
        return this.leaseId == null ? CoreUtils.randomUuid().toString() : this.leaseId;
    }
}

