/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.output;

import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.output.FlushAcknowledgement;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.CategorizerStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.Quantiles;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyRecord;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.core.ml.job.results.CategoryDefinition;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Influencer;
import org.elasticsearch.xpack.core.ml.job.results.ModelPlot;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcess;
import org.elasticsearch.xpack.ml.job.process.autodetect.output.FlushListener;
import org.elasticsearch.xpack.ml.job.results.AutodetectResult;

public class JobSnapshotUpgraderResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(JobSnapshotUpgraderResultProcessor.class);
    final CountDownLatch completionLatch = new CountDownLatch(1);
    private final String jobId;
    private final String snapshotId;
    private final JobResultsPersister persister;
    private final AutodetectProcess process;
    private final JobResultsPersister.Builder bulkResultsPersister;
    private final FlushListener flushListener;
    private volatile boolean processKilled;
    private volatile boolean failed;

    public JobSnapshotUpgraderResultProcessor(String jobId, String snapshotId, JobResultsPersister persister, AutodetectProcess autodetectProcess) {
        this.jobId = Objects.requireNonNull(jobId);
        this.snapshotId = Objects.requireNonNull(snapshotId);
        this.persister = Objects.requireNonNull(persister);
        this.process = Objects.requireNonNull(autodetectProcess);
        this.bulkResultsPersister = persister.bulkPersisterBuilder(jobId, this::isAlive);
        this.flushListener = new FlushListener();
    }

    public void process() {
        try {
            this.readResults();
            try {
                if (!this.processKilled) {
                    this.bulkResultsPersister.executeRequest();
                }
            }
            catch (Exception e) {
                LOGGER.warn(() -> Strings.format((String)"[%s] [%s] Error persisting model snapshot upgrade results", (Object[])new Object[]{this.jobId, this.snapshotId}), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.failed = true;
            if (this.processKilled) {
                LOGGER.warn("[{}] [{}] some model snapshot upgrade results not processed due to the process being killed", (Object)this.jobId, (Object)this.snapshotId);
            } else if (!this.process.isProcessAliveAfterWaiting()) {
                LOGGER.warn("[{}] [{}] some model snapshot upgrade results not processed due to the termination of autodetect", (Object)this.jobId, (Object)this.snapshotId);
            } else {
                LOGGER.error(() -> Strings.format((String)"[%s] [%s] error parsing model snapshot upgrade output", (Object[])new Object[]{this.jobId, this.snapshotId}), (Throwable)e);
            }
        }
        finally {
            this.completionLatch.countDown();
        }
    }

    private void readResults() {
        try {
            Iterator<AutodetectResult> iterator = this.process.readAutodetectResults();
            while (iterator.hasNext()) {
                try {
                    AutodetectResult result = iterator.next();
                    this.processResult(result);
                }
                catch (Exception e) {
                    if (!this.isAlive()) {
                        throw e;
                    }
                    LOGGER.warn(() -> Strings.format((String)"[%s] [%s] Error processing model snapshot upgrade result", (Object[])new Object[]{this.jobId, this.snapshotId}), (Throwable)e);
                }
            }
        }
        finally {
            this.process.consumeAndCloseOutputStream();
        }
    }

    public void setProcessKilled() {
        this.processKilled = true;
    }

    public boolean isProcessKilled() {
        return this.processKilled;
    }

    private void logUnexpectedResult(String resultType) {
        String msg = "[" + this.jobId + "] [" + this.snapshotId + "] unexpected result read [" + resultType + "]";
        LOGGER.info(msg);
    }

    void processResult(AutodetectResult result) {
        FlushAcknowledgement flushAcknowledgement;
        Quantiles quantiles;
        ModelSnapshot modelSnapshot;
        ModelSizeStats modelSizeStats;
        ForecastRequestStats forecastRequestStats;
        Forecast forecast;
        Annotation annotation;
        ModelPlot modelPlot;
        CategorizerStats categorizerStats;
        CategoryDefinition categoryDefinition;
        List<Influencer> influencers;
        List<AnomalyRecord> records;
        if (this.processKilled) {
            return;
        }
        Bucket bucket = result.getBucket();
        if (bucket != null) {
            this.logUnexpectedResult("bucket");
        }
        if ((records = result.getRecords()) != null && !records.isEmpty()) {
            this.logUnexpectedResult("record");
        }
        if ((influencers = result.getInfluencers()) != null && !influencers.isEmpty()) {
            this.logUnexpectedResult("influencer");
        }
        if ((categoryDefinition = result.getCategoryDefinition()) != null) {
            this.logUnexpectedResult(CategoryDefinition.TYPE.getPreferredName());
        }
        if ((categorizerStats = result.getCategorizerStats()) != null) {
            this.logUnexpectedResult("categorizer_stats");
        }
        if ((modelPlot = result.getModelPlot()) != null) {
            this.logUnexpectedResult(ModelSnapshot.TYPE.getPreferredName());
        }
        if ((annotation = result.getAnnotation()) != null) {
            this.logUnexpectedResult(Annotation.TYPE.getPreferredName());
        }
        if ((forecast = result.getForecast()) != null) {
            this.logUnexpectedResult("model_forecast");
        }
        if ((forecastRequestStats = result.getForecastRequestStats()) != null) {
            this.logUnexpectedResult("model_forecast_request_stats");
        }
        if ((modelSizeStats = result.getModelSizeStats()) != null) {
            this.logUnexpectedResult("model_size_stats");
        }
        if ((modelSnapshot = result.getModelSnapshot()) != null) {
            BulkResponse bulkResponse = this.persister.persistModelSnapshot(modelSnapshot, WriteRequest.RefreshPolicy.IMMEDIATE, this::isAlive);
            assert (bulkResponse.getItems().length == 1);
        }
        if ((quantiles = result.getQuantiles()) != null) {
            this.logUnexpectedResult(Quantiles.TYPE.getPreferredName());
        }
        if ((flushAcknowledgement = result.getFlushAcknowledgement()) != null) {
            LOGGER.debug(() -> Strings.format((String)"[%s] [%s] Flush acknowledgement parsed from output for ID %s", (Object[])new Object[]{this.jobId, this.snapshotId, flushAcknowledgement.getId()}));
            this.flushListener.acknowledgeFlush(flushAcknowledgement, null);
        }
    }

    @Nullable
    public FlushAcknowledgement waitForFlushAcknowledgement(String flushId, Duration timeout) throws Exception {
        return this.failed ? null : this.flushListener.waitForFlush(flushId, timeout);
    }

    public void clearAwaitingFlush(String flushId) {
        this.flushListener.clear(flushId);
    }

    public void awaitCompletion() throws TimeoutException {
        try {
            if (!this.completionLatch.await(MachineLearningField.STATE_PERSIST_RESTORE_TIMEOUT.getMinutes(), TimeUnit.MINUTES)) {
                throw new TimeoutException("Timed out waiting for model snapshot upgrader results processor to complete for job " + this.jobId + " and snapshot " + this.snapshotId);
            }
            this.persister.commitWrites(this.jobId, JobResultsPersister.CommitType.STATE);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.info("[{}] [{}] Interrupted waiting for model snapshot upgrade results processor to complete", (Object)this.jobId, (Object)this.snapshotId);
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    private boolean isAlive() {
        if (this.processKilled) {
            return false;
        }
        return this.process.isProcessAliveAfterWaiting();
    }
}

