/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.ml.action.TransportJobTaskAction;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;
import org.elasticsearch.xpack.ml.job.task.JobTask;

public class TransportUpdateProcessAction
extends TransportJobTaskAction<UpdateProcessAction.Request, UpdateProcessAction.Response> {
    @Inject
    public TransportUpdateProcessAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, AutodetectProcessManager processManager) {
        super("cluster:internal/xpack/ml/job/update/process", clusterService, transportService, actionFilters, UpdateProcessAction.Request::new, UpdateProcessAction.Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE, processManager);
    }

    protected void taskOperation(CancellableTask actionTask, UpdateProcessAction.Request request, JobTask task, ActionListener<UpdateProcessAction.Response> listener) {
        UpdateParams updateParams = UpdateParams.builder(request.getJobId()).modelPlotConfig(request.getModelPlotConfig()).perPartitionCategorizationConfig(request.getPerPartitionCategorizationConfig()).detectorUpdates(request.getDetectorUpdates()).filter(request.getFilter()).updateScheduledEvents(request.isUpdateScheduledEvents()).build();
        try {
            this.processManager.writeUpdateProcessMessage(task, updateParams, e -> {
                if (e == null) {
                    listener.onResponse((Object)new UpdateProcessAction.Response());
                } else {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }
}

