/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseMerger;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.xpack.core.async.AsyncTaskIndexService;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.AsyncStatusResponse;
import org.elasticsearch.xpack.search.AsyncSearchTask;

class MutableSearchResponse
implements Releasable {
    private final Logger logger = Loggers.getLogger(this.getClass(), (String[])new String[]{"async"});
    private int totalShards;
    private int skippedShards;
    private SearchResponse.Clusters clusters;
    private AtomicArray<ShardSearchFailure> queryFailures;
    private final ThreadContext threadContext;
    private boolean isPartial = true;
    private int successfulShards;
    private TotalHits totalHits;
    private Supplier<InternalAggregations> reducedAggsSource = () -> null;
    private int reducePhase;
    private SearchResponse finalResponse;
    private ElasticsearchException failure;
    private Map<String, List<String>> responseHeaders;
    private boolean localClusterComplete;
    private List<SearchResponse> clusterResponses;
    private boolean frozen;

    MutableSearchResponse(ThreadContext threadContext) {
        this.threadContext = threadContext;
        this.totalHits = Lucene.TOTAL_HITS_GREATER_OR_EQUAL_TO_ZERO;
        this.localClusterComplete = false;
    }

    synchronized void updateShardsAndClusters(int totalShards, int skippedShards, SearchResponse.Clusters clusters) {
        this.totalShards = totalShards;
        this.skippedShards = skippedShards;
        this.queryFailures = new AtomicArray(totalShards - skippedShards);
        this.clusters = clusters;
    }

    synchronized void updatePartialResponse(int successfulShards, TotalHits totalHits, Supplier<InternalAggregations> reducedAggs, int reducePhase) {
        this.failIfFrozen();
        if (reducePhase < this.reducePhase) {
            throw new IllegalStateException("received partial response out of order: " + reducePhase + " < " + this.reducePhase);
        }
        this.successfulShards = successfulShards + this.skippedShards;
        this.totalHits = totalHits;
        this.reducedAggsSource = reducedAggs;
        this.reducePhase = reducePhase;
    }

    synchronized void updateFinalResponse(SearchResponse response, boolean ccsMinimizeRoundtrips) {
        this.failIfFrozen();
        assert (this.shardsInResponseMatchExpected(response, ccsMinimizeRoundtrips)) : this.getShardsInResponseMismatchInfo(response, ccsMinimizeRoundtrips);
        this.responseHeaders = this.threadContext.getResponseHeaders();
        response.mustIncRef();
        SearchResponse existing = this.finalResponse;
        this.finalResponse = response;
        if (existing != null) {
            existing.decRef();
        }
        this.isPartial = this.isPartialResponse(response);
        this.frozen = true;
    }

    synchronized void updateResponseMinimizeRoundtrips(String clusterAlias, SearchResponse clusterResponse) {
        if (this.clusterResponses == null) {
            this.clusterResponses = new ArrayList<SearchResponse>();
        }
        this.clusterResponses.add(clusterResponse);
        clusterResponse.mustIncRef();
        if ("".equals(clusterAlias)) {
            this.localClusterComplete = true;
        }
    }

    private boolean isPartialResponse(SearchResponse response) {
        if (response.getClusters() == null) {
            return true;
        }
        return response.getClusters().hasPartialResults();
    }

    synchronized void updateWithFailure(ElasticsearchException exc) {
        this.failIfFrozen();
        this.responseHeaders = this.threadContext.getResponseHeaders();
        this.isPartial = true;
        this.failure = exc;
        this.frozen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addQueryFailure(int shardIndex, ShardSearchFailure shardSearchFailure) {
        MutableSearchResponse mutableSearchResponse = this;
        synchronized (mutableSearchResponse) {
            this.failIfFrozen();
        }
        this.queryFailures.set(shardIndex, (Object)shardSearchFailure);
    }

    private SearchResponse buildResponse(long taskStartTimeNanos, InternalAggregations reducedAggs) {
        long tookInMillis = TimeValue.timeValueNanos((long)(System.nanoTime() - taskStartTimeNanos)).getMillis();
        return new SearchResponse(SearchHits.empty((TotalHits)this.totalHits, (float)Float.NaN), reducedAggs, null, false, Boolean.valueOf(false), null, this.reducePhase, null, this.totalShards, this.successfulShards, this.skippedShards, tookInMillis, this.buildQueryFailures(), this.clusters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized AsyncSearchResponse toAsyncSearchResponse(AsyncSearchTask task, long expirationTime, boolean restoreResponseHeaders) {
        SearchResponse searchResponse;
        block18: {
            if (restoreResponseHeaders && this.responseHeaders != null) {
                AsyncTaskIndexService.restoreResponseHeadersContext((ThreadContext)this.threadContext, this.responseHeaders);
            }
            if (this.finalResponse != null) {
                searchResponse = this.finalResponse;
                searchResponse.mustIncRef();
            } else if (this.clusters == null) {
                searchResponse = null;
            } else {
                try (SearchResponseMerger searchResponseMerger = this.createSearchResponseMerger(task);){
                    if (searchResponseMerger == null) {
                        InternalAggregations reducedAggs = this.reducedAggsSource.get();
                        this.reducedAggsSource = () -> reducedAggs;
                        searchResponse = this.buildResponse(task.getStartTimeNanos(), reducedAggs);
                        break block18;
                    }
                    if (!this.localClusterComplete) {
                        InternalAggregations reducedAggs = this.reducedAggsSource.get();
                        this.reducedAggsSource = () -> reducedAggs;
                        SearchResponse partialAggsSearchResponse = this.buildResponse(task.getStartTimeNanos(), reducedAggs);
                        try {
                            searchResponse = this.getMergedResponse(searchResponseMerger, partialAggsSearchResponse);
                            break block18;
                        }
                        finally {
                            partialAggsSearchResponse.decRef();
                        }
                    }
                    searchResponse = this.getMergedResponse(searchResponseMerger);
                }
            }
        }
        try {
            AsyncSearchResponse asyncSearchResponse = new AsyncSearchResponse(task.getExecutionId().getEncoded(), searchResponse, (Exception)this.failure, this.isPartial, !this.frozen, task.getStartTime(), expirationTime);
            return asyncSearchResponse;
        }
        finally {
            if (searchResponse != null) {
                searchResponse.decRef();
            }
        }
    }

    private SearchResponseMerger createSearchResponseMerger(AsyncSearchTask task) {
        if (task.getSearchResponseMergerSupplier() == null) {
            return null;
        }
        return (SearchResponseMerger)task.getSearchResponseMergerSupplier().get();
    }

    private SearchResponse getMergedResponse(SearchResponseMerger merger) {
        return this.getMergedResponse(merger, null);
    }

    private SearchResponse getMergedResponse(SearchResponseMerger merger, SearchResponse localPartialAggsOnly) {
        if (this.clusterResponses != null) {
            for (SearchResponse response : this.clusterResponses) {
                merger.add(response);
            }
        }
        if (localPartialAggsOnly != null) {
            merger.add(localPartialAggsOnly);
        }
        return merger.getMergedResponse(this.clusters);
    }

    synchronized AsyncStatusResponse toStatusResponse(String asyncExecutionId, long startTime, long expirationTime) {
        SearchResponse.Clusters clustersInStatus = null;
        if (this.clusters != null && this.clusters.getTotal() > 0) {
            clustersInStatus = this.clusters;
        }
        if (this.finalResponse != null) {
            return new AsyncStatusResponse(asyncExecutionId, !this.frozen, this.isPartial, startTime, expirationTime, Long.valueOf(startTime + this.finalResponse.getTook().millis()), this.finalResponse.getTotalShards(), this.finalResponse.getSuccessfulShards(), this.finalResponse.getSkippedShards(), this.finalResponse.getShardFailures() != null ? this.finalResponse.getShardFailures().length : 0, this.finalResponse.status(), clustersInStatus);
        }
        if (this.failure != null) {
            return new AsyncStatusResponse(asyncExecutionId, !this.frozen, true, startTime, expirationTime, null, this.totalShards, this.successfulShards, this.skippedShards, this.queryFailures == null ? 0 : this.queryFailures.nonNullLength(), ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)this.failure)), clustersInStatus);
        }
        return new AsyncStatusResponse(asyncExecutionId, true, true, startTime, expirationTime, null, this.totalShards, this.successfulShards, this.skippedShards, this.queryFailures == null ? 0 : this.queryFailures.nonNullLength(), null, clustersInStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized AsyncSearchResponse toAsyncSearchResponse(AsyncSearchTask task, long expirationTime, ElasticsearchException reduceException) {
        if (this.failure != null) {
            reduceException.addSuppressed((Throwable)this.failure);
        }
        SearchResponse response = this.buildResponse(task.getStartTimeNanos(), null);
        try {
            AsyncSearchResponse asyncSearchResponse = new AsyncSearchResponse(task.getExecutionId().getEncoded(), response, (Exception)reduceException, this.isPartial, !this.frozen, task.getStartTime(), expirationTime);
            return asyncSearchResponse;
        }
        finally {
            response.decRef();
        }
    }

    private void failIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("invalid update received after the completion of the request");
        }
    }

    private ShardSearchFailure[] buildQueryFailures() {
        if (this.queryFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        ArrayList<ShardSearchFailure> failures = new ArrayList<ShardSearchFailure>();
        for (int i = 0; i < this.queryFailures.length(); ++i) {
            ShardSearchFailure shardSearchFailure = (ShardSearchFailure)this.queryFailures.get(i);
            if (shardSearchFailure == null) continue;
            failures.add(shardSearchFailure);
        }
        return (ShardSearchFailure[])failures.toArray(ShardSearchFailure[]::new);
    }

    private boolean shardsInResponseMatchExpected(SearchResponse response, boolean ccsMinimizeRoundtrips) {
        if (ccsMinimizeRoundtrips) {
            return response.getTotalShards() >= this.totalShards && response.getSkippedShards() >= this.skippedShards;
        }
        return response.getTotalShards() == this.totalShards && response.getSkippedShards() == this.skippedShards;
    }

    private String getShardsInResponseMismatchInfo(SearchResponse response, boolean ccsMinimizeRoundtrips) {
        if (ccsMinimizeRoundtrips) {
            if (response.getTotalShards() < this.totalShards) {
                return Strings.format((String)"received number of shards (%d) is less than the value notified via onListShards (%d)", (Object[])new Object[]{response.getTotalShards(), this.totalShards});
            }
            if (response.getSkippedShards() < this.skippedShards) {
                return Strings.format((String)"received number of skipped shards (%d) is less than the value notified via onListShards (%d)", (Object[])new Object[]{response.getSkippedShards(), this.skippedShards});
            }
            throw new IllegalStateException("assert method hit unexpected case for ccsMinimizeRoundtrips=true");
        }
        if (response.getTotalShards() != this.totalShards) {
            return Strings.format((String)"received number of shards (%d) differs from the one notified via onListShards (%d)", (Object[])new Object[]{response.getTotalShards(), this.totalShards});
        }
        if (response.getSkippedShards() != this.skippedShards) {
            return Strings.format((String)"received number of skipped shards (%d) differs from the one notified via onListShards (%d)", (Object[])new Object[]{response.getSkippedShards(), this.skippedShards});
        }
        throw new IllegalStateException("assert method hit unexpected case for ccsMinimizeRoundtrips=false");
    }

    public synchronized void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MutableSearchResponse.close(): byThread={}, finalResponsePresent={}, clusterResponsesCount={}, stack={}", (Object)Thread.currentThread().getName(), (Object)(this.finalResponse != null ? 1 : 0), (Object)(this.clusterResponses != null ? this.clusterResponses.size() : 0), (Object)new Exception().getStackTrace());
        }
        if (this.finalResponse != null) {
            this.finalResponse.decRef();
        }
        if (this.clusterResponses != null) {
            for (SearchResponse clusterResponse : this.clusterResponses) {
                clusterResponse.decRef();
            }
        }
    }
}

